/*
 * Decompiled with CFR 0.152.
 */
package kovac.binaryMask;

import icy.file.Saver;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import kovac.binaryMask.BinaryMask;
import kovac.saving.Saving;
import org.apache.commons.io.FilenameUtils;

public class ExportBinaryMask {
    private static Sequence maskSequence;
    private static File savingFile;
    private static boolean isFileChosen;

    private static void createMask(Sequence initialSeq) {
        BinaryMask mask = new BinaryMask(initialSeq);
        maskSequence = mask.buildExitSequence();
    }

    private static void askForSavingFile() {
        JFrame fen = new JFrame("Saving binary mask");
        File defaultDirectory = Saving.getSavingDirectory();
        JFileChooser fileChooser = new JFileChooser(defaultDirectory);
        fileChooser.setFileFilter(new FileNameExtensionFilter("TIFF file", "tif"));
        int returnVal = fileChooser.showSaveDialog(fen);
        if (returnVal == 0) {
            savingFile = fileChooser.getSelectedFile();
            if (FilenameUtils.getExtension((String)savingFile.getName()).equalsIgnoreCase("tif")) {
                savingFile = new File(savingFile.getParentFile(), FilenameUtils.getBaseName((String)(String.valueOf(savingFile.getName()) + ".tif")));
            }
            isFileChosen = true;
        }
    }

    public static void exportMask(Sequence initialSeq) {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                ExportBinaryMask.askForSavingFile();
            }
        });
        if (!isFileChosen) {
            return;
        }
        ExportBinaryMask.createMask(initialSeq);
        Saver.save((Sequence)maskSequence, (File)savingFile, (boolean)false, (boolean)true);
    }
}

