/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugins.tinevez.kymographtracker.ActionPanel;
import plugins.tinevez.kymographtracker.KymographExtractionResult;

class ResultExportPanel
extends ActionPanel
implements SwimmingPoolListener {
    private static final long serialVersionUID = -4840457556328742543L;
    private JTable kymoTable;
    private KymographTableModel kymoTableModel;
    Sequence selectedSequence;
    public static String KYMOGRAPH_RESULTS = "MultipleKymographTrackingResults";

    public ResultExportPanel() {
        this.description = "Results output";
        this.node = new DefaultMutableTreeNode(this.description);
        this.add(new JLabel(this.description));
        this.setBorder(new TitledBorder(this.description));
        this.setLayout(new BorderLayout());
        this.kymoTableModel = new KymographTableModel();
        this.kymoTable = new JTable(this.kymoTableModel);
        this.kymoTable.setSelectionMode(2);
        this.add((Component)new JScrollPane(this.kymoTable), "Center");
        JButton exportButton = new JButton("Export results");
        this.add((Component)exportButton, "South");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResultExportPanel.this.saveResults();
            }
        });
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
    }

    public void enableGUI(boolean enable) {
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
        this.selectedSequence = sequence;
        this.refreshResults();
    }

    private void refreshResults() {
        this.kymoTableModel.clearTable();
        if (this.selectedSequence != null) {
            for (SwimmingObject obj : Icy.getMainInterface().getSwimmingPool().getObjects(KymographExtractionResult.class)) {
                KymographExtractionResult result = (KymographExtractionResult)obj.getObject();
                if (result.sourceSequence != this.selectedSequence) continue;
                this.kymoTableModel.addResult(result);
            }
        }
        this.refreshGUI();
    }

    protected void refreshGUI() {
        if (this.kymoTableModel.results.isEmpty()) {
            this.enableGUI(false);
        } else {
            this.enableGUI(true);
        }
        this.kymoTable.updateUI();
    }

    protected void saveResults() {
        ArrayList<KymographExtractionResult> results = this.kymoTableModel.getSelectedResults();
        if (results.isEmpty()) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML file filter";
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setName("Output xml file selection");
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath().concat(".xml"));
            }
            Document document = XMLUtil.createDocument((boolean)true);
            Element resultsElement = document.createElement(KYMOGRAPH_RESULTS);
            XMLUtil.getRootElement((Document)document).appendChild(resultsElement);
            int idx = 0;
            for (KymographExtractionResult r : results) {
                r.saveToXML(resultsElement, file.getParentFile(), idx++);
            }
            XMLUtil.saveDocument((Document)document, (File)file);
            File XLSFile = new File(file.getParent().concat("/trackingResultsSummary.xls"));
            WritableWorkbook workbook = null;
            try {
                WorkbookSettings wbSettings = new WorkbookSettings();
                wbSettings.setLocale(new Locale("en", "EN"));
                workbook = Workbook.createWorkbook((File)XLSFile, (WorkbookSettings)wbSettings);
            }
            catch (IOException e) {
                e.printStackTrace();
                new AnnounceFrame("Error creating XLS file. Resuls saving aborted!");
                return;
            }
            try {
                int cntR = 0;
                for (KymographExtractionResult r : results) {
                    int cnt2;
                    int cnt;
                    int col;
                    WritableSheet sheet;
                    ArrayList<ArrayList<double[]>> tracks1D;
                    if (r.trackingResults != null && r.trackingResults.tracks1D != null && !r.trackingResults.tracks1D.isEmpty()) {
                        tracks1D = r.trackingResults.tracks1D;
                        sheet = workbook.createSheet(r.roi.getName(), cntR);
                        ++cntR;
                        col = 0;
                        cnt = 0;
                        for (ArrayList<double[]> dList : tracks1D) {
                            sheet.addCell((WritableCell)new Label(col, 0, "track " + cnt + " t"));
                            sheet.addCell((WritableCell)new Label(col + 1, 0, "track " + cnt + " pos"));
                            cnt2 = 1;
                            for (double[] d : dList) {
                                sheet.addCell((WritableCell)new Number(col, cnt2, d[0]));
                                sheet.addCell((WritableCell)new Number(col + 1, cnt2, d[1]));
                                ++cnt2;
                            }
                            col += 2;
                            ++cnt;
                        }
                    }
                    if (r.retrogradeTrackingResults != null && r.retrogradeTrackingResults.tracks1D != null && !r.retrogradeTrackingResults.tracks1D.isEmpty()) {
                        tracks1D = r.retrogradeTrackingResults.tracks1D;
                        sheet = workbook.createSheet(String.valueOf(r.roi.getName()) + "_retrograde", cntR);
                        ++cntR;
                        col = 0;
                        cnt = 0;
                        for (ArrayList<double[]> dList : tracks1D) {
                            sheet.addCell((WritableCell)new Label(col, 0, "track " + cnt + " t"));
                            sheet.addCell((WritableCell)new Label(col + 1, 0, "track " + cnt + " pos"));
                            cnt2 = 1;
                            for (double[] d : dList) {
                                sheet.addCell((WritableCell)new Number(col, cnt2, d[0]));
                                sheet.addCell((WritableCell)new Number(col + 1, cnt2, d[1]));
                                ++cnt2;
                            }
                            col += 2;
                            ++cnt;
                        }
                    }
                    if (r.anterogradeTrackingResults == null || r.anterogradeTrackingResults.tracks1D == null || r.anterogradeTrackingResults.tracks1D.isEmpty()) continue;
                    tracks1D = r.anterogradeTrackingResults.tracks1D;
                    sheet = workbook.createSheet(String.valueOf(r.roi.getName()) + "_anterograde", cntR);
                    ++cntR;
                    col = 0;
                    cnt = 0;
                    for (ArrayList<double[]> dList : tracks1D) {
                        sheet.addCell((WritableCell)new Label(col, 0, "track " + cnt + " t"));
                        sheet.addCell((WritableCell)new Label(col + 1, 0, "track " + cnt + " pos"));
                        cnt2 = 1;
                        for (double[] d : dList) {
                            sheet.addCell((WritableCell)new Number(col, cnt2, d[0]));
                            sheet.addCell((WritableCell)new Number(col + 1, cnt2, d[1]));
                            ++cnt2;
                        }
                        col += 2;
                        ++cnt;
                    }
                }
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
            try {
                if (workbook.getNumberOfSheets() > 0) {
                    workbook.write();
                }
                workbook.close();
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void swimmingPoolChangeEvent(SwimmingPoolEvent event) {
        if (event.getResult().getObject() instanceof KymographExtractionResult) {
            KymographExtractionResult result = (KymographExtractionResult)event.getResult().getObject();
            if (result.sourceSequence == this.selectedSequence) {
                switch (event.getType()) {
                    case ELEMENT_ADDED: {
                        this.kymoTableModel.addResult(result);
                        break;
                    }
                    case ELEMENT_REMOVED: {
                        this.kymoTableModel.removeResult(result);
                    }
                }
                this.refreshGUI();
            }
        }
    }

    class KymographTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -5487686557114899956L;
        ArrayList<KymographExtractionResult> results = new ArrayList();
        ArrayList<Boolean> selection = new ArrayList();

        KymographTableModel() {
        }

        protected void refreshTable() {
            this.fireTableDataChanged();
        }

        public void clearTable() {
            this.results.clear();
            this.selection.clear();
        }

        protected void addResult(KymographExtractionResult result) {
            this.results.add(result);
            this.selection.add(new Boolean(true));
            this.refreshTable();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Selection";
            }
            return "Kymographs";
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            if (this.results == null) {
                return 1;
            }
            return this.results.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (this.results == null) {
                return null;
            }
            if (r >= this.getRowCount() || c >= this.getColumnCount()) {
                return null;
            }
            if (c == 0) {
                return this.selection.get(r);
            }
            if (this.results.get((int)r).roi != null) {
                return this.results.get((int)r).roi.getName();
            }
            return "null";
        }

        public void removeResult(KymographExtractionResult result) {
            int idx = this.results.indexOf(result);
            if (idx >= 0) {
                this.results.remove(idx);
                this.selection.remove(idx);
            }
            this.fireTableRowsDeleted(idx, idx);
        }

        public ArrayList<KymographExtractionResult> getSelectedResults() {
            ArrayList<KymographExtractionResult> selectedList = new ArrayList<KymographExtractionResult>();
            int k = 0;
            while (k < this.selection.size()) {
                if (this.selection.get(k).booleanValue()) {
                    selectedList.add(this.results.get(k));
                }
                ++k;
            }
            return selectedList;
        }
    }
}

