/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker.spline;

import plugins.tinevez.kymographtracker.spline.Polynomial;

public class CubicSmoothingSpline {
    private Polynomial[] splineVector;
    private double[] x;
    private double[] y;
    private double[] weight;
    private double rho;

    public CubicSmoothingSpline(double[] x, double[] y, double[] w, double rho) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        if (w != null && x.length != w.length) {
            throw new IllegalArgumentException("x.length != w.length");
        }
        if (rho < 0.0 || rho > 1.0) {
            throw new IllegalArgumentException("rho not in [0, 1]");
        }
        this.splineVector = new Polynomial[x.length + 1];
        this.rho = rho;
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.weight = new double[x.length];
        if (w == null) {
            int i = 0;
            while (i < this.weight.length) {
                this.weight[i] = 1.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.weight.length) {
                this.weight[i] = w[i];
                ++i;
            }
        }
        this.resolve();
    }

    public CubicSmoothingSpline(double[] x, double[] y, double rho) {
        this(x, y, null, rho);
    }

    public double evaluate(double z) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].evaluate(z - this.x[0]);
        }
        return this.splineVector[i].evaluate(z - this.x[i - 1]);
    }

    public double integral(double a, double b) {
        double retour;
        int iA = this.getFitPolynomialIndex(a);
        int iB = this.getFitPolynomialIndex(b);
        int i = 1;
        if (iA == iB) {
            retour = this.splineVector[iB].integral(a - this.x[iB], b - this.x[iB]);
        } else {
            retour = iA == 0 ? this.splineVector[iA].integral(a - this.x[iA], 0.0) : this.splineVector[iA].integral(a - this.x[iA], this.x[iA + 1] - this.x[iA]);
            i = iA + 1;
            while (i < iB) {
                retour += this.splineVector[i].integral(0.0, this.x[i + 1] - this.x[i]);
                ++i;
            }
            retour += this.splineVector[iB].integral(0.0, b - this.x[iB]);
        }
        return retour;
    }

    public double derivative(double z) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].derivative(z - this.x[0]);
        }
        return this.splineVector[i].derivative(z - this.x[i - 1]);
    }

    public double derivative(double z, int n) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].derivative(z - this.x[0], n);
        }
        return this.splineVector[i].derivative(z - this.x[i - 1], n);
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public double[] getWeights() {
        return this.weight;
    }

    public double getRho() {
        return this.rho;
    }

    public Polynomial[] getSplinePolynomials() {
        return (Polynomial[])this.splineVector.clone();
    }

    public int getFitPolynomialIndex(double x) {
        int j = this.x.length - 1;
        if (x > this.x[j]) {
            return j + 1;
        }
        int tmp = 0;
        int i = 0;
        while (i + 1 != j) {
            if (x > this.x[tmp]) {
                i = tmp;
                tmp = i + (j - i) / 2;
            } else {
                j = tmp;
                tmp = i + (j - i) / 2;
            }
            if (j != 0) continue;
            --i;
        }
        return i + 1;
    }

    private void resolve() {
        double[] h = new double[this.x.length];
        double[] r = new double[this.x.length];
        double[] u = new double[this.x.length];
        double[] v = new double[this.x.length];
        double[] w = new double[this.x.length];
        double[] q = new double[this.x.length + 1];
        double[] sigma = new double[this.weight.length];
        int i = 0;
        while (i < this.weight.length) {
            sigma[i] = this.weight[i] <= 0.0 ? 1.0E100 : 1.0 / Math.sqrt(this.weight[i]);
            ++i;
        }
        int n = this.x.length - 1;
        double mu = this.rho <= 0.0 ? 1.0E100 : 2.0 * (1.0 - this.rho) / (3.0 * this.rho);
        h[0] = this.x[1] - this.x[0];
        r[0] = 3.0 / h[0];
        int i2 = 1;
        while (i2 < n) {
            h[i2] = this.x[i2 + 1] - this.x[i2];
            r[i2] = 3.0 / h[i2];
            q[i2] = 3.0 * (this.y[i2 + 1] - this.y[i2]) / h[i2] - 3.0 * (this.y[i2] - this.y[i2 - 1]) / h[i2 - 1];
            ++i2;
        }
        i2 = 1;
        while (i2 < n) {
            u[i2] = r[i2 - 1] * r[i2 - 1] * sigma[i2 - 1] + (r[i2 - 1] + r[i2]) * (r[i2 - 1] + r[i2]) * sigma[i2] + r[i2] * r[i2] * sigma[i2 + 1];
            u[i2] = mu * u[i2] + 2.0 * (this.x[i2 + 1] - this.x[i2 - 1]);
            v[i2] = -(r[i2 - 1] + r[i2]) * r[i2] * sigma[i2] - r[i2] * (r[i2] + r[i2 + 1]) * sigma[i2 + 1];
            v[i2] = mu * v[i2] + h[i2];
            w[i2] = mu * r[i2] * r[i2 + 1] * sigma[i2 + 1];
            ++i2;
        }
        q = CubicSmoothingSpline.Quincunx(u, v, w, q);
        double[] params = new double[4];
        params[0] = this.y[0] - mu * r[0] * q[1] * sigma[0];
        double dd = this.y[1] - mu * ((-r[0] - r[1]) * q[1] + r[1] * q[2]) * sigma[1];
        params[1] = (dd - params[0]) / h[0] - q[1] * h[0] / 3.0;
        this.splineVector[0] = new Polynomial(params);
        params[0] = this.y[0] - mu * r[0] * q[1] * sigma[0];
        dd = this.y[1] - mu * ((-r[0] - r[1]) * q[1] + r[1] * q[2]) * sigma[1];
        params[3] = q[1] / (3.0 * h[0]);
        params[2] = 0.0;
        params[1] = (dd - params[0]) / h[0] - q[1] * h[0] / 3.0;
        this.splineVector[1] = new Polynomial(params);
        int j = 1;
        while (j < n) {
            params[3] = (q[j + 1] - q[j]) / (3.0 * h[j]);
            params[2] = q[j];
            params[1] = (q[j] + q[j - 1]) * h[j - 1] + this.splineVector[j].getCoefficient(1);
            params[0] = r[j - 1] * q[j - 1] + (-r[j - 1] - r[j]) * q[j] + r[j] * q[j + 1];
            params[0] = this.y[j] - mu * params[0] * sigma[j];
            this.splineVector[j + 1] = new Polynomial(params);
            ++j;
        }
        j = n;
        params[3] = 0.0;
        params[2] = 0.0;
        params[1] = this.splineVector[j].derivative(this.x[this.x.length - 1] - this.x[this.x.length - 2]);
        params[0] = this.splineVector[j].evaluate(this.x[this.x.length - 1] - this.x[this.x.length - 2]);
        this.splineVector[n + 1] = new Polynomial(params);
    }

    private static double[] Quincunx(double[] u, double[] v, double[] w, double[] q) {
        u[0] = 0.0;
        v[1] = v[1] / u[1];
        w[1] = w[1] / u[1];
        int j = 2;
        while (j < u.length - 1) {
            u[j] = u[j] - u[j - 2] * w[j - 2] * w[j - 2] - u[j - 1] * v[j - 1] * v[j - 1];
            v[j] = (v[j] - u[j - 1] * v[j - 1] * w[j - 1]) / u[j];
            w[j] = w[j] / u[j];
            ++j;
        }
        q[1] = q[1] - v[0] * q[0];
        j = 2;
        while (j < u.length - 1) {
            q[j] = q[j] - v[j - 1] * q[j - 1] - w[j - 2] * q[j - 2];
            ++j;
        }
        j = 1;
        while (j < u.length - 1) {
            q[j] = q[j] / u[j];
            ++j;
        }
        q[u.length - 1] = 0.0;
        j = u.length - 3;
        while (j > 0) {
            q[j] = q[j] - v[j] * q[j + 1] - w[j] * q[j + 2];
            --j;
        }
        return q;
    }
}

