/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletConfig;

public class RieszWaveletCoefficients {
    RieszWaveletConfig rieszWaveletConfig;
    ArrayList<RieszGeneralization> generalizationList;
    double[] hpResidual;
    double[] lpResidual;
    ArrayList<double[][]> rieszWaveletBandMultiscale;
    int padX;
    int padY;

    public RieszWaveletCoefficients(RieszWaveletConfig config, ArrayList<RieszGeneralization> generalizationList, ArrayList<double[][]> bands, double[] hpResidual, double[] lpResidual, int padX, int padY) {
        this.rieszWaveletConfig = config;
        this.generalizationList = generalizationList;
        this.hpResidual = hpResidual;
        this.lpResidual = lpResidual;
        this.rieszWaveletBandMultiscale = bands;
        this.padX = padX;
        this.padY = padY;
    }

    public RieszWaveletCoefficients duplicateCoefficients() {
        ArrayList<RieszGeneralization> generalizationList2 = new ArrayList<RieszGeneralization>(this.generalizationList);
        ArrayList<double[][]> bands2 = new ArrayList<double[][]>(this.rieszWaveletBandMultiscale.size());
        int i = 0;
        while (i < this.rieszWaveletBandMultiscale.size()) {
            double[][] b = new double[this.rieszWaveletBandMultiscale.get(i).length][];
            int j = 0;
            while (j < b.length) {
                b[j] = (double[])this.rieszWaveletBandMultiscale.get(i)[j].clone();
                ++j;
            }
            bands2.add(b);
            ++i;
        }
        double[] hpResidual2 = null;
        if (this.hpResidual != null) {
            hpResidual2 = (double[])this.hpResidual.clone();
        }
        double[] lpResidual2 = null;
        if (this.lpResidual != null) {
            lpResidual2 = (double[])this.lpResidual.clone();
        }
        return new RieszWaveletCoefficients(this.rieszWaveletConfig, generalizationList2, bands2, hpResidual2, lpResidual2, this.padX, this.padY);
    }

    public double[][] getRieszBandsAtScale(int scale) {
        return this.rieszWaveletBandMultiscale.get(scale);
    }

    public double[] getHPResidual() {
        return this.hpResidual;
    }

    public double[] getLPResidual() {
        return this.lpResidual;
    }

    public void setRieszBandsAtScale(int scale, double[][] coefficients) {
        this.rieszWaveletBandMultiscale.set(scale, coefficients);
    }

    public void setLPResidual(double[] residual) {
        this.lpResidual = residual;
    }

    public void setHPResidual(double[] residual) {
        this.hpResidual = residual;
    }

    public RieszWaveletConfig getConfig() {
        return this.rieszWaveletConfig;
    }

    public void displayCoefficients(int scale) {
        RieszGeneralization generalization = this.generalizationList.get(scale);
        double[][] rieszWaveletBand = this.getRieszBandsAtScale(scale);
        if (generalization.realCoefficients) {
            Sequence realSequence = new Sequence();
            realSequence.setName("Real part at scale" + scale);
            int j = 0;
            while (j < rieszWaveletBand.length) {
                realSequence.setImage(0, j, (BufferedImage)new IcyBufferedImage(this.rieszWaveletConfig.waveletsConfig.getScaleWidth(scale), this.rieszWaveletConfig.waveletsConfig.getScaleHeight(scale), (Object)rieszWaveletBand[j]));
                ++j;
            }
            Icy.getMainInterface().addSequence(realSequence);
        } else {
            Sequence realSequence = new Sequence();
            realSequence.setName("Real part at scale " + scale);
            Sequence imaginarySequence = new Sequence();
            imaginarySequence.setName("Imaginary part at scale " + scale);
            int j = 0;
            while (j < rieszWaveletBand.length) {
                double[] realPart = new double[rieszWaveletBand[j].length / 2];
                double[] imaginaryPart = new double[rieszWaveletBand[j].length / 2];
                int t = 0;
                while (t < realPart.length) {
                    realPart[t] = rieszWaveletBand[j][2 * t];
                    imaginaryPart[t] = rieszWaveletBand[j][2 * t + 1];
                    ++t;
                }
                realSequence.addImage(j, (BufferedImage)new IcyBufferedImage(this.rieszWaveletConfig.waveletsConfig.getScaleWidth(scale), this.rieszWaveletConfig.waveletsConfig.getScaleHeight(scale), (Object)realPart));
                imaginarySequence.addImage(j, (BufferedImage)new IcyBufferedImage(this.rieszWaveletConfig.waveletsConfig.getScaleWidth(scale), this.rieszWaveletConfig.waveletsConfig.getScaleHeight(scale), (Object)imaginaryPart));
                ++j;
            }
            Icy.getMainInterface().addSequence(realSequence);
            Icy.getMainInterface().addSequence(imaginarySequence);
        }
    }

    public int getNumScales() {
        return this.rieszWaveletConfig.getNumScales();
    }

    public int getPadX() {
        return this.padX;
    }

    public int getPadY() {
        return this.padY;
    }

    public ArrayList<RieszGeneralization> getGeneralizationList() {
        return new ArrayList<RieszGeneralization>(this.generalizationList);
    }
}

