/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.pathtracing;

import icy.canvas.IcyCanvas;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import plugins.tinevez.pathtracing.PathEvent;
import plugins.tinevez.pathtracing.PathListener;

public class InteractiveDjikstraTracing
extends Overlay {
    Sequence seq = null;
    int width;
    int height;
    double[] dataSave = null;
    double[][] optimalPath = null;
    int[] pathMap = null;
    boolean verticalPath = false;
    boolean mapReady = false;
    double maxIntensity;
    ArrayList<Thread> mapThreadList = new ArrayList();
    ArrayList<Thread> pathThreadList = new ArrayList();
    Vector<Thread> runningThreads = new Vector();
    double alpha;
    private boolean isEnabled = true;
    private ArrayList<PathListener> pathListenerList;
    int xInit;
    int yInit;
    int xFinal;
    int yFinal;
    public Lock mapThreadListLock = new ReentrantLock();
    public Lock pathThreadListLock = new ReentrantLock();
    public Lock pathLock = new ReentrantLock();
    public Lock initLock = new ReentrantLock();
    public Lock dataSaveLock = new ReentrantLock();
    public Lock distanceMapLock = new ReentrantLock();
    public Lock visitedLock = new ReentrantLock();
    public Condition visitedCondition = this.visitedLock.newCondition();
    private DrawingState state;

    public InteractiveDjikstraTracing(Sequence seq) throws IllegalArgumentException {
        this(seq, 1.0E-4);
    }

    public InteractiveDjikstraTracing(Sequence seq, double alpha) throws IllegalArgumentException {
        super("Tracer");
        if (seq != null) {
            this.state = DrawingState.RESET;
            this.seq = seq;
            if (seq.getSizeT() > 1 || seq.getSizeZ() > 1) {
                throw new IllegalArgumentException("Sorry but the ShortestPath algoritm can only process a 2D image. You should extract first a single image of interest from the focused sequence.");
            }
            if (alpha < 0.0) {
                throw new IllegalArgumentException("Regularization parameter should be positive in InteractiveDjisktraTracing");
            }
            this.alpha = alpha;
            this.width = seq.getWidth();
            this.height = seq.getHeight();
            boolean component = false;
            IcyBufferedImage image = seq.getFirstImage();
            this.dataSaveLock.lock();
            this.dataSave = (double[])ArrayUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
            this.maxIntensity = 0.0;
            int i = 0;
            while (i < this.dataSave.length) {
                if (this.dataSave[i] > this.maxIntensity) {
                    this.maxIntensity = this.dataSave[i];
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Sequence is null in InteractiveDjisktraTracing");
        }
        this.dataSaveLock.unlock();
        this.pathListenerList = new ArrayList();
    }

    public void addPathLister(PathListener listener) {
        this.pathListenerList.add(listener);
    }

    public void removePathLister(PathListener listener) {
        this.pathListenerList.remove(listener);
    }

    public void paint(Graphics2D g2d, Sequence sequence, IcyCanvas canvas) {
        if (this.isEnabled && this.optimalPath != null) {
            g2d.setStroke(new BasicStroke(0.5f));
            g2d.setColor(Color.yellow);
            this.pathLock.lock();
            int cnt = 0;
            while (cnt < this.optimalPath.length) {
                Ellipse2D.Float ell = new Ellipse2D.Float((float)((int)this.optimalPath[cnt][0]) - 0.25f, (float)((int)this.optimalPath[cnt][1]) - 0.25f, 0.5f, 0.5f);
                g2d.fill(ell);
                if (cnt > 0) {
                    Line2D.Float l = new Line2D.Float((int)this.optimalPath[cnt][0], (int)this.optimalPath[cnt][1], (int)this.optimalPath[cnt - 1][0], (int)this.optimalPath[cnt - 1][1]);
                    g2d.draw(l);
                }
                ++cnt;
            }
            this.pathLock.unlock();
        }
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled) {
            switch (this.state) {
                case RESET: 
                case SECOND_CLICKED: {
                    this.mapThreadListLock.lock();
                    for (Thread t : this.mapThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    this.mapThreadListLock.unlock();
                    this.pathThreadListLock.lock();
                    for (Thread t : this.pathThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    this.pathThreadListLock.unlock();
                    this.initLock.lock();
                    int xi = (int)Math.round(imagePoint.getX());
                    int yi = (int)Math.round(imagePoint.getY());
                    if (xi < 0 || xi >= this.width || yi < 0 || yi >= this.height) break;
                    this.xInit = xi;
                    this.yInit = yi;
                    StoppableThread thr = null;
                    thr = this.verticalPath ? new ComputeMapThreadToTop(this.xInit, this.yInit) : new ComputeMapThread(this.xInit, this.yInit);
                    this.initLock.unlock();
                    this.mapReady = false;
                    this.mapThreadListLock.lock();
                    this.mapThreadList.add(thr);
                    this.mapThreadListLock.unlock();
                    thr.start();
                    this.state = DrawingState.FIRST_CLICKED;
                    break;
                }
                case FIRST_CLICKED: {
                    if (this.mapReady) {
                        this.pathThreadListLock.lock();
                        for (Thread t : this.pathThreadList) {
                            ((StoppableThread)t).stopThread();
                        }
                        this.pathThreadListLock.unlock();
                        int xF = (int)Math.round(imagePoint.getX());
                        int yF = (int)Math.round(imagePoint.getY());
                        if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                            this.xFinal = xF;
                            this.yFinal = yF;
                            this.initLock.lock();
                            ComputePathThread thr = new ComputePathThread(this.xInit, this.yInit, this.xFinal, this.yFinal);
                            this.initLock.unlock();
                            this.pathThreadListLock.lock();
                            this.pathThreadList.add(thr);
                            this.pathThreadListLock.unlock();
                            thr.start();
                        }
                    } else {
                        this.pathThreadListLock.lock();
                        for (Thread t : this.pathThreadList) {
                            ((StoppableThread)t).stopThread();
                        }
                        this.pathThreadListLock.unlock();
                        int xF = (int)Math.round(imagePoint.getX());
                        int yF = (int)Math.round(imagePoint.getY());
                        if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                            this.xFinal = xF;
                            this.yFinal = yF;
                            this.initLock.lock();
                            ComputePathThreadWaiting thr = new ComputePathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal);
                            this.initLock.unlock();
                            this.pathThreadListLock.lock();
                            this.pathThreadList.add(thr);
                            this.pathThreadListLock.unlock();
                            thr.start();
                        }
                    }
                    this.state = DrawingState.SECOND_CLICKED;
                }
            }
        }
    }

    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled && this.state == DrawingState.FIRST_CLICKED) {
            if (this.mapReady) {
                this.pathThreadListLock.lock();
                for (Thread t : this.pathThreadList) {
                    ((StoppableThread)t).stopThread();
                }
                this.pathThreadListLock.unlock();
                int xF = (int)Math.round(imagePoint.getX());
                int yF = (int)Math.round(imagePoint.getY());
                if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                    this.xFinal = xF;
                    this.yFinal = yF;
                    this.initLock.lock();
                    ComputePathThread thr = new ComputePathThread(this.xInit, this.yInit, this.xFinal, this.yFinal);
                    this.initLock.unlock();
                    this.pathThreadListLock.lock();
                    this.pathThreadList.add(thr);
                    this.pathThreadListLock.unlock();
                    thr.start();
                }
            } else {
                this.pathThreadListLock.lock();
                for (Thread t : this.pathThreadList) {
                    ((StoppableThread)t).stopThread();
                }
                this.pathThreadListLock.unlock();
                int xF = (int)Math.round(imagePoint.getX());
                int yF = (int)Math.round(imagePoint.getY());
                if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                    this.xFinal = xF;
                    this.yFinal = yF;
                    this.initLock.lock();
                    ComputePathThreadWaiting thr = new ComputePathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal);
                    this.initLock.unlock();
                    this.pathThreadListLock.lock();
                    this.pathThreadList.add(thr);
                    this.pathThreadListLock.unlock();
                    thr.start();
                }
            }
        }
    }

    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public Number getIntensityAt(double x, double y) {
        if (this.dataSave != null && x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height) {
            return this.dataSave[(int)Math.round(x) + (int)Math.round(y) * this.width];
        }
        return -1;
    }

    public double[][] getOptimalPathCopy() {
        if (this.optimalPath == null) {
            return null;
        }
        this.pathLock.lock();
        double[][] pathClone = new double[this.optimalPath.length][];
        int i = 0;
        while (i < this.optimalPath.length) {
            pathClone[i] = (double[])this.optimalPath[i].clone();
            ++i;
        }
        this.pathLock.unlock();
        return pathClone;
    }

    public void enable() {
        this.isEnabled = true;
        this.seq.overlayChanged((Overlay)this);
    }

    public void disable() {
        this.isEnabled = false;
        this.seq.overlayChanged((Overlay)this);
    }

    class ComputeMapThread
    extends StoppableThread {
        int xInit;
        int yInit;
        double[] dist;
        int[] prev;
        boolean[] visited;
        double[] data;
        boolean run;

        public ComputeMapThread(int xInit, int yInit) {
            this.dist = new double[InteractiveDjikstraTracing.this.width * InteractiveDjikstraTracing.this.height];
            this.prev = new int[InteractiveDjikstraTracing.this.width * InteractiveDjikstraTracing.this.height];
            this.visited = new boolean[InteractiveDjikstraTracing.this.width * InteractiveDjikstraTracing.this.height];
            this.data = null;
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            InteractiveDjikstraTracing.this.dataSaveLock.lock();
            this.data = new double[InteractiveDjikstraTracing.this.dataSave.length];
            System.arraycopy(InteractiveDjikstraTracing.this.dataSave, 0, this.data, 0, this.data.length);
            InteractiveDjikstraTracing.this.dataSaveLock.lock();
        }

        @Override
        public void run() {
            int u = 0;
            while (u < this.dist.length) {
                this.dist[u] = Double.MAX_VALUE;
                ++u;
            }
            int idxInit = this.yInit * InteractiveDjikstraTracing.this.width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width);
                    }
                    if (currentX < InteractiveDjikstraTracing.this.width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width + 1);
                        }
                        if (currentY < InteractiveDjikstraTracing.this.height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width + 1);
                        }
                    }
                } else if (currentX < InteractiveDjikstraTracing.this.width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width);
                    }
                } else {
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveDjikstraTracing.this.width);
                    }
                    if (currentY < InteractiveDjikstraTracing.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveDjikstraTracing.this.width);
                    }
                }
                this.visited[currentIdx] = true;
                InteractiveDjikstraTracing.this.visitedLock.lock();
                InteractiveDjikstraTracing.this.visitedCondition.signalAll();
                InteractiveDjikstraTracing.this.visitedLock.unlock();
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                int cnt = 0;
                while (cnt < this.dist.length) {
                    if (!this.visited[cnt] && (this.dist[cnt] < minDist || minIdx == -1)) {
                        minDist = this.dist[cnt];
                        minIdx = cnt;
                    }
                    ++cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / InteractiveDjikstraTracing.this.width;
                currentX = currentIdx - InteractiveDjikstraTracing.this.width * currentY;
            }
            if (this.run) {
                InteractiveDjikstraTracing.this.distanceMapLock.lock();
                InteractiveDjikstraTracing.this.pathMap = this.prev;
                InteractiveDjikstraTracing.this.distanceMapLock.unlock();
                InteractiveDjikstraTracing.this.mapReady = true;
            }
            InteractiveDjikstraTracing.this.mapThreadListLock.lock();
            InteractiveDjikstraTracing.this.mapThreadList.remove(this);
            InteractiveDjikstraTracing.this.mapThreadListLock.unlock();
            InteractiveDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveDjikstraTracing.this);
        }

        public double dist(double i1, double i2) {
            return InteractiveDjikstraTracing.this.maxIntensity / (i2 + InteractiveDjikstraTracing.this.alpha);
        }

        private void test(double currentDist, double refI, int currentIdx, int idx) {
            double d;
            if (!this.visited[idx] && (d = currentDist + this.dist(refI, this.data[idx])) < this.dist[idx]) {
                this.dist[idx] = d;
                this.prev[idx] = currentIdx;
            }
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputeMapThreadToTop
    extends StoppableThread {
        int xInit;
        int yInit;
        double[] dist;
        int[] prev;
        boolean[] visited;
        double[] data;
        boolean run;

        public ComputeMapThreadToTop(int xInit, int yInit) {
            this.dist = null;
            this.prev = null;
            this.visited = null;
            this.data = null;
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            InteractiveDjikstraTracing.this.dataSaveLock.lock();
            this.data = new double[InteractiveDjikstraTracing.this.dataSave.length];
            System.arraycopy(InteractiveDjikstraTracing.this.dataSave, 0, this.data, 0, this.data.length);
            InteractiveDjikstraTracing.this.dataSaveLock.lock();
        }

        @Override
        public void run() {
            int width = InteractiveDjikstraTracing.this.seq.getWidth();
            int height = InteractiveDjikstraTracing.this.seq.getHeight();
            this.dist = new double[width * height];
            this.prev = new int[width * height];
            this.visited = new boolean[width * height];
            int u = 0;
            while (u < this.dist.length) {
                this.dist[u] = Double.MAX_VALUE;
                this.visited[u] = false;
                ++u;
            }
            int idxInit = this.yInit * width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentY > this.yInit) {
                    if (currentX > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    }
                    if (currentX < width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    }
                    if (currentY < height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + width);
                        if (currentX > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx + width - 1);
                        }
                        if (currentX < width - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + width + 1);
                        }
                    }
                } else if (currentY < this.yInit) {
                    if (currentX > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    }
                    if (currentX < width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    }
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - width);
                        if (currentX > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx - width - 1);
                        }
                        if (currentX < width - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx - width + 1);
                        }
                    }
                } else if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - width);
                    }
                    if (currentY < height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + width);
                    }
                    if (currentX < width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx - width + 1);
                        }
                        if (currentY < height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + width + 1);
                        }
                    }
                } else if (currentX < width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - width);
                    }
                    if (currentY < height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + width);
                    }
                } else {
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - width);
                    }
                    if (currentY < height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + width);
                    }
                }
                this.visited[currentIdx] = true;
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                int cnt = 0;
                while (cnt < this.dist.length) {
                    if (!this.visited[cnt] && (this.dist[cnt] < minDist || minIdx == -1)) {
                        minDist = this.dist[cnt];
                        minIdx = cnt;
                    }
                    ++cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / width;
                currentX = currentIdx - width * currentY;
            }
            if (this.run) {
                InteractiveDjikstraTracing.this.distanceMapLock.lock();
                InteractiveDjikstraTracing.this.pathMap = this.prev;
                InteractiveDjikstraTracing.this.distanceMapLock.unlock();
                InteractiveDjikstraTracing.this.mapReady = true;
            }
            InteractiveDjikstraTracing.this.mapThreadListLock.lock();
            InteractiveDjikstraTracing.this.mapThreadList.remove(this);
            InteractiveDjikstraTracing.this.mapThreadListLock.unlock();
            InteractiveDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveDjikstraTracing.this);
        }

        public double dist(double i1, double i2) {
            return InteractiveDjikstraTracing.this.maxIntensity / (i2 + InteractiveDjikstraTracing.this.alpha);
        }

        private void test(double currentDist, double refI, int currentIdx, int idx) {
            double d;
            if (!this.visited[idx] && (d = currentDist + this.dist(refI, this.data[idx])) < this.dist[idx]) {
                this.dist[idx] = d;
                this.prev[idx] = currentIdx;
            }
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputePathThread
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run;

        public ComputePathThread(int xInit, int yInit, int xFinal, int yFinal) {
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        @Override
        public void run() {
            InteractiveDjikstraTracing.this.distanceMapLock.lock();
            int[] prev = new int[InteractiveDjikstraTracing.this.pathMap.length];
            System.arraycopy(InteractiveDjikstraTracing.this.pathMap, 0, prev, 0, prev.length);
            InteractiveDjikstraTracing.this.distanceMapLock.unlock();
            int width = InteractiveDjikstraTracing.this.seq.getWidth();
            int idxInit = this.xInit + this.yInit * width;
            int idxFinal = this.xFinal + this.yFinal * width;
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            int cnt = 0;
            while (cnt < pathLength) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % width, tmp / width};
                ++cnt;
            }
            if (this.run) {
                InteractiveDjikstraTracing.this.pathLock.lock();
                InteractiveDjikstraTracing.this.optimalPath = pathTab;
                if (!InteractiveDjikstraTracing.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveDjikstraTracing.this.optimalPath.length][];
                    int i = 0;
                    while (i < InteractiveDjikstraTracing.this.optimalPath.length) {
                        pathClone[i] = (double[])InteractiveDjikstraTracing.this.optimalPath[i].clone();
                        ++i;
                    }
                    if (InteractiveDjikstraTracing.this.state == DrawingState.SECOND_CLICKED) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveDjikstraTracing.this.pathLock.unlock();
                InteractiveDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveDjikstraTracing.this);
            }
            InteractiveDjikstraTracing.this.pathThreadListLock.lock();
            InteractiveDjikstraTracing.this.pathThreadList.remove(this);
            InteractiveDjikstraTracing.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputePathThreadWaiting
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run;

        public ComputePathThreadWaiting(int xInit, int yInit, int xFinal, int yFinal) {
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        @Override
        public void run() {
            boolean found = false;
            boolean wait = false;
            int idxInit = this.xInit + this.yInit * InteractiveDjikstraTracing.this.width;
            int idxFinal = this.xFinal + this.yFinal * InteractiveDjikstraTracing.this.width;
            ArrayList<Thread> threadList = new ArrayList<Thread>();
            int[] prev = new int[InteractiveDjikstraTracing.this.width * InteractiveDjikstraTracing.this.height];
            block4: while (this.run && !found) {
                InteractiveDjikstraTracing.this.mapThreadListLock.lock();
                threadList = new ArrayList();
                threadList.addAll(InteractiveDjikstraTracing.this.mapThreadList);
                InteractiveDjikstraTracing.this.mapThreadListLock.unlock();
                for (Thread thr : threadList) {
                    ComputeMapThread mapThread = (ComputeMapThread)thr;
                    if (mapThread.run && mapThread.xInit == this.xInit && mapThread.yInit == mapThread.yInit) {
                        if (mapThread.visited[idxFinal]) {
                            InteractiveDjikstraTracing.this.visitedLock.lock();
                            System.arraycopy(mapThread.prev, 0, prev, 0, mapThread.prev.length);
                            found = true;
                            InteractiveDjikstraTracing.this.visitedLock.unlock();
                            continue block4;
                        }
                        wait = true;
                        continue block4;
                    }
                    if (!wait) continue;
                    InteractiveDjikstraTracing.this.visitedLock.lock();
                    try {
                        try {
                            InteractiveDjikstraTracing.this.visitedCondition.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            InteractiveDjikstraTracing.this.visitedLock.unlock();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        InteractiveDjikstraTracing.this.visitedLock.unlock();
                        throw throwable;
                    }
                    InteractiveDjikstraTracing.this.visitedLock.unlock();
                }
            }
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            int cnt = 0;
            while (cnt < pathLength) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % InteractiveDjikstraTracing.this.width, tmp / InteractiveDjikstraTracing.this.width};
                ++cnt;
            }
            if (this.run) {
                InteractiveDjikstraTracing.this.pathLock.lock();
                InteractiveDjikstraTracing.this.optimalPath = pathTab;
                if (!InteractiveDjikstraTracing.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveDjikstraTracing.this.optimalPath.length][];
                    int i = 0;
                    while (i < InteractiveDjikstraTracing.this.optimalPath.length) {
                        pathClone[i] = (double[])InteractiveDjikstraTracing.this.optimalPath[i].clone();
                        ++i;
                    }
                    if (InteractiveDjikstraTracing.this.state == DrawingState.SECOND_CLICKED) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveDjikstraTracing.this.pathLock.unlock();
                InteractiveDjikstraTracing.this.seq.overlayChanged((Overlay)InteractiveDjikstraTracing.this);
            }
            InteractiveDjikstraTracing.this.pathThreadListLock.lock();
            InteractiveDjikstraTracing.this.pathThreadList.remove(this);
            InteractiveDjikstraTracing.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    public static enum DrawingState {
        RESET,
        FIRST_CLICKED,
        SECOND_CLICKED;

    }

    class FireListenersThread
    extends Thread {
        double[][] path;
        PathEvent pathEvent;

        public FireListenersThread(double[][] path, PathEvent event) {
            InteractiveDjikstraTracing.this.runningThreads.add(this);
            this.path = path;
            this.pathEvent = event;
        }

        @Override
        public void run() {
            for (PathListener listener : InteractiveDjikstraTracing.this.pathListenerList) {
                listener.refreshPath(this.pathEvent, (Object)InteractiveDjikstraTracing.this, this.path);
            }
            InteractiveDjikstraTracing.this.runningThreads.remove(this);
        }
    }

    abstract class StoppableThread
    extends Thread {
        StoppableThread() {
        }

        public abstract void stopThread();
    }
}

