package plugins.spop.medianfilter;

import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;

public class MedianFilter extends EzPlug implements Block{
	
	/**
	 * Median Filter
	 * 
	 * @author Sorin POP
	 * 
	 */

	EzVarSequence input = new EzVarSequence("Input");
	EzVarText	type_2D = new EzVarText("Type", new String[] { "2D","3D" },0, false);
	EzVarInteger size=new EzVarInteger("Half Size",2,1,30,1);
	
	EzVarSequence output = new EzVarSequence("Output");
	
	
	@Override
	public void initialize() {
		// TODO Auto-generated method stub
		super.addEzComponent(input);
		super.addEzComponent(type_2D);
		
		super.addEzComponent(size);
	
		super.setTimeDisplay(true);
		
	}

	
	@Override
	public void execute() {
		
		
		Sequence sequence = input.getValue(true);
		
		int dim_window=size.getValue();
		if(type_2D.getValue().equalsIgnoreCase("2D"))		
			Median_filter_2D(sequence, dim_window);	
		else
			Median_filter_3D(sequence, dim_window);	
		
			
	}
	
	public void Median_filter_2D(Sequence sequence, int lx){
		
		int no_elem, temp,i;
		
		no_elem=(2*lx+1)*(2*lx+1);
		double[] tab_elem= new double[no_elem];
				
		Sequence seq_out = new Sequence();       
        int dim_x = sequence.getSizeX();
        int dim_y = sequence.getSizeY();
        int dim_z = sequence.getSizeZ();
        int dim_t = sequence.getSizeT();
        int dim_c = sequence.getSizeC();
       
        
        for (int time_slice = 0; time_slice < dim_t; time_slice++)
        {
        	for (int z =  0 ; z < dim_z; z++)
        	{
        		IcyBufferedImage icy_img = new IcyBufferedImage(dim_x, dim_y, dim_c, sequence.getDataType());
	        	for (int c = 0; c < dim_c; c++)
	        	{
		            double[] tab = Array1DUtil.arrayToDoubleArray(sequence.getDataXY(time_slice, z, c), false);
		            double[] tab_out = Array1DUtil.arrayToDoubleArray(sequence.getDataXY(time_slice, z, c), false);
		           	         
		            for (int x = lx; x < dim_x-lx; x++)
		            for (int y = lx; y < dim_y-lx; y++)
		            {
		            	i=0;
		            	temp=y*dim_x+x;
		            	for (int xl = -lx; xl <= lx; xl++)
		                    for (int yl = -lx; yl <= lx; yl++)
		                    {
		                    	tab_elem[i]=tab[temp+yl*dim_x+xl];
		                    	i++;
		                    }
		            	tab_out[temp]=ArrayMath.median(tab_elem,false);
		            }
		            Array1DUtil.doubleArrayToSafeArray(tab_out, icy_img.getDataXY(c), icy_img.isSignedDataType());		            
	        	}
	        	seq_out.setImage(time_slice, z, icy_img);
	        	
        	}        	
        }
        seq_out.updateComponentsBounds();
        seq_out.setName("Median Filter 2D");
        if(getUI()!=null)
			addSequence(seq_out);
		output.setValue(seq_out);
        		
	}

	public void Median_filter_3D(Sequence sequence, int lx){
		
		int  no_elem, temp,i;
		
		no_elem=(2*lx+1)*(2*lx+1)*(2*lx+1);
		double[] tab_elem= new double[no_elem];
		double[] tab_elem_2D= new double[(2*lx+1)*(2*lx+1)];
		
		Sequence seq_out = new Sequence();       
	    int dim_x = sequence.getSizeX();
	    int dim_y = sequence.getSizeY();
	    int dim_z = sequence.getSizeZ();
	    int dim_t = sequence.getSizeT();
	    int dim_c = sequence.getSizeC();
	    
	    double[][] tab     = new double[dim_z][];
	    double[][] tab_out = new double[dim_z][dim_x*dim_y];
	    
	    
	    for (int time_slice = 0; time_slice < dim_t; time_slice++)
	    {
    		IcyBufferedImage[] icy_img = new IcyBufferedImage[dim_z];
    		for (int z = 0; z < dim_z; z++)
    			icy_img[z] = new IcyBufferedImage(dim_x, dim_y, dim_c, sequence.getDataType());
    		
        	for (int c = 0; c < dim_c; c++)
        	{
        		for (int z = 0; z < dim_z; z++)
        		{
        			tab[z] = Array1DUtil.arrayToDoubleArray(sequence.getDataXY(time_slice, z, c), false);
        			tab_out[z] = Array1DUtil.arrayToDoubleArray(sequence.getDataXY(time_slice, z, c), false);
        		}
	           	         
	            
	            	for (int z = 0; z < dim_z ; z++)
	            	{
	            		
	            		if(z<lx||z>=dim_z-lx)
	            		{
	            	        for (int x = lx; x < dim_x-lx; x++)
	            	            for (int y = lx; y < dim_y-lx; y++)
	            	            {
	            	            	i=0;
	            	            	temp=y*dim_x+x;
	            	            	
	            	            	for (int xl = -lx; xl <= lx; xl++)
	            	                    for (int yl = -lx; yl <= lx; yl++)
	            	                    {
	            	                    	tab_elem_2D[i]=tab[z][temp+yl*dim_x+xl];
	            	                    	i++;
	            	                    }
	            	            	tab_out[z][temp]=ArrayMath.median(tab_elem_2D,false);
	            	            }
	            		}
	            		else
	            		{
	            			for (int x = lx; x < dim_x-lx; x++)
	            	            for (int y = lx; y < dim_y-lx; y++)
	            	            {
	            	            	i=0;
	            	            	temp=y*dim_x+x;
	            	            	for (int zl = -lx; zl <= lx; zl++)
	            		            	for (int xl = -lx; xl <= lx; xl++)
	            		                    for (int yl = -lx; yl <= lx; yl++)
	            		                    {
	            		                    	tab_elem[i]=tab[z+zl][temp+yl*dim_x+xl];
	            		                    	i++;
	            		                    }
	            		            	tab_out[z][temp]=ArrayMath.median(tab_elem,false);
	            	            }			
	            		}
	            	}
	            	
	            
	            for (int z = 0; z < dim_z; z++)
	            	Array1DUtil.doubleArrayToSafeArray(tab_out[z], icy_img[z].getDataXY(c), icy_img[z].isSignedDataType());	
	            System.gc();
        	}
        	for (int z = 0; z < dim_z; z++)
        		seq_out.setImage(time_slice, z, icy_img[z]);
	        	
	    	      	
	    }
	    seq_out.updateComponentsBounds();
	    
	    seq_out.setName("Median Filter 3D");
	    if(getUI()!=null)
			addSequence(seq_out);
		output.setValue(seq_out);
	}

	public void clean()
	{
	}


	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub
		inputMap.add(input.getVariable());
		inputMap.add(type_2D.getVariable());
		inputMap.add(size.getVariable());
	}


	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add(output.getVariable());
	}

}

