package plugins.tprovoost.contextualpainter;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.point.Point5D.Double;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import javax.swing.JPopupMenu;

import plugins.tprovoost.contextualpainter.popups.PopupClassic;
import plugins.tprovoost.contextualpainter.popups.PopupROI;

public class ContextualPainter extends Overlay
{
    ROI selectedRoi;

    public ContextualPainter()
    {
        super("Context Menu");

        selectedRoi = null;
    }

    @Override
    public void mouseClick(MouseEvent e, Double imagePoint, IcyCanvas canvas)
    {
        if (e.isConsumed())
            return;

        final Sequence seq = canvas.getSequence();

        if ((e.getClickCount() == 1) && (e.getButton() == MouseEvent.BUTTON3))
        {
            JPopupMenu popup = null;

            if ((seq != null) && (imagePoint != null))
            {                
                final Point2D imagePoint2d = imagePoint.toPoint2D();
                final ROI focusedRoi = canvas.getSequence().getFocusedROI();

                if (focusedRoi != null)
                {
                    seq.setSelectedROI(focusedRoi);
                    popup = new PopupROI(focusedRoi, e, imagePoint2d, canvas);
                    selectedRoi = focusedRoi;
                }
                else
                {
                    if ((selectedRoi != null) && selectedRoi.getBounds5D().toRectangle2D().contains(imagePoint2d))
                    {
                        seq.setSelectedROI(selectedRoi);
                        popup = new PopupROI(selectedRoi, e, imagePoint2d, canvas);
                    }
                }
            }

            // popup not yet assigned --> use default one
            if (popup == null)
            {
                popup = new PopupClassic(e, canvas);
                selectedRoi = null;
            }

            popup.setLocation(e.getLocationOnScreen());
            // display
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
        else if (seq != null)
            selectedRoi = seq.getSelectedROI();
    }
}
