package plugins.ylemontag.matlabblocks;

import icy.file.FileUtil;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.util.VarException;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Common functions for Matlab blocks
 */
class MatlabBlockUtil
{
	/**
	 * Return a new editor for VarFile that filters the .mat files
	 */
	static VarEditorModel<File> makeMatFileEditor()
	{
		return new FileTypeModel("", FileMode.FILES, new FileFilter()
		{
			@Override
			public boolean accept(File file) {
				return FileUtil.getFileExtension(file.getPath(), false).toLowerCase().equals("mat");
			}
		}, true);
	}
	
	/**
	 * Report an exception
	 */
	static void reportError(IOException err)
	{
		throw new VarException(
			"An error occurred during an operation on a Matlab file: " + err.getMessage()
		);
	}
}
