package plugins.ylemontag.matlabblocks;

import javax.swing.JComponent;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.matlabio.DimensionMapping;
import plugins.ylemontag.matlabio.gui.DimensionMappingComponent;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Var type for Matlab dimension mapping objects
 */
public class VarDimensionMapping extends Var<DimensionMapping>
{
	/**
	 * Return the default dimension mapping if the input is either null or invalid,
	 * or a clone of the input otherwise
	 */
	private static DimensionMapping validateDimensionMapping(DimensionMapping in)
	{
		if(in==null || !in.isValidMapping())
			return new DimensionMapping();
		else
			return in.clone();
	}
	
	/**
	 * Editor
	 */
	private static class Editor extends SwingVarEditor<DimensionMapping>
	{
		private DimensionMappingComponent _component;
		
		public Editor(Var<DimensionMapping> variable)
		{
			super(variable);
		}
		
		@Override
		protected JComponent createEditorComponent()
		{
			_component = new DimensionMappingComponent();
			_component.addDimensionMappingChangedListener(new DimensionMappingComponent.DimensionMappingChangedListener()
			{
				@Override
				public void actionPerformed() {
					variable.setValue(_component.getDimensionMapping());
				}
			});
			return _component;
		}

		@Override
		protected void activateListeners()
		{
			_component.setShuntListeners(false);
		}
		
		@Override
		protected void deactivateListeners()
		{
			_component.setShuntListeners(true);
		}
		
		@Override
		protected void updateInterfaceValue()
		{
			DimensionMapping currentValue = getVariable().getValue();
			_component.setDimensions(
				currentValue.getDimensionX(),
				currentValue.getDimensionY(),
				currentValue.getDimensionZ(),
				currentValue.getDimensionT(),
				currentValue.getDimensionC()
			);
		}
	}
	
	public VarDimensionMapping(String name, DimensionMapping defaultValue)
	{
		super(name, DimensionMapping.class, validateDimensionMapping(defaultValue));
	}
	
	@Override
	public VarEditor<DimensionMapping> createVarEditor()
	{
		return new Editor(this);
	}
}
