/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake3D.Snake3DNode;
//import java.awt.geom.Point2D;
//import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;
//import plugins.big.bigsnakeutils.process.process1D.BSplineBasis;

/**
 * Abstract class that generalizes all 3D shape priors.
 * 
 * @version November 26, 2014
 * 
 * @author Christophe Gaudet-Blavignac (chrisgaubla@gmail.com) 
 */
public class PriorShape3D {

	/** Spline coefficients of the curve that represents the prior-shape. */
	protected Snake3DNode[] coef_ = null;
	/** Name of the prior shape. */
	protected String name_ = null;
	/**
	 * Minimum number of control points needed to properly represent the prior
	 * shape.
	 */
	protected int minNumberNodes_ = 0;

	// ============================================================================
	// PUBLIC METHODS

	public Snake3DNode[] getDefaultNodes() {
		return coef_;
	}

	// ----------------------------------------------------------------------------

	public String getName() {
		return name_;
	}

	// ----------------------------------------------------------------------------

	public Snake3DNode[] getNodes(int M) {
		return resampleDefualtShape(M);
	}

	// ----------------------------------------------------------------------------

	public int getMinNumberNodes() {
		return minNumberNodes_;
	}

	// ============================================================================
	// PRIVATE METHODS

	private Snake3DNode[] resampleDefualtShape(int M) {
		//for now resample is not supported
		
		return coef_;
		/*
		if (M == coef_.length) {
			return coef_;
		}

		double c = BSplineBasis.correlationOfTwoESpline(3.0 / M, (2 * Math.PI)
				/ M, (2 * Math.PI) / M, M, M);
		double b = BSplineBasis.correlationOfTwoESpline(4.0 / M, (2 * Math.PI)
				/ M, (2 * Math.PI) / M, M, M);
		double a = BSplineBasis.correlationOfTwoESpline(5.0 / M, (2 * Math.PI)
				/ M, (2 * Math.PI) / M, M, M);

		double alpha1 = (b + Math.sqrt(b * b - 4 * a * c + 8 * a * a))
				/ (2 * a);
		double alpha2 = (b - Math.sqrt(b * b - 4 * a * c + 8 * a * a))
				/ (2 * a);

		double z1 = (-alpha1 + Math.sqrt(alpha1 * alpha1 - 4)) / 2;
		if (Math.abs(z1) > 1) {
			z1 = 1 / z1;
		}

		double z2 = (-alpha2 + Math.sqrt(alpha2 * alpha2 - 4)) / 2;
		if (Math.abs(z2) > 1) {
			z2 = 1 / z2;
		}

		double[] invMatrix = new double[M];
		double cz1 = 1 / ((1 - Math.pow(z1, M)) * (z1 - 1 / z1) * a * (z1 + 1
				/ z1 - z2 - 1 / z2));
		double cz1i = -1
				/ ((1 - Math.pow(z1, -M)) * (z1 - 1 / z1) * a * (z1 + 1 / z1
						- z2 - 1 / z2));
		double cz2 = -1
				/ ((1 - Math.pow(z2, M)) * (z2 - 1 / z2) * a * (z1 + 1 / z1
						- z2 - 1 / z2));
		double cz2i = 1 / ((1 - Math.pow(z2, -M)) * (z2 - 1 / z2) * a * (z1 + 1
				/ z1 - z2 - 1 / z2));
		double z1k = 1;
		double z2k = 1;
		for (int k = 0; k < M; k++) {
			invMatrix[k] = cz1 * z1k + cz1i * (1 / z1k) + cz2 * z2k + cz2i
					* (1 / z2k);
			z1k *= z1;
			z2k *= z2;
		}

		Point2D.Double[] vec = new Point2D.Double[M];
		double x, y;
		for (int k = 0; k < M; k++) {
			x = 0.0;
			y = 0.0;
			for (int i = -BSplineBasis.ESPLINE3SUPPORT; i < coef_.length
					+ BSplineBasis.ESPLINE3SUPPORT; i++) {
				x += coef_[(coef_.length + i) % coef_.length].x
						* BSplineBasis.correlationOfTwoESpline(((3.0 + i)
								/ coef_.length - (double) k / (double) M),
								(2 * Math.PI) / coef_.length,
								(2 * Math.PI) / M, coef_.length, M);
				y += coef_[(coef_.length + i) % coef_.length].y
						* BSplineBasis.correlationOfTwoESpline(((3.0 + i)
								/ coef_.length - (double) k / (double) M),
								(2 * Math.PI) / coef_.length,
								(2 * Math.PI) / M, coef_.length, M);
			}
			vec[k] = new Point2D.Double(x, y);
		}

		Snake2DNode[] newCoef = new Snake2DNode[M];
		for (int k = 0; k < M; k++) {
			x = 0.0;
			y = 0.0;
			for (int i = 0; i < M; i++) {
				x += vec[i].x * invMatrix[(M + i - k) % M];
				y += vec[i].y * invMatrix[(M + i - k) % M];
			}
			newCoef[k] = new Snake2DNode(x, y);
		}
		return newCoef;
		*/
	}

}
