package plugins.fab.icydiagnose;

import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;

public class ExecTest {

	
	static void execTest( Logger logger ) 
	{
		logger.outTitle("Exec command test");
	
		String command = "echo icy";
		
		if( SystemUtil.isWindow() )
		{
			command = "cmd /c echo icy";
		}

		Process ret = SystemUtil.exec( command );		
		if ( ret== null )
		{
			logger.out("Cannot use exec command.");
		}else
		{
			try {
				ThreadUtil.sleep(100);
				ret.waitFor();
				logger.out("exec done: exit code: " + ret.exitValue() );
			} catch (InterruptedException e) {
				logger.out("Error while processing exec command:");
				logger.out(e.getMessage());
			}
		}
	}
	
}
