package plugins.tlecomte.contourPlot;

import icy.math.ArrayMath;

import java.awt.geom.Rectangle2D;

// a contour is a list of points associated to a level value 
public class Contour {
	double[] x;
	double[] y;
	double level;
	
	Contour(double[] x, double[] y, double level) throws Exception
	{
		if (x.length != y.length) {
			throw new Exception("x and y arrays must be of same length");
		}
		this.x = x;
		this.y = y;
		this.level = level;
	}
	
	public String toString() {
		String s = "level = " + level + ", coords = ";
		
		for (int i=0; i<x.length; i++) {
			s += "(" + x[i] + ", " + y[i] + "), ";
		}
		return s;
	  }
	
	public Rectangle2D getBounds() {
		double x0 = ArrayMath.min(x);
		double y0 = ArrayMath.min(y);
		double x1 = ArrayMath.max(x);
		double y1 = ArrayMath.max(y);
		
		Rectangle2D rect = new Rectangle2D.Double(x0, y0, x1-x0, y1-y0);
		
		return rect;
	}
}
