package plugins.fab.connectedcomponentpainter;

import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;

import java.awt.Color;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarIntegerArrayNative;
import plugins.adufour.vars.lang.VarSequence;

public class ConnectedComponentPainterBlock extends Plugin implements Block {

	VarSequence inputSequenceVar = new VarSequence( "input Sequence", null );
	protected VarGenericArray<ConnectedComponent[]> inputConnectedComponents = 
			new VarGenericArray<ConnectedComponent[]>("components", ConnectedComponent[].class, null);

	ConnectedComponentPainter ccPainter ;
	VarIntegerArrayNative colorIntegerArray = new VarIntegerArrayNative("RGBA Color", new int[]{ 255,0,0,255 } );
	
	@Override
	public void run() {

		Sequence inputSequence= inputSequenceVar.getValue();
		if ( inputSequence == null ) return;

		inputSequence.removePainter( ccPainter );

		int colorArray[] = colorIntegerArray.getValue();
		Color color = new Color(
				colorArray[0]/255f,
				colorArray[1]/255f,
				colorArray[2]/255f, 
				colorArray[3]/255f );
		
		ccPainter = new ConnectedComponentPainter( inputConnectedComponents.getValue() , color ) ;

		inputSequence.addPainter( ccPainter );		

	}

	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add( inputSequenceVar );
		inputMap.add( inputConnectedComponents );
		inputMap.add( colorIntegerArray );
		
	}

	@Override
	public void declareOutput(VarList outputMap) {

		
		
	}

	
}
