/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.measure.ResultsTable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.geom.MereoObject3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageShort;

public class MereoAnalysis {
    Objects3DPopulation popA;
    Objects3DPopulation popB;
    private float RadX;
    private float RadY;
    private float RadZ;
    String[][] relationships;

    public MereoAnalysis(Objects3DPopulation objects3DPopulation, Objects3DPopulation objects3DPopulation2) {
        this.popA = objects3DPopulation;
        this.popB = objects3DPopulation2;
        this.initRelationships();
        this.RadX = 1.0f;
        this.RadY = 1.0f;
        this.RadZ = 1.0f;
    }

    private void initRelationships() {
        this.relationships = new String[this.popA.getNbObjects()][this.popB.getNbObjects()];
        for (int i = 0; i < this.popA.getNbObjects(); ++i) {
            for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                this.relationships[i][j] = "DC";
            }
        }
    }

    public Objects3DPopulation getPopA() {
        return this.popA;
    }

    public void setPopA(Objects3DPopulation objects3DPopulation) {
        this.popA = objects3DPopulation;
        this.initRelationships();
    }

    public Objects3DPopulation getPopB() {
        return this.popB;
    }

    public void setPopB(Objects3DPopulation objects3DPopulation) {
        this.popB = objects3DPopulation;
        this.initRelationships();
    }

    public float getRadX() {
        return this.RadX;
    }

    public void setRadX(float f) {
        this.RadX = f;
    }

    public float getRadY() {
        return this.RadY;
    }

    public void setRadY(float f) {
        this.RadY = f;
    }

    public float getRadZ() {
        return this.RadZ;
    }

    public void setRadZ(float f) {
        this.RadZ = f;
    }

    public String[][] getRelationships() {
        return this.relationships;
    }

    public void computeSlowRelationships() {
        for (int i = 0; i < this.popA.getNbObjects(); ++i) {
            for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                MereoObject3D mereoObject3D = new MereoObject3D(this.popA.getObject(i), this.popB.getObject(j), this.RadX, this.RadY, this.RadZ);
                this.relationships[i][j] = mereoObject3D.getRCC8Relationship();
            }
        }
    }

    public void computeFastRelationships() {
        int[] nArray = this.popB.getMaxSizeAllObjects();
        ImageShort imageShort = new ImageShort("popB", nArray[0] + 1, nArray[1] + 1, nArray[2] + 1);
        this.popB.draw(imageShort);
        boolean[] blArray = new boolean[this.popB.getNbObjects()];
        int n = this.popA.getNbObjects();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                blArray[j] = false;
                this.relationships[i][j] = "DC";
            }
            Object3D object3D = this.popA.getObject(i);
            Object3DVoxels object3DVoxels = object3D.getDilatedObject(this.RadX, this.RadY, this.RadZ, false);
            ArrayList<Voxel3D> arrayList = object3DVoxels.listVoxels(imageShort);
            for (Voxel3D voxel3D : arrayList) {
                int n2;
                int n3 = (int)voxel3D.getValue();
                if (n3 == 0 || blArray[n2 = this.popB.getIndexFromValue(n3)]) continue;
                blArray[n2] = true;
                Object3D object3D2 = this.popB.getObject(n2);
                MereoObject3D mereoObject3D = new MereoObject3D(object3D, object3D2, this.RadX, this.RadY, this.RadZ);
                this.relationships[i][n2] = mereoObject3D.getRCC8Relationship();
            }
        }
    }

    public ArrayList<Object3D> getObjectsRelation(int n, int n2, String string) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        if (n2 == 0) {
            for (int i = 0; i < this.popB.getNbObjects(); ++i) {
                if (this.relationships[n][i].compareToIgnoreCase(string) != 0) continue;
                arrayList.add(this.popB.getObject(i));
            }
        } else {
            for (int i = 0; i < this.popA.getNbObjects(); ++i) {
                if (this.relationships[i][n].compareToIgnoreCase(string) != 0) continue;
                arrayList.add(this.popA.getObject(i));
            }
        }
        return arrayList;
    }

    public boolean checkObjectsRelation(int n, int n2, String string) {
        if (n2 == 0) {
            for (int i = 0; i < this.popB.getNbObjects(); ++i) {
                if (this.relationships[n][i].compareToIgnoreCase(string) != 0) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.popA.getNbObjects(); ++i) {
                if (this.relationships[i][n].compareToIgnoreCase(string) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getResult(int n, int n2) {
        return this.relationships[n][n2];
    }

    public String getResults(boolean bl) {
        String string = "";
        for (int i = 0; i < this.popA.getNbObjects(); ++i) {
            for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                if (bl) {
                    if (this.relationships[i][j].equalsIgnoreCase("DC")) continue;
                    string = string.concat(this.popA.getObject(i) + " with " + this.popB.getObject(j) + " : " + this.relationships[i][j] + "\n");
                    continue;
                }
                string = string.concat(this.popA.getObject(i) + " with " + this.popB.getObject(j) + " : " + this.relationships[i][j] + "\n");
            }
        }
        return string;
    }

    public ResultsTable getResultsTable(boolean bl, boolean bl2) {
        ResultsTable resultsTable = new ResultsTable();
        for (int i = 0; i < this.popA.getNbObjects(); ++i) {
            resultsTable.incrementCounter();
            if (!bl2) {
                resultsTable.setLabel("A" + i, i);
            } else {
                resultsTable.setLabel("A" + this.popA.getObject(i).getValue(), i);
            }
            for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                if (bl) {
                    if (!this.relationships[i][j].equalsIgnoreCase("DC")) {
                        if (!bl2) {
                            resultsTable.setValue("B" + j, i, this.relationships[i][j]);
                            continue;
                        }
                        resultsTable.setValue("B" + this.popB.getObject(j).getValue(), i, this.relationships[i][j]);
                        continue;
                    }
                    if (!bl2) {
                        resultsTable.setValue("B" + j, i, ".");
                        continue;
                    }
                    resultsTable.setValue("B" + this.popB.getObject(j).getValue(), i, ".");
                    continue;
                }
                if (!bl2) {
                    resultsTable.setValue("B" + j, i, this.relationships[i][j]);
                    continue;
                }
                resultsTable.setValue("B" + this.popB.getObject(j).getValue(), i, this.relationships[i][j]);
            }
        }
        return resultsTable;
    }

    public void writePrologFacts(String string, String string2, String string3, boolean bl, boolean bl2) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < this.popA.getNbObjects(); ++i) {
                for (int j = 0; j < this.popB.getNbObjects(); ++j) {
                    if (bl) {
                        if (this.relationships[i][j].equalsIgnoreCase("DC")) continue;
                        if (!bl2) {
                            bufferedWriter.write(this.relationships[i][j].toLowerCase() + "(" + string2 + i + "," + string3 + j + ").\n");
                            continue;
                        }
                        bufferedWriter.write(this.relationships[i][j].toLowerCase() + "(" + string2 + this.popA.getObject(i).getValue() + "," + string3 + this.popB.getObject(j).getValue() + ").\n");
                        continue;
                    }
                    if (!bl2) {
                        bufferedWriter.write(this.relationships[i][j].toLowerCase() + "(" + string2 + i + "," + string3 + j + ").\n");
                        continue;
                    }
                    bufferedWriter.write(this.relationships[i][j].toLowerCase() + "(" + string2 + this.popA.getObject(i).getValue() + "," + string3 + this.popB.getObject(j).getValue() + ").\n");
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(MereoAnalysis.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

