package plugins.tboudier.mereotopology;

import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.IcyFrame;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import mcib3d.geom.MereoAnalysis;
import mcib3d.geom.MereoObject3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.VarWorkbook;

public class MereoTopology3D extends EzPlug implements Block {

    private final EzVarSequence varSequenceA = new EzVarSequence("Input Sequence A");
    private final EzVarSequence varSequenceB = new EzVarSequence("Input Sequence B");
    private final EzVarDouble EZVarRadXY = new EzVarDouble("Radius XY", 1, 0, 10, 0.5);
    private final EzVarDouble EZVarRadZ = new EzVarDouble("Radius Z", 1, 0, 10, 0.5);
    private final EzVarBoolean EZVarReg = new EzVarBoolean("Compute regularity", false);
    //private Workbook wb = new HSSFWorkbook();
    final private VarWorkbook bookMereo = new VarWorkbook("Workbook-Mereo", (Workbook) null);
    static IcyFrame mainFrame;

    @Override
    protected void initialize() {
        // TODO Auto-generated by Icy4Eclipse        
        super.addEzComponent(varSequenceA);
        super.addEzComponent(varSequenceB);
        super.addEzComponent(EZVarRadXY);
        super.addEzComponent(EZVarRadZ);
        super.addEzComponent(EZVarReg);
    }

    @Override
    protected void execute() {
        final boolean gui = !isHeadLess();
        Sequence seqA = varSequenceA.getValue();
        Sequence seqB = varSequenceB.getValue();
        System.out.println("Mereotopology");
        System.out.println("");
        System.out.println("A=" + seqA.getName() + " B=" + seqB.getName());

        // Convert Sequence A
        ImageInt imgA;
        DataType type = (seqA.getDataType_());
        if (type.compareTo(DataType.USHORT) == 0) {
            // convert to mcib format short
            imgA = new ImageShort(seqA.getDataXYZAsShort(0, 0), "tmpA", seqA.getWidth());
        } else if (type.compareTo(DataType.UBYTE) == 0) {
            // convert to mcib format byte
            imgA = new ImageByte(seqA.getDataXYZAsByte(0, 0), "tmpA", seqA.getWidth());
        } else {
            System.out.println("Format for sequence " + seqA.getName() + " not supported");
            return;
        }

        // Convert Sequence B
        ImageInt imgB;
        type = (seqB.getDataType_());
        if (type.compareTo(DataType.USHORT) == 0) {
            // convert to mcib format short
            imgB = new ImageShort(seqB.getDataXYZAsShort(0, 0), "tmpB", seqA.getWidth());
        } else if (type.compareTo(DataType.UBYTE) == 0) {
            // convert to mcib format byte
            imgB = new ImageByte(seqB.getDataXYZAsByte(0, 0), "tmpB", seqA.getWidth());
        } else {
            System.out.println("Format for sequence " + seqB.getName() + " not supported");
            return;
        }

        //imgA.show();
        //imgB.show();
        Objects3DPopulation popA = new Objects3DPopulation(imgA.getImagePlus());
        Objects3DPopulation popB = new Objects3DPopulation(imgB.getImagePlus());

        //  mereo Analysis
        MereoAnalysis mereo = new MereoAnalysis(popA, popB);
        // radius
        float radXY = EZVarRadXY.getValue().floatValue();
        float radZ = EZVarRadZ.getValue().floatValue();
        mereo.setRadX((float) radXY);
        mereo.setRadY((float) radXY);
        mereo.setRadZ((float) radZ);
        mereo.computeFastRelationships();

        if (gui) {
            super.getUI().setProgressBarVisible(true);
        }

        // Regularity, chang eof shape with opening and closing
        if (EZVarReg.getValue()) {
            for (int ia = 0; ia < popA.getNbObjects(); ia++) {
                System.out.println("Object A" + ia + " : " + popA.getObject(ia));
                if (gui) {
                    super.getUI().setProgressBarMessage("Testing " + (ia + 1));
                    super.getUI().setProgressBarValue((double) (ia + 1) / (double) popA.getNbObjects());
                }
                unchangedMorpho(popA.getObject(ia), radXY, radXY, radZ);
            }
            System.out.println("");
            for (int ib = 0; ib < popB.getNbObjects(); ib++) {
                System.out.println("Object B" + ib + " : " + popB.getObject(ib));
                if (gui) {
                    super.getUI().setProgressBarMessage("Testing " + (ib + 1));
                    super.getUI().setProgressBarValue((double) (ib + 1) / (double) popB.getNbObjects());
                }
                unchangedMorpho(popB.getObject(ib), radXY, radXY, radZ);
            }

            System.out.println("");
        }
//     
        // create workbook
        Workbook wb = bookMereo.getValue();
        boolean newworkbook = false;
        if (wb == null) {
            bookMereo.setValue(wb = new HSSFWorkbook());
            newworkbook = true;
        }
        final boolean newWb = newworkbook;
        //wbvar = new VarWorkbook("workbook", wb);
        int nbSheet = 1;
        while (wb.getSheet("Mereo-" + nbSheet) != null) {
            nbSheet++;
        }
        String sheetName = "Mereo-" + nbSheet;
        //System.out.println("Sheet name proposed Mereo-1 : " + sheetName + " " + wb.getActiveSheetIndex() + " " + wb.getSheet("Mereo-1"));
        wb.createSheet(sheetName);
        Sheet sheet = wb.getSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int j = 0; j < popB.getNbObjects(); j++) {
            row.createCell(j + 1).setCellValue("ObjB-" + (j + 1));
        }
        for (int i = 0; i < popA.getNbObjects(); i++) {
            row = sheet.createRow((i + 1));
            row.createCell(0).setCellValue("ObjA-" + (i + 1));
            for (int j = 0; j < popB.getNbObjects(); j++) {
                row.createCell(j + 1).setCellValue(mereo.getResult(i, j));
            }
        }
        ThreadUtil.invokeNow(new Runnable() {
            @Override
            public void run() {
                if (!gui) {
                    return;
                }
                if (!newWb) {
                    mainFrame.setVisible(false);
                    mainFrame.dispose();
                }

                mainFrame = new IcyFrame("Mereotopology workbook");
                mainFrame.setResizable(true);
                mainFrame.setLayout(new BorderLayout());

                //final VarWorkbook wbvar = new VarWorkbook("Mereo workbook", wb);
                WorkbookEditor ed = new WorkbookEditor(bookMereo);
                ed.setEnabled(true);

                JComponent cp = ed.getEditorComponent();
                cp.setPreferredSize(new Dimension(600, 600));

                mainFrame.add(cp, BorderLayout.CENTER);

                JButton buttonSave = new JButton("Save workbook as...");
                buttonSave.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String path = SaveDialog.chooseFile("Save workbook as...", null, "Workbook", ".xls");
                        if (path == null) {
                            return;
                        }

                        try {
                            FileOutputStream fos = new FileOutputStream(path);
                            bookMereo.getValue().write(fos);
                            fos.close();
                        } catch (IOException e1) {
                            MessageDialog.showDialog(e1.getMessage(), MessageDialog.ERROR_MESSAGE);
                        }
                    }
                });
                JPanel southPanel = new JPanel();
                southPanel.add(buttonSave);
                mainFrame.add(southPanel, BorderLayout.SOUTH);

                // Pack and show the window
                mainFrame.pack();
                mainFrame.addToMainDesktopPane();
                mainFrame.setVisible(true);
            }
        });

    }

    // As exemple only
    private String mereo(Object3D objectA, Object3D objectB) {
        MereoObject3D mereo = new MereoObject3D(objectA, objectB);
        // check all possibilities (test only)
        System.out.println("Mereo relationship between " + objectA + " and " + objectB);
        System.out.println("distBB : " + mereo.distBB);
        String res;
        // IJ.log("A includes B : " + objectA.includes(objectB));
        // IJ.log("B includes A : " + objectB.includes(objectA));
        if (mereo.Disconnection()) {
            res = "DC";
        } else {
            if (mereo.ExternalConnection()) {
                res = "EC";
            } else if (mereo.TangentialProperParthood()) {
                res = "TPP";
            } else if (mereo.NonTangentialProperParthood()) {
                res = "NTPP";
            } else if (mereo.TangentialProperParthoodInverse()) {
                res = "TPPi";
            } else if (mereo.NonTangentialProperParthoodInverse()) {
                res = "NTPPi";
            } else if (mereo.PartialOverlap()) {
                res = "PO";
            } else if (mereo.Equality()) {
                res = "EQ";
            } else {
                res = "Unknown!";
            }
        }
        System.out.println(res);
        return res;
    }

    private void unchangedMorpho(Object3D object, float rx, float ry, float rz) {
        Object3D objectClosed = object.getClosedObject(rz, ry, rz, true);
        int a = objectClosed.getColoc(object);
        if (a == object.getVolumePixels()) {
            System.out.println("No change after closing radii " + rx + " " + ry + " " + rz);
        } else {
            System.out.println("Change after closing radii " + rx + " " + ry + " " + rz + " of " + (a - object.getVolumePixels()) + " voxels over " + object.getVolumePixels());
        }
        Object3D objectOpened = object.getOpenedObject(rz, ry, rz, true);
        a = objectOpened.getColoc(object);
        if (a == object.getVolumePixels()) {
            System.out.println("No change after opening radii " + rx + " " + ry + " " + rz);
        } else {
            System.out.println("Change after opening radii " + rx + " " + ry + " " + rz + " of " + (object.getVolumePixels() - a) + " voxels over " + object.getVolumePixels());
        }
    }

    @Override
    public void clean() {
        //
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("SequanceA", varSequenceA.getVariable());
        inputMap.add("SequenceB", varSequenceB.getVariable());
        inputMap.add("RadiusXY", EZVarRadXY.getVariable());
        inputMap.add("RadiusZ", EZVarRadZ.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("Relations", bookMereo);
    }
}
