package plugins.ylemontag.noisegenerator.noisemodelblocks;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.noisegenerator.IllegalNoiseModelArgumentException;
import plugins.ylemontag.noisegenerator.NoiseModel;
import plugins.ylemontag.noisegenerator.NoiseModelBlock;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block that generate a salt & pepper noise model
 */
public class SaltPepperNoiseBlock extends NoiseModelBlock
{
	private VarDouble _intensity  = new VarDouble("Intensity"  ,   0.2);
	private VarDouble _lowerBound = new VarDouble("Lower bound",   0.0);
	private VarDouble _upperBound = new VarDouble("Upper bound", 255.0);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_intensity );
		inputMap.add(_lowerBound);
		inputMap.add(_upperBound);
	}
	
	@Override
	protected NoiseModel generateNoiseModel()
	{
		try {
			double intensity  = _intensity .getValue(true);
			double lowerBound = _lowerBound.getValue(true);
			double upperBound = _upperBound.getValue(true);
			return NoiseModel.createSaltPepperNoiseModel(intensity, lowerBound, upperBound);
		}
		catch(IllegalNoiseModelArgumentException err) {
			throw new VarException(err.getMessage());
		}
	}
}
