package plugins.ylemontag.noisegenerator;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block to generate a noise on a sequence
 */
public class NoiseGeneratorBlock extends Plugin implements Block, PluginBundled
{
	private Var<NoiseModel> _noiseModel = new Var<NoiseModel>("Noise model", NoiseModel.class);
	private VarSequence     _input      = new VarSequence    ("Input" , null);
	private VarSequence     _output     = new VarSequence    ("Output", null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_noiseModel);
		inputMap.add(_input     );
		
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_output);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return NoiseGeneratorPlugin.class.getName();
	}
	
	@Override
	public void run()
	{
		NoiseModel noiseModel = _noiseModel.getValue(true);
		Sequence   input      = _input     .getValue(true);
		Sequence   output     = noiseModel.addNoise(input);
		_output.setValue(output);
	}
}
