package plugins.ylemontag.noisegenerator.noisemodelblocks;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.noisegenerator.IllegalNoiseModelArgumentException;
import plugins.ylemontag.noisegenerator.NoiseModel;
import plugins.ylemontag.noisegenerator.NoiseModelBlock;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block that generate a Poisson noise model
 */
public class PoissonNoiseBlock extends NoiseModelBlock
{
	@Override
	public void declareInput(VarList inputMap) {}
	
	@Override
	protected NoiseModel generateNoiseModel()
	{
		try {
			return NoiseModel.createPoissonNoiseModel();
		}
		catch(IllegalNoiseModelArgumentException err) {
			throw new VarException(err.getMessage());
		}
	}
}
