/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.blobgenerator;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.sequence.Sequence;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

import plugins.big.bigsnakeutils.icy.ellipsoid.Ellipsoid2D;
import plugins.nchenouard.spot.Detection;

/**
 * Detection class for Ellipsoid2D objects. Used to display Ellipsoid2D with the
 * track manager.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class CellDetection2D extends Detection {
	private final Ellipsoid2D _cell;

	CellDetection2D(Ellipsoid2D cell) {
		super(cell.x0, cell.y0, 0, cell.getT());
		_cell = cell;
	}

	@Override
	public void paint(Graphics2D g2, Sequence sequence, IcyCanvas canvas) {
		if (_cell.getT() != canvas.getPositionT()) {
			return;
		}

		if (canvas instanceof IcyCanvas2D) {
			Shape baseShape = new Ellipse2D.Double(_cell.x0 - _cell.a, _cell.y0
					- _cell.b, 2 * _cell.a, 2 * _cell.b);
			Shape rotatedShape = AffineTransform.getRotateInstance(_cell.alpha,
					_cell.x0, _cell.y0).createTransformedShape(baseShape);
			g2.draw(rotatedShape);
		}
	}
}
