package plugins.fab.manualtnt;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.Saver;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.main.MainEvent;
import icy.gui.main.MainEvent.MainEventSourceType;
import icy.gui.main.MainFrame;
import icy.gui.main.MainListener;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.roi.ROI2DLine;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

import org.w3c.dom.Node;



public class ManualTNT extends PluginActionable implements MainListener , ActionListener {

	IcyFrame mainFrame = new IcyFrame("Manual TNT");
	JButton stopButton = new JButton("Stop");
	JButton folderButton = new JButton("Select images to process");
	JTextField zToRemove = new JTextField("0");
	ArrayList<File> fileList = new ArrayList<File>();
	
	@Override
	public void run() {

		mainFrame.getContentPane().setLayout( new BoxLayout( mainFrame.getContentPane() , BoxLayout.PAGE_AXIS ) );
		//mainFrame.getContentPane().add( GuiUtil.besidesPanel( stopButton ) );
		mainFrame.getContentPane().add( GuiUtil.besidesPanel( folderButton ) );
		mainFrame.getContentPane().add( GuiUtil.besidesPanel( new JLabel("#Z to remove:") , zToRemove ) );
		mainFrame.setVisible( true );
		mainFrame.pack();
		
		folderButton.addActionListener( this );
		
		addIcyFrame( mainFrame );
		
		// create a listener on Icy.
		
		Icy.getMainInterface().addListener( this );

	}

	@Override
	public void pluginOpened(MainEvent event) {}
	@Override
	public void pluginClosed(MainEvent event) {}
	@Override
	public void viewerOpened(MainEvent event) {
	}
	@Override
	public void viewerFocused(MainEvent event) {

	}
	@Override
	public void viewerClosed(MainEvent event) {}
	@Override
	
	public void sequenceOpened(MainEvent event) {
	
		if ( event.getSourceType() == MainEventSourceType.SEQUENCE )
		{
			final Sequence sequenceOpened = (Sequence) event.getSource();
			System.out.println( "Sequence opened: " + sequenceOpened );

			// If the image is not loaded from file, then return
			if ( sequenceOpened.getFilename() == null )
			{
				System.out.println("ignored");				
				return;
			}

			int nbZToRemove = Integer.parseInt( zToRemove.getText() );
			for ( int i = 0 ; i < nbZToRemove ; i++ )
			{
				SequenceUtil.removeZAndShift( sequenceOpened , 0 );
			}
			
			
			// adding overlay;
			Node node = sequenceOpened.getNode( ManualTNT.class.getName() );
			final ManualTNTOverlay mto = new ManualTNTOverlay(
					"Manual TNT" , node , new File( sequenceOpened.getFilename()+".xls" ) , sequenceOpened.getPixelSizeX() , this );
			sequenceOpened.addPainter( mto );

			Runnable run = new Runnable() {
				
				@Override
				public void run() {
					createHelpImages( sequenceOpened , mto );					
				}
			};
			
			Thread thread = new Thread ( run );
			thread.start();
			
		}

	}

	String cache_directory = "/../cached rendering/";
	
	private void createHelpImages( Sequence inputSequence, ManualTNTOverlay mto ) {

		AnnounceFrame announceFrame = new AnnounceFrame("Creating rendering");

		// Check if cached file already exists

		Sequence cachedSequence = null;
		{
			String directory = FileUtil.getDirectory( inputSequence.getFilename() );
			directory += "/../cached rendering/";
			File cachedFile = new File( directory+ FileUtil.getFileName( inputSequence.getFilename() ) +".render.tif" );
			if ( cachedFile.exists() )
			{
				cachedSequence = Loader.loadSequence( cachedFile , 0 , false );
				cachedSequence.setFilename( null );
			}
		}
		
		Sequence outSequence = null;
		if ( cachedSequence!=null )
		{
			outSequence = cachedSequence;
		}
		
		// Create rendering.
		if ( outSequence == null )
		{
			Utils util = new Utils();
			IcyBufferedImage image = util.projectStackDenoised( inputSequence );
			outSequence = new Sequence( image );

			// save created Sequence;		
			String directory = FileUtil.getDirectory( inputSequence.getFilename() );
			directory += "/../cached rendering/";
			FileUtil.createDir( directory );		
			File outFile = new File( directory+ FileUtil.getFileName( inputSequence.getFilename() ) +".render.tif" );
			
			
			Saver.save( outSequence , outFile );
			
			outSequence.setFilename( null );
		}
		
		final Sequence outSequenceFinal = outSequence; 
		ThreadUtil.invokeLater( new Runnable() {
			
			@Override
			public void run() {

				@SuppressWarnings("unused")
				Viewer viewer = new Viewer( outSequenceFinal );
				Icy.getMainInterface().getMainFrame().organizeTile( MainFrame.TILE_GRID );
				Icy.getMainInterface().setGlobalViewSyncId( 1 );
												
			}
		});	
		
		outSequence.addPainter( mto );
	
		// adding z animator		
		// new ZOverlayShortcut( inputSequence.getViewers().get( 0 ) );
		
		announceFrame.close();
	}

	@Override
	public void sequenceFocused(MainEvent event) {
	
	}

	@Override
	public void sequenceClosed(MainEvent event) {

		if ( event.getSourceType() == MainEventSourceType.SEQUENCE )
		{
			Sequence sequenceOpened = (Sequence) event.getSource();
			System.out.println( "Sequence closed: " + sequenceOpened );
		}
			
	}

	
	
	@Override
	public void roiAdded(MainEvent event) {}
	@Override
	public void roiRemoved(MainEvent event) {}
	@Override
	public void painterAdded(MainEvent event) {}
	@Override
	public void painterRemoved(MainEvent event) {}

	
	
	@Override
	public void actionPerformed(ActionEvent e) {

		if ( e.getSource() == folderButton )
		{
			JFileChooser fileChooser = new JFileChooser();
//			fileChooser.setDialogType(JFileChooser.DIRECTORIES_ONLY);
//			fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			fileChooser.setMultiSelectionEnabled( true );
			
	        Preferences preferences = Preferences.userRoot().node("icy/browser");
	        String browserDirectory = preferences.get("path", "");
			
	        System.out.println("current browser directory is : " + browserDirectory );
	        
			if(browserDirectory == "")
			    fileChooser.setCurrentDirectory(new File(browserDirectory));
			

			int returnValue = fileChooser.showDialog( null , "List of images");
			if (returnValue == JFileChooser.APPROVE_OPTION) 
			{
				fileList = new ArrayList<File>( );
				File[] fileArray = fileChooser.getSelectedFiles();
				for ( File file : fileArray )
				{
					fileList.add( file );
					System.out.println("File added: " + file );
				}							
				preferences.put("path", fileChooser.getCurrentDirectory().getPath() );
			}

			openNextImage();
		}
		
	}

	public void openNextImage() {

		ThreadUtil.bgRun( new Runnable() {
			
			@Override
			public void run() {

				Icy.getMainInterface().closeAllViewers();	
				
				if ( fileList.size() == 0 )
				{
					new AnnounceFrame("All images processed");
					return;
				}
				
				File file = fileList.get( 0 );
				System.out.println("Opening file " + file );
				fileList.remove( file );		
				
				final Sequence loadedSequence = Loader.loadSequence( file , 0 , true );
				if ( loadedSequence != null )
				{
					ThreadUtil.invokeNow( new Runnable() {
						
						@Override
						public void run() {
							Viewer viewer = new Viewer( loadedSequence );
						}
					});
				}else
				{
					new FailedAnnounceFrame("File " + file +" can't be opened." , 5 );
					openNextImage();
				}
				
			}
		});
		
	}



}
