package plugins.fab.manualtnt.toremove;


/**
 * 
 * @author nicolas chenouard
 *
 */
public class WTransform {

	public static double[] daub8 = {0.230377813309, 0.714846570553, 0.630880767930, -0.027983769417, -0.187034811719, 0.030841381836, 0.032883011667, -0.010597401785};
	//fast wavelet transform for B-X wavelet with a trou algorithm
	public static MArray[] bTypeWT(MArray arrayi, int maxScale, int[] pad, int[] step, double[] w)
	{
		if (maxScale < 1)
		{
			MArray[] resArray = new MArray[1];
			resArray[0] = arrayi;
			return resArray;
		}
		else
		{
			MArray[] resArray = new MArray[maxScale];
			int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
			int s;
			int stepS;
			int numW = w.length;
			int numW2 = numW/2;
			MArray array1 = arrayi;
			MArray arrayX = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayY = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayZ = new MArray(Types.DOUBLE, width, height, depth);
	
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				stepS = step[s-1];
				if(width >= 2*pad[s-1])
				{
					for (int z=0; z<depth; z++)
					{
						for (int y=0; y<height; y++)
						{	
							int cntX = 0;
							for (int cntW = numW2; cntW > 0; cntW--)
							{
								for (int cntX2 = 0; cntX2 < stepS; cntX2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < cntW)
									{
										val += w[cntw2]*array1.get((numW2-cntw2)*stepS-1-cntX, y, z);
										cntw2++;
									}
									while (cntw2<numW)
									{
										val += w[cntw2]*array1.get(cntX+(cntw2-numW2)*stepS, y, z);
										cntw2++;
									}
									arrayX.set(cntX, y, z, val);
									cntX++;
								}
							}
							for (int cntX2 = numW2*stepS; cntX2 < width - numW2*stepS; cntX2++)
							{
								double val = 0;
								for (int cntw2 = 0; cntw2 < numW; cntw2++)
									val += w[cntw2]*array1.get(cntX+(cntw2-numW2)*stepS, y,z);
								arrayX.set(cntX, y,z, val);
								cntX++;
							}
							for (int cntW = 1; cntW <= numW2; cntW++)
							{
								for( int cntX2 =0; cntX2 < stepS; cntX2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < numW - cntW)
									{
										val += w[cntw2]*array1.get(cntX+(cntw2-numW2)*stepS, y, z);
										cntw2++;
									}
									while(cntw2<numW)
									{
										val += w[cntw2]*array1.get(2*(width-1)-(cntw2 - numW2)*stepS - cntX +1, y,z);
										cntw2++;
									}
									arrayX.set(cntX, y, z, val);
									cntX++;
								}
							}
						}
					}
				}
				else
					arrayX = array1;
				if(height >= 2*pad[s-1])
				{
					for (int z=0; z<depth; z++)
					{
						for (int x=0; x<width; x++)
						{	
							int cntY = 0;
							for (int cntW = numW2; cntW > 0; cntW--)
							{
								for (int cntY2 = 0; cntY2 < stepS; cntY2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < cntW)
									{
										val += w[cntw2]*arrayX.get(x,(numW2-cntw2)*stepS-1-cntY, z);
										cntw2++;
									}
									while (cntw2<numW)
									{
										val += w[cntw2]*arrayX.get(x,cntY+(cntw2-numW2)*stepS, z);
										cntw2++;
									}
									arrayY.set(x, cntY, z, val);
									cntY++;
								}
							}
							for (int cntY2 = numW2*stepS; cntY2 < height - numW2*stepS; cntY2++)
							{
								double val = 0;
								for (int cntw2 = 0; cntw2 < numW; cntw2++)
									val += w[cntw2]*arrayX.get(x, cntY+(cntw2-numW2)*stepS,z);
								arrayY.set(x,cntY,z, val);
								cntY++;
							}
							for (int cntW = 1; cntW <= numW2; cntW++)
							{
								for( int cntY2 =0; cntY2 < stepS; cntY2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < numW - cntW)
									{
										val += w[cntw2]*arrayX.get(x,cntY+(cntw2-numW2)*stepS, z);
										cntw2++;
									}
									while(cntw2<numW)
									{
										val += w[cntw2]*arrayX.get(x, 2*(height-1)-(cntw2 - numW2)*stepS - cntY +1,z);
										cntw2++;
									}
									arrayY.set(x, cntY, z, val);
									cntY++;
								}
							}
						}
					}
				}
				else
					arrayY = arrayX;
				if(depth >= 2*pad[s-1])
				{
					for (int y=0; y<height; y++)
					{
						for (int x=0; x<width; x++)
						{	
							int cntZ = 0;
							for (int cntW = numW2; cntW > 0; cntW--)
							{
								for (int cntZ2 = 0; cntZ2 < stepS; cntZ2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < cntW)
									{
										val += w[cntw2]*arrayY.get(x,y,(numW2-cntw2)*stepS-1-cntZ);
										cntw2++;
									}
									while (cntw2<numW)
									{
										val += w[cntw2]*arrayY.get(x,y,cntZ+(cntw2-numW2)*stepS);
										cntw2++;
									}
									arrayZ.set(x, y, cntZ, val);
									cntZ++;
								}
							}
							//System.out.println(cntZ);
							while( cntZ < depth - numW2*stepS)
							{
								double val = 0;
								for (int cntw2 = 0; cntw2 < numW; cntw2++)
									val += w[cntw2]*arrayY.get(x, y, cntZ+(cntw2-numW2)*stepS);
								arrayZ.set(x, y, cntZ, val);
								cntZ++;
							}
							//System.out.println(cntZ);
							for (int cntW = 1; cntW <= numW2; cntW++)
							{
								for( int cntZ2 =0; cntZ2 < stepS; cntZ2++)
								{
									double val = 0;
									int cntw2 = 0;
									while(cntw2 < numW - cntW)
									{
										val += w[cntw2]*arrayY.get(x, y, cntZ+(cntw2-numW2)*stepS);
										cntw2++;
									}
									while(cntw2<numW)
									{
										val += w[cntw2]*arrayY.get(x, y, 2*(depth-1)-(cntw2 - numW2)*stepS - cntZ +1);
										cntw2++;
									}
									arrayZ.set(x, y, cntZ, val);
									//System.out.println(cntZ);
									cntZ++;
								}
							}
						}
					}
				}
				else
					arrayZ = arrayY;
				resArray[s-1] = new MArray(arrayZ);
				array1 = arrayZ;
			}
			return resArray;
		}
	}

	public static double[] daub4 = {0.482962913145, 0.836516303738, 0.224143868042, -0.129409522551};
	//fast computation of daubechies-X wavelet transform (only diagonal coeffs) for the first scale (useful to compute a robust estimation of the standard deviation of the noise in a image) 

	public static MArray daubWTDiag(MArray arrayi, double[] w)
	{
		int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
		MArray arrayX = new MArray(Types.DOUBLE, width/2+width%2, height, depth);
		MArray arrayY = new MArray(Types.DOUBLE, width/2+width%2, height/2 + height%2, depth);
		MArray arrayZ = new MArray(Types.DOUBLE, width/2+width%2, height/2 + height%2, depth/2 + depth%2);
		
		int wlength = w.length;

		for (int z= 0; z < depth; z++)
		{
			for (int y=0; y<height; y++)
			{
				int cntXi = 0, cntX = 0;
				int cntW;
				double val;
				while(cntXi < width-wlength)
				{
					val = 0;
					for (cntW = 0; cntW <wlength; cntW++)
					{
						val += arrayi.get(cntXi+cntW, y, z)*w[cntW];
					}
					arrayX.set(cntX, y, z, val);
					cntX++;
					cntXi+=2;
				}

				while (cntXi < width)
				{
					val = 0;
					for (cntW = 0; cntW <wlength; cntW++)
					{
						if (cntXi+cntW<width)
							val += arrayi.get(cntXi+cntW, y, z)*w[cntW];
						else
							val += arrayi.get(2*width-cntW-1-cntXi, y, z)*w[cntW];
					}
					arrayX.set(cntX, y, z, val);
					cntX++;
					cntXi+=2;
				}
			}
		}
		for (int z= 0; z < depth; z++)
		{
			for (int x=0; x<arrayX.getDimSize(0); x++)
			{
				int cntYi = 0, cntY = 0;
				int cntW;
				double val;
				while (cntYi < height-wlength)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						val += arrayX.get(x, cntYi+cntW, z)*w[cntW];
					}
					arrayY.set(x, cntY, z, val);
					cntY++;
					cntYi+=2;
				}
				while (cntYi < height)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						if (cntYi+cntW<height)
							val += arrayX.get(x, cntYi+cntW, z)*w[cntW];
						else
							val += arrayX.get(x, 2*height-cntW-1-cntYi, z)*w[cntW];
					}
					arrayY.set(x, cntY, z, val);
					cntY++;
					cntYi+=2;
				}
			}
		}
		for (int x=0; x<arrayY.getDimSize(0); x++)
		{
			for (int y= 0; y < arrayY.getDimSize(1); y++)
			{
				int cntZi = 0, cntZ = 0;
				int cntW;
				double val;
				while (cntZi < depth-wlength)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						val += arrayY.get(x, y, cntZi+cntW)*w[cntW];
					}
					arrayZ.set(x, y, cntZ, val);
					cntZ++;
					cntZi+=2;
				}
				while (cntZi < depth)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						if (cntZi+cntW<depth)
							val += arrayY.get(x, y, cntZi+cntW)*w[cntW];
						else
							val += arrayY.get(x, y, 2*depth-cntW-1-cntZi)*w[cntW];
					}
					arrayZ.set(x, y, cntZ, val);
					cntZ++;
					cntZi+=2;
				}
			}
		}
		return arrayZ;
	}
	public static MArray daubWTDiag2D(MArray arrayi, int d, double[] w)
	{
		int wlength = w.length;
		int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1);
		int nwidth = width/2 + width%2;
		int nheight = height/2 + height%2;
		MArray arrayX = new MArray(Types.DOUBLE, nwidth, height);
		MArray arrayY = new MArray(Types.DOUBLE, nwidth, nheight,1);

		for (int y=0; y<height; y++)
		{
			int cntXi = 0, cntX = 0;
			double val;
			int cntW;
			while(cntXi < width-wlength)
			{
				val = 0;
				for (cntW = 0; cntW <wlength; cntW++)
				{
					val += arrayi.get(cntXi+cntW, y, d)*w[cntW];
				}
				arrayX.set(cntX, y, val);
				cntX++;
				cntXi+=2;
			}
			while (cntXi < width)
			{
				val = 0;
				for (cntW = 0; cntW <wlength; cntW++)
				{
					if (cntXi+cntW<width)
						val += arrayi.get(cntXi+cntW, y ,d)*w[cntW];
					else
						val += arrayi.get(2*width-cntW-1-cntXi, y, d)*w[cntW];
				}
				arrayX.set(cntX, y, val);
				cntX++;
				cntXi+=2;
			}
		}
		for (int x=0; x<arrayX.getDimSize(0); x++)
		{
			int cntYi = 0, cntY = 0;
			int cntW;
			double val;
			while (cntYi < height-wlength)
			{
				val = 0;
				for (cntW = 0; cntW < wlength; cntW++)
				{
					val += arrayX.get(x, cntYi+cntW)*w[cntW];
				}
				arrayY.set(x, cntY, val);
				cntY++;
				cntYi+=2;
			}
			while (cntYi < height)
			{
				val = 0;
				for (cntW = 0; cntW < wlength; cntW++)
				{
					if (cntYi+cntW<height)
						val += arrayX.get(x, cntYi+cntW)*w[cntW];
					else
						val += arrayX.get(x, 2*height-cntW-1-cntYi)*w[cntW];
				}
				arrayY.set(x, cntY, val);
				cntY++;
				cntYi+=2;
			}
		}
		return arrayY;
	}
	
	
	//fast computation of daubechies-X wavelet transform (only diagonal coeffs) for the first scale (useful to compute a robust estimation of the standard deviation of the noise in a image) 
	
	public static double[] daubWTDiag(double[] arrayi, int width, int height, int depth, double[] w)
	{
		int wx = width/2+width%2, hx = height, dx = depth;
		int wy = width/2+width%2, hy = height/2+height%2, dy = depth;
		int wz = width/2+width%2, hz = height/2+height%2, dz = depth/2 + depth%2;
		
		
		double[] arrayX = new double[wx*hx*dx];
		double[] arrayY = new double[wy*hy*dy];
		double[] arrayZ = new double[wz*hz*dz];
			
		int wlength = w.length;
	
		for (int z= 0; z < depth; z++)
		{
			for (int y=0; y<height; y++)
			{
				int cntXi = 0, cntX = 0;
				int cntW;
				double val;
				while(cntXi < width-wlength)
				{
					val = 0;
					for (cntW = 0; cntW <wlength; cntW++)
						val += arrayi[cntXi+cntW+y*width+z*width*height]*w[cntW];
					arrayX[cntX + y*wx + z*wx*hx]= val;
					cntX++;
					cntXi+=2;
				}
	
				while (cntXi < width)
				{
					val = 0;
					for (cntW = 0; cntW <wlength; cntW++)
					{
						if (cntXi+cntW<width)
							val += arrayi[cntXi+cntW + y*width + z*width*height]*w[cntW];
						else
							val += arrayi[2*width-cntW-1-cntXi+ y*width+ z*width*height]*w[cntW];
					}
					arrayX[cntX + y*wx + wx*hx*z] = val;
					cntX++;
					cntXi+=2;
				}
			}
		}
		for (int z= 0; z < depth; z++)
		{
			for (int x=0; x<wx; x++)
			{
				int cntYi = 0, cntY = 0;
				int cntW;
				double val;
				while (cntYi < height-wlength)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						val += arrayX[x+ wx*(cntYi+cntW)+ z*wx*hx]*w[cntW];
					}
					arrayY[x+ cntY*wy +z*wy*hy] = val;
					cntY++;
					cntYi+=2;
				}
				while (cntYi < height)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						if (cntYi+cntW<height)
							val += arrayX[x+wx*(cntYi+cntW)+ z*wx*hx]*w[cntW];
						else
							val += arrayX[x + wx*(2*hx-cntW-1-cntYi) + z*wx*hx]*w[cntW];
					}
					arrayY[x+ wy*cntY + z*wy*hy] = val;
					cntY++;
					cntYi+=2;
				}
			}
		}
		for (int x=0; x<wy; x++)
		{
			for (int y= 0; y < hy; y++)
			{
				int cntZi = 0, cntZ = 0;
				int cntW;
				double val;
				while (cntZi < dy-wlength)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
						val += arrayY[x+ y*wy +(cntZi+cntW)*wy*hy]*w[cntW];
					arrayZ[x+ y*wz + cntZ*wz*hz]= val;
					cntZ++;
					cntZi+=2;
				}
				while (cntZi < dy)
				{
					val = 0;
					for (cntW = 0; cntW < wlength; cntW++)
					{
						if (cntZi+cntW<depth)
							val += arrayY[x+ y*wy +wy*hy*(cntZi+cntW)]*w[cntW];
						else
							val += arrayY[x+ y*wy+ (2*dy-cntW-1-cntZi)*wy*hy]*w[cntW];
					}
					arrayZ[x+y*wz + cntZ*hz*wz] =  val;
					cntZ++;
					cntZi+=2;
				}
			}
		}
		return arrayZ;
	}

	public static double[] daubWTDiag2D(double[] arrayi, int width, int height, int d, double[] w)
	{
		int wlength = w.length;
		int nwidth = width/2 + width%2;
		int nheight = height/2 + height%2;

		double[] arrayX = new double[nwidth*height];
		double[] arrayY = new double[nwidth*nheight];
		
		for (int y=0; y<height; y++)
		{
			int cntXi = 0, cntX = 0;
			double val;
			int cntW;
			while(cntXi < width-wlength)
			{
				val = 0;
				for (cntW = 0; cntW <wlength; cntW++)
					val += arrayi[cntXi+cntW +y*width+ d*width*height]*w[cntW];
				arrayX[cntX +  y*nwidth] = val;
				cntX++;
				cntXi+=2;
			}
			while (cntXi < width)
			{
				val = 0;
				for (cntW = 0; cntW <wlength; cntW++)
				{
					if (cntXi+cntW<width)
						val += arrayi[cntXi+cntW+ y*width +d*width*height]*w[cntW];
					else
						val += arrayi[2*width-cntW-1-cntXi+ y*width + d*width*height]*w[cntW];
				}
				arrayX[cntX + y*nwidth]= val;
				cntX++;
				cntXi+=2;
			}
		}
		for (int x=0; x<nwidth; x++)
		{
			int cntYi = 0, cntY = 0;
			int cntW;
			double val;
			while (cntYi < height-wlength)
			{
				val = 0;
				for (cntW = 0; cntW < wlength; cntW++)
				{
					val += arrayX[x + (cntYi+cntW)*nwidth]*w[cntW];
				}
				arrayY[x+ cntY*nwidth] =val;
				cntY++;
				cntYi+=2;
			}
			while (cntYi < height)
			{
				val = 0;
				for (cntW = 0; cntW < wlength; cntW++)
				{
					if (cntYi+cntW<height)
						val += arrayX[x+ (cntYi+cntW)*nwidth]*w[cntW];
					else
						val += arrayX[x+ (2*height-cntW-1-cntYi)*nwidth]*w[cntW];
				}
				arrayY[x + cntY*nwidth] = val;
				cntY++;
				cntYi+=2;
			}
		}
		return arrayY;
	}
}
