package plugins.lagache.spatialanalysis;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.netlib.util.booleanW;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.roi.ROI2DPolygon;
import icy.roi.ROI2DRectangle;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.adufour.ezplug.EzVarText;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

// Colocalisation with Ripley function K
// Significant 

public class SpatialAnalysis extends EzPlug{

	
	EzVarSwimmingObject<DetectionResult> detections = new EzVarSwimmingObject<DetectionResult>("Detections");

	EzVarDouble pas_frame=new EzVarDouble("nb of frames between two analysis", 1, 1, 100, 1);
	
	 EzVarDouble pas = new EzVarDouble("Step" , 1, 1, 100, 1);
	 EzVarDouble mindist = new EzVarDouble("Min. radius", 1, 0, 100, 1);
	 EzVarDouble maxdist =  new EzVarDouble("Max. radius", 10, 0, 100, 1);

	
	
	protected EzVarDoubleArrayNative K = new EzVarDoubleArrayNative("Ripley", null, false);
	
	private EzVarDouble confidence_level = new EzVarDouble("Confidence level", 0.99, 0, 1, 0.001); 
	private EzVarDoubleArrayNative quantile_bas = new EzVarDoubleArrayNative("Quantile bas", null, false);
	private EzVarDoubleArrayNative quantile_haut = new EzVarDoubleArrayNative("Quantile_haut", null, false);
	private EzVarText results = new EzVarText("Conclusion");
	private EzVarText results_cluster = new EzVarText("Clusters");
	private EzVarText results_dispersion = new EzVarText("Dispersion");
	
	double d_min = 1; // pixels
	double d_max = 5;
	double dist_tab[] = null;

	protected EzVarBoolean                          exportExcel            = new EzVarBoolean("Export to Excel", false);
    protected EzVarFile                             exportExcelFile        = new EzVarFile("Excel file", "");
    
	private EzVarBoolean graph = new EzVarBoolean("Ripley's K function Graph", false);
	

	@Override
	protected void initialize() {

		super.addEzComponent(detections);
		
		//pas_frame=new EzVarDouble("nb of frames between analysis", 1, 1, 100, 1);
		
		
		super.addEzComponent(pas_frame);
		
		
		//pas = new EzVarDouble("step", 1, 1, 100, 1);
		//mindist = new EzVarDouble("min radius", 1, 0, 100, 1);
		//maxdist = new EzVarDouble("max radius", 10, 0, 100, 1);
		
		super.addEzComponent(mindist);
		super.addEzComponent(maxdist);
		super.addEzComponent(pas);
		
		
		
		
		super.addEzComponent(confidence_level);
		
		
		super.addEzComponent(new EzGroup("Export",   exportExcel, exportExcelFile));
	    exportExcel.addVisibilityTriggerTo(exportExcelFile, true);		
        
	    	    
		super.addEzComponent(graph);
		super.addEzComponent(results);
		super.addEzComponent(results_cluster);
		super.addEzComponent(results_dispersion);
		
		

		getUI().setParametersIOVisible(false);

	}

	
	// N: nb entre dmin et dmax avec pas donne
	@Override
	protected void execute() {

		if (detections.getValue() == null) {
			new AnnounceFrame("Please first select a detection set");
			return;
		} else {
			DetectionResult temp = (DetectionResult) detections.getValue().getObject();
			Vector<Spot> detection = temp.getDetectionsAtT(0);
			if (detection.size() == 0) {
				new AnnounceFrame("There is no detections associated with the ROI");
				return;
			} else {
				if (mindist.getValue()>maxdist.getValue())
					{new AnnounceFrame("min radius must be less than max radius");
				return;}
				else
				{
					if (pas.getValue()>(maxdist.getValue()-mindist.getValue()))
					{new AnnounceFrame("step must be less than (max radius-min radius)");
				return;}
					else				
				performAnalysis(detections, mindist, maxdist, pas, exportExcel, graph);// detections.getSequence()
																						// );
			}}
		}
	}

	private void performAnalysis(EzVarSwimmingObject<DetectionResult> detections, EzVarDouble min, EzVarDouble max, EzVarDouble pas, EzVarBoolean exportExcel, EzVarBoolean graph) {
		// refinement des spots avec local maxima si possible
		DetectionResult detect_ = (DetectionResult) detections.getValue().getObject();		
		Sequence sequence = detect_.getSequence();

					
		// gestion de plusieurs ROIs
		 ArrayList<ROI2D>    roiArrayList = sequence.getROI2Ds();
		 //TODO Ou sont les ROIs???
		 if (roiArrayList.size()==0){
				Polygon polygon = new Polygon();
				polygon.addPoint(0, 0);
				polygon.addPoint(0, sequence.getWidth());
				polygon.addPoint(sequence.getHeight(), sequence.getWidth());
				polygon.addPoint(sequence.getHeight(), 0);
			 ROI2DPolygon roitmp= new ROI2DPolygon();
			 roitmp.setPolygon(polygon);					 
			 roiArrayList.add(roitmp);
		 }
		
		 //on initialise les parametres intemporels en t=0
		//initialisation 
			Vector<Spot> detection = detect_.getDetectionsAtT(0);						 		
			 //construction des Hashmaps avec les detections au temps 0
			HashMap<ROI2D, Vector<Spot>> ROI2Detection  = detectionsInRoi(sequence, detection, roiArrayList);		
			
			//calcul des parametres globaux: aire et perimetres totaux des rois et nb de detections
			double area = 0;
			double perimeter=0;
			int nbdet = detection.size();
			
			for (ROI2D roi : ROI2Detection.keySet()) {
				area=area+Roiarea(roi);
				perimeter=perimeter+roi.getPerimeter();
			}
			
			//construction du distance_tab pour calculer la p_value de coloc							

			// initialisation possible de la sauvegarde
			double temp = (max.getValue() - min.getValue()) / pas.getValue();
			int N = (int) temp;
			dist_tab = new double[N];
			for (int u = 0; u < N; u++) {
				dist_tab[u] = min.getValue() + u * pas.getValue();
			}
			
			//initialisation xls
			int row=0;
			XlsManager xls=null;
			if (exportExcel.getValue())
			{			 			             
			 int page = 1;
			 
			 try
			 {
			     File f = exportExcelFile.getValue(true);
			     if (!FileUtil.getFileExtension(f.getPath(), false).equalsIgnoreCase("xls")) f = new File(f.getPath() + ".xls");
			     xls = new XlsManager(f);
			     xls.createNewPage("Page " + page);
			 }
			 catch (Exception e)
			 {
			     e.printStackTrace();
			     return;
			 }
			 
				xls.setLabel( 0 , 0 , "Date of XLS page:" );
				row++;
				xls.setLabel( 0 , row , new Date().toString() );
				row++;
				xls.setLabel( 0 , row , "r min" );xls.setLabel( 1 , row , "r max" );xls.setLabel( 2 , row , "step dr" );
				row++;
				xls.setNumber( 0 , row , min.getValue() );xls.setNumber( 1 , row , max.getValue() );xls.setNumber( 2 , row , pas.getValue() );				
				row++;
				xls.setLabel( 0 , row , "r" );
				xls.setLabel( 1 , row , "K(r)" );
				//xls.setLabel( 2 , row , "var(K)" );
				//xls.setLabel( 3 , row , "skew(Y)" );
				//xls.setLabel( 4 , row , "kurt(Y)" );
				xls.setLabel( 2 , row , "quantile_bas" );
				xls.setLabel( 3 , row , "quantile_haut" );
				row++ ;
												
				}						
			
				
		 //boucle en temps		 
		 //temps total de la sequence
		int T=sequence.getSizeT();
		double temp_f=pas_frame.getValue();
		int pas_f=(int) temp_f;
		for (int t=0;t<T;t+=pas_f)
		{		 
		//initialisation 
		detection = detect_.getDetectionsAtT(t);					 		
		 //construction des Hashmaps avec les detections au temps t
		ROI2Detection  = detectionsInRoi(sequence, detection, roiArrayList);											
		
		//mise  jour du nb de detections a et b au temps t
		nbdet=detection.size();
					
		//////////////////////////////////////////////////////////								
		// calcul de la fonction de Ripley et des quantiles
		
		// calcul de la fonction de Ripley
			double[] Ktemp = new double[N];			
			Ktemp = corrfunction(ROI2Detection, area, nbdet, N);
			double[] var = new double[N];
			
			var = variance_theo(area, perimeter, nbdet, N);
			double[] skew = new double[N];
			skew = skew_theo(area, perimeter, nbdet, N);
			double[] kurt = new double[N];
			kurt = kurt_theo(area,perimeter,nbdet,N);
			
 
			double[] Y = new double[N];
			
			double[] skew_Y = new double[N];
			double[] kurt_Y = new double[N];
			double[] q_bas = new double[N];
			double[] q_haut = new double[N];
			
			//double z_bas=-2.32;
			//double z_haut=2.32;
			double z_bas=NormInv.compute(1-confidence_level.getValue(), 0, 1);
			double z_haut=NormInv.compute(confidence_level.getValue(), 0, 1);
			
			double max_Y=-1000;
			int indice_max=0;
			int indice_min=0;
			boolean ma=false;
			boolean mi=false;
			double min_Y=1000;
			double tempi=0;
			for (int p = 0; p < N; p++) {
				Y[p] = (Ktemp[p] - Math.PI*Math.pow(dist_tab[p],2)) / Math.sqrt(var[p]);
				if (Y[p]>max_Y)
				{max_Y=Y[p];indice_max=p;}
				if (Y[p]<min_Y)
				{min_Y=Y[p];indice_min=p;}

				skew_Y[p]=skew[p]/Math.pow(var[p],1.5);
				kurt_Y[p]=kurt[p]/Math.pow(var[p], 2);				
				//calcul des quantiles avec la formule de Cornish Fisher
				q_bas[p]=z_bas+((z_bas*z_bas-1)*skew_Y[p])/6+((z_bas*z_bas*z_bas-3*z_bas)*(kurt_Y[p]-3))/24-((2*z_bas*z_bas*z_bas-5*z_bas)*skew_Y[p]*skew_Y[p])/36;
				q_haut[p]=z_haut+((z_haut*z_haut-1)*skew_Y[p])/6+(z_haut*z_haut*z_haut-3*z_haut)*(kurt_Y[p]-3)/24-((2*z_haut*z_haut*z_haut-5*z_haut)*skew_Y[p]*skew_Y[p])/36;
				if (max_Y>q_haut[p]){ma=true;}
				if (min_Y<q_bas[p]){mi=true;}
			}
			
			K.setValue(Y);
			quantile_bas.setValue(q_bas);
			quantile_haut.setValue(q_haut);
			
			DecimalFormat f = new DecimalFormat();
			f.setMaximumFractionDigits(2);
			//redaction du petit texte de conclusion
			if (ma || mi)
			{results.setValue("Point distribution is not random");}
			else
			{results.setValue("Point distribution is random");}
			if (ma)
			{results_cluster.setValue("There are clusters with mean radius "+ f.format(dist_tab[indice_max]/1.3) +" pixels");}
			else{results_cluster.setValue("There is no cluster");}
			
			if (mi)
			{results_dispersion.setValue("Points are dispersed with distance "+ f.format(dist_tab[indice_min]) +" pixels");}
			else {results_dispersion.setValue("There is no dispersion");}
			
			

			
			
			if (exportExcel.getValue()) {
						for (int p = 0; p < N; p++) {
							tempi=Math.PI*dist_tab[p]*dist_tab[p]*Math.sqrt(var[p]);
							xls.setNumber( 0 , row , min.getValue()+p*pas.getValue() );
							xls.setNumber( 1 , row , Y[p] );
							//xls.setNumber( 2 , row , var[p] );
							//xls.setNumber( 3 , row , skew[p]/(tempi*tempi*tempi) );
							//xls.setNumber( 4 , row , kurt[p]/(tempi*tempi*tempi*tempi) );
							xls.setNumber( 2 , row , q_bas[p] );
							xls.setNumber( 3 , row , q_haut[p] );
							row++ ;					
						}}
						// calcul des intensites corrigees
						if (graph.getValue() == true) {
							plotGraph(K.getValue(),quantile_bas.getValue(),quantile_haut.getValue());
						}
						//fin de la boucle en temps
			}
		if (exportExcel.getValue())
		{
		xls.SaveAndClose();}

						
						//fin de la fonction perform analysis
			}
		
			//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////
	//

	// Calcul de la fonction de correlation (Ripley)
	private double[] corrfunction(HashMap<ROI2D, Vector<Spot>> ROI2Detection,double area, int nb_a,int N)	
	{
				
		
		double K[] = new double[N];
		int l=ROI2Detection.size();
		double K_tab[][] = new double[N][l];
		int inc=0;
		double CST = 0.0001;
		
		//on fait la boucle sur toutes les rois pour incrmenter le calcul de la fonction de Ripley
		
		for (ROI2D roi : ROI2Detection.keySet()) {
			
			Vector<Spot> spots = ROI2Detection.get(roi);		
			BooleanMask2D ma = roi.getAsBooleanMask(true);
			ArrayList<Point> polyg = getEdgePoints(ma);
			//il faut definir le nb local (par ROI) de detections afin de construire les boucles
			int nbdeta=spots.size();		
			
			for (int p = 0; p < nbdeta; p++) {
			double weight = 1;
			// distance du point a au bord de la ROI (polygon)
			Point pt1 = new Point((int) spots.get(p).mass_center.x, (int) spots.get(p).mass_center.y);
			
			double d = distance2Polygon(pt1, polyg);
			
			for (int p2 = 0; p2 < nbdeta; p2++) {
				Point pt2 = new Point((int) spots.get(p2).mass_center.x, (int) spots.get(p2).mass_center.y);
				double temp = pt1.distance(pt2);
				if (temp > CST) {
					// Calcul du poids (Ripley)
					weight = 1;
					if (d < temp) {
						weight = 1 - (Math.acos(d / temp)) / Math.PI;
					}
					for (int k = 0; k < N; k++) {
						if (temp < dist_tab[k]) {
							K[k] = K[k] + (1 / weight) * area / (nb_a * (nb_a - 1));
							K_tab[k][inc]=K_tab[k][inc]+(1 / weight)*area / (nb_a * (nb_a - 1));
						}
					}
				}
				}
			}
		inc=inc+1;		
		}
		
		return K;
	
		}


	// variance theorique

	private double[] variance_theo(double aire, double perimeter,int nb_a,int N){		
		double var[] = new double[N];
		for (int k = 0; k < N; k++) {
			double d2 = Math.pow(dist_tab[k], 2);
			double d3 = Math.pow(dist_tab[k], 3);
			double d4 = Math.pow(dist_tab[k], 4);
			double d5 = Math.pow(dist_tab[k], 5);

			var[k] = 2 * Math.pow(aire, 2) / (nb_a * (nb_a - 1)) * (Math.PI * d2 / aire + 0.96 * perimeter * d3 / Math.pow(aire, 2)  - Math.PI * Math.PI * d4 / (aire * aire) + (nb_a - 2) * 0.13 * perimeter * d5 / (aire * aire * aire));			                                                                         
		}
		return var;
	}
	private double[] skew_theo(double aire, double perimeter,int size,int N){ 

		double[] skew=new double[N];
		double alpha_2=size*(size-1);
        double alpha_3=alpha_2*(size-2);
        double alpha_4=alpha_3*(size-3);

		for (int k = 0; k < N; k++) {
			double d2 = Math.pow(dist_tab[k], 2);
			double e=Math.PI*d2;
			double betaa=e/aire;
	        double b=perimeter*dist_tab[k]/aire;
	    
	        //calcul du skew
	        //formule pour tout n
	        double t1=betaa*(1+0.76*b);
	        double t2=betaa*betaa*((-3+1.173*alpha_3/alpha_2)+(-0.915+alpha_3/alpha_2*0.414)*b);
	        double t3=betaa*betaa*betaa*(-2*alpha_3/alpha_2+0.012*alpha_4/alpha_2*b);
	        skew[k]=t1+t2+t3;
	        double a3=aire*aire*aire;
	        
	        double sizi=Math.pow(size*(size-1), 2);
	        skew[k]=(skew[k]*4*a3)/sizi;	        			        
		}
		return skew;
	}
	
	private double[] kurt_theo(double aire, double perimeter,int size,int N) {

		double[] kurt=new double[N];
		
		double alpha_2=size*(size-1);
        double alpha_3=alpha_2*(size-2);
        double alpha_4=alpha_3*(size-3);
        double alpha_5=alpha_4*(size-4);
        double alpha_6=alpha_5*(size-5);

		for (int k = 0; k < N; k++) {
			double d2 = dist_tab[k] * dist_tab[k];
			double e=Math.PI*d2;
			double betaa=e/aire;
	        double b=perimeter*dist_tab[k]/aire;
	        
	        
	        
	        //calcul du kurtosis
	        //formule pour tout n
	        /*double I1=betaa*(8+11.52*b);
	        double I2=betaa*betaa*((-32+104.3*(alpha_3/alpha_2)+12*(alpha_4/alpha_2))+(-24.32+78.7*(alpha_3/alpha_2)+7.32*(alpha_4/alpha_2))*b+(1.116*(alpha_4/alpha_2))*b*b);
	        double I3=betaa*betaa*betaa*((48-304.3*alpha_3/alpha_2-1.92*alpha_4/alpha_2)+(14.784-97.9*(alpha_3/alpha_2)+2.69*(alpha_4/alpha_2)+0.317*(alpha_5/alpha_2))*b+((alpha_5/alpha_2)*0.0966)*b*b);
	        double I4=betaa*betaa*betaa*betaa*(-36*(alpha_4/alpha_2)+0.0021*(alpha_6/alpha_2)*b*b);
	        */
	        double I1=betaa*(8+11.52*b);
	        double I2=betaa*betaa*size*((104.3+12*size)+(78.7+7.32*size)*b+(1.116*size)*b*b);
	        double I3=betaa*betaa*betaa*size*((-304.3-1.92*size)+(-97.9+2.69*size+0.317*Math.pow(size, 2))*b+(Math.pow(size, 2)*0.0966)*b*b);
	        double I4=betaa*betaa*betaa*betaa*Math.pow(size, 2)*(-36+0.0021*Math.pow(size, 2)*b*b);
	        
	        
	        kurt[k]=I1+I2+I3+I4;	       	       
	        double a4=aire*aire*aire*aire;
	        double s1=size-1;
	        double sizi=Math.pow(size*(size-1), 3);
	        kurt[k]=(kurt[k]*a4)/sizi;	        
	        
		}
		return kurt;

	}

	private double distance(Point mass_center, Point mass_center2) {
		return mass_center.distance(mass_center2);
	}

	/*
	 * private void var_K_theo(int N, int n_a, int n_b, double []dist_tab){
	 * 
	 * double [][] D_a= new double[n_a][n_a];
	 * 
	 * double [][][] A_a= new double[n_a][n_a][N]; double [][] h_a= new
	 * double[n_a][N];
	 * 
	 * // double [][] Aire= new double[n_e][N];
	 * 
	 * for (int k=0; k<N; k++) { for (int i=0; i<n_a; i++){ for (int j=i; j<n_a;
	 * j++){ D_a[i][j] = distance(pta , ptb ); // for (int t=0; t<N; t++){
	 * D_a[j][i] = D_a[i][j]; if (D_a[i][j]<2*dist_tab[k]){ A_a[i][j][k] =
	 * 2*dist_tab[k]*dist_tab[k] * Math.acos(D_a[i][j]/(2*dist_tab[k]) ) -
	 * 0.5*D_a[i][j] * Math.sqrt(4*dist_tab[k]*dist_tab[k] -
	 * D_a[i][j]*D_a[i][j]); A_a[j][i][k] = A_a[i][j][k]; } //} } } }
	 * 
	 * 
	 * 
	 * double []var_K_theo = new double[N] ;
	 * 
	 * double perim = new ROI2DPolygon().getAsBooleanMask() int area = roi.g;
	 * double I1, I2;
	 * 
	 * for (int k=0; k<N; k++){ // double dist = d_min+(j-1)*dx; //// dx???
	 * double e = Math.PI*dist_tab[k]*dist_tab[k]; I1 = 0.; I2=0;
	 * 
	 * double temp_A = 0;
	 * 
	 * for (int p=0;p<n_a;p++){ for (int n=p; p<n_a; n++){ temp_A =
	 * temp_A+A_a[p][n][k]*2; } }
	 * 
	 * double I3 = (temp_A-e*e/area * (n_a*(n_a-1)))*n_b/area;
	 * 
	 * 
	 * for (int p=0; p<n_a; p++){ // distance du point au bord double dist_a =
	 * distance2Polygon(pta, roi); if (dist_a<dist_tab[k]) h_a[p][k] = results[
	 * ]; else h_a[p][k] = 1; }
	 * 
	 * double sum_h_a = 0.; for ( int isum = 0; isum<n_a; isum++) sum_h_a +=
	 * h_a[isum][k]; double I4 = (e*sum_h_a - n_a*e*e/area)*n_b/area;
	 * var_K_theo[k] = (area/n_a*n_b)*(area/n_a*n_b)*(I1+I2+I3+I4)/
	 * (Math.PI*dist_tab[k]); }
	 * 
	 * // calcul des statistiques de test Y correspondantes for (int k=0;k<N;
	 * k++){ Y[k] = (K[k]-1)/(Math.sqrt(var_K_theo[k])); }
	 * 
	 * 
	 * }
	 */

	private double distance2Polygon(Point mass_center, ArrayList<Point> polyg) {
		double dist = Integer.MAX_VALUE;// roiPolyg.getPerimeter();

		int nbc = polyg.size();

		for (int i = 0; i < nbc; i++) {
			Point pt1 = polyg.get(i);
			double disttmp = mass_center.distance(pt1);
			dist = Math.min(dist, disttmp);
		}

		return (dist);

	}

	private double distancePt2Segment(Point2D pt, Point2D pt1, Point2D pt2) {
		double dist = 0.;
		double dAC = (pt1.getX() - pt.getX()) * (pt1.getX() - pt.getX()) + (pt1.getY() - pt.getY()) * (pt1.getY() - pt.getY());

		double[] v1 = new double[2];
		double[] v2 = new double[2];

		v1[0] = pt2.getX() - pt1.getX();
		v1[1] = pt2.getY() - pt1.getY();
		v2[0] = pt.getX() - pt1.getX();
		v2[1] = pt.getY() - pt1.getY();
		double r_numerator = dotProduct(v1, v2);
		double r_denomenator = (pt2.getX() - pt1.getX()) * (pt2.getX() - pt1.getX()) + (pt2.getY() - pt1.getY()) * (pt2.getY() - pt1.getY());

		double dAB = pt1.distance(pt2);
		r_denomenator = r_denomenator * r_denomenator;

		double r = r_numerator / r_denomenator;

		// System.out.println(" AC2:"+dAC+ " AB2:"+r_denomenator+ " AH:"+r);
		dAC = pt1.distance(pt);
		dAC = dAC * dAC;

		// System.out.println(" AC2:"+dAC);

		// double s =
		// ((pt1.getY()-pt.getY())*(pt2.getX()-pt1.getX())-(pt1.getX()-pt.getX())*(pt2.getY()-pt.getY())
		// ) / r_denomenator;
		// dist = Math.abs(s)*Math.sqrt(r_denomenator);

		dist = Math.sqrt(dAC - r);
		// System.out.println(" dist1:"+dist);

		dist = ((pt2.getX() - pt1.getX() * (pt1.getY() - pt.getY())) - (pt1.getX() - pt.getX()) * (pt2.getY() - pt1.getY()));
		dist = dist / dAB;

		// System.out.println(" dist2:"+dist);

		double x1 = pt1.getX();
		double y1 = pt1.getY();
		double x2 = pt2.getX();
		double y2 = pt2.getY();

		double px = pt.getX();
		double py = pt.getY();

		Line2D seg = new Line2D.Double();
		dist = Line2D.ptSegDist(x1, y1, x2, y2, px, py); // Ok

		return (dist);

	}

	private double dotProduct(double v1[], double v2[]) {

		double dotprod = 0;
		for (int i = 0; i < v1.length; i++)
			dotprod += v1[i] * v2[i];
		return dotprod;
	}

	public double getPerimeter(ROI2D roi) {
		// approximation by using number of point of the edge of boolean mask
		BooleanMask2D mas = roi.getAsBooleanMask(true);
		return getEdgePoints(mas).size();
	}

	public ArrayList<Point> getEdgePoints(BooleanMask2D ma) {
		if (ma.isEmpty())
			return new ArrayList<Point>(0);

		final ArrayList<Point> points = new ArrayList<Point>(1024);
		final int h = ma.bounds.height;
		final int w = ma.bounds.width;
		final int maxx = ma.bounds.x + (w - 1);
		final int maxy = ma.bounds.y + (h - 1);

		// cache
		boolean top = false;
		boolean bottom = false;
		boolean left = false;
		boolean right = false;
		boolean current;

		int offset = 0;

		// special case
		if ((w == 1) && (h == 1)) {
			if (ma.mask[0])
				points.add(new Point(ma.bounds.x, ma.bounds.y));
		} else if (w == 1) {
			// first pixel of row
			top = false;
			current = ma.mask[offset];
			bottom = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && bottom))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// row
			for (int y = ma.bounds.y + 1; y < maxy; y++) {
				// cache
				top = current;
				current = bottom;
				bottom = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && bottom))
					points.add(new Point(ma.bounds.x, y));
			}

			// cache
			top = current;
			current = bottom;
			bottom = false;

			// current pixel is a border ?
			if (current && !(top && bottom))
				points.add(new Point(ma.bounds.x, maxy));
		}
		// special case
		else if (h == 1) {
			// first pixel of line
			left = false;
			current = ma.mask[offset];
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(left && right))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(left && right))
					points.add(new Point(x, ma.bounds.y));
			}

			// last pixel of first line
			left = current;
			current = right;
			right = false;

			// current pixel is a border ?
			if (current && !(left && right))
				points.add(new Point(maxx, ma.bounds.y));
		} else {
			// first pixel of first line
			top = false;
			left = false;
			current = ma.mask[offset];
			bottom = ma.mask[offset + w];
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// first line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				bottom = ma.mask[offset + w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(x, ma.bounds.y));
			}

			// last pixel of first line
			left = current;
			current = right;
			bottom = ma.mask[offset + w];
			right = false;
			offset++;

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(maxx, ma.bounds.y));

			for (int y = ma.bounds.y + 1; y < maxy; y++) {
				// first pixel of line
				left = false;
				current = ma.mask[offset];
				top = ma.mask[offset - w];
				bottom = ma.mask[offset + w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(ma.bounds.x, y));

				for (int x = ma.bounds.x + 1; x < maxx; x++) {
					// cache
					left = current;
					current = right;
					top = ma.mask[offset - w];
					bottom = ma.mask[offset + w];
					right = ma.mask[++offset];

					// current pixel is a border ?
					if (current && !(top && left && right && bottom))
						points.add(new Point(x, y));
				}

				// last pixel of line
				left = current;
				current = right;
				top = ma.mask[offset - w];
				bottom = ma.mask[offset + w];
				right = false;
				offset++;

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(maxx, y));
			}

			// first pixel of last line
			left = false;
			current = ma.mask[offset];
			top = ma.mask[offset - w];
			bottom = false;
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(ma.bounds.x, maxy));

			// last line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				top = ma.mask[offset - w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(x, maxy));
			}

			// last pixel of last line
			left = current;
			current = right;
			top = ma.mask[offset - w];
			right = false;

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(maxx, maxy));
		}

		return points;
	}

	// AIRE
	private double Roiarea(ROI2D roi) {
		BooleanMask2D roiMask = roi.getAsBooleanMask(true);
		int minx = Math.max(0, roiMask.bounds.x);
		int maxx = roiMask.bounds.x + roiMask.bounds.width;
		int miny = Math.max(0, roiMask.bounds.y);
		int maxy = roiMask.bounds.y + roiMask.bounds.height;
		double intensitySpot = 0.;
		int areaR = 0;// size Cell
		for (int ix = minx; ix < maxx; ix++)
			for (int y = miny; y < maxy; y++) {
				if (roiMask.contains(ix, y)) {
					areaR++;
				}

			}
		return areaR;
	}

	private void plotGraph(double measurementList[], double q_bas[],double q_haut[] ) {
		
		final JFreeChart chart;
		XYSeriesCollection xyDataset = new XYSeriesCollection();

		chart = ChartFactory.createXYLineChart(
						"Ripley's K function", "pixels", "K", xyDataset,// xyDataset,yintervalseries
				PlotOrientation.VERTICAL, true, false, false);

		XYSeries seriesXY = new XYSeries("K function");
		XYSeries seriesXY_qb = new XYSeries("Quantile bas");
		XYSeries seriesXY_qh = new XYSeries("Quantile haut");
		xyDataset.addSeries(seriesXY);
		xyDataset.addSeries(seriesXY_qb);
		xyDataset.addSeries(seriesXY_qh);
		
		for (int t = 0; t < measurementList.length; t++) {
			seriesXY.add(dist_tab[t], measurementList[t]);
				seriesXY_qb.add(dist_tab[t], q_bas[t]);
				seriesXY_qh.add(dist_tab[t], q_haut[t]);			
			 
			
		}

		ThreadUtil.invokeLater(new Runnable() {

			@Override
			public void run() {
				IcyFrame graphFrame = new IcyFrame("graph", true, true, true, true);
				graphFrame.setContentPane(
								new ChartPanel(chart, 500, 200, 500, 200, 500, 500, false,
										false, true, true, true, true));
				graphFrame.setVisible(true);
				graphFrame.pack();
				graphFrame.addToMainDesktopPane();
				graphFrame.center();
			}
		});

	}

	@Override
	public void clean() {
		// TODO Auto-generated method stub

	}

	private Sequence doMaskSpots(Sequence seq, ArrayList<plugins.nchenouard.spot.Point3D> det) {

		int w = seq.getWidth();
		int h = seq.getHeight();

		IcyBufferedImage img = seq.getFirstImage();

		double[] tab = Array1DUtil.arrayToDoubleArray(img.getDataXY(0), img.isSignedDataType());

		Sequence seqOut = new Sequence();
		IcyBufferedImage imageOut = new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), seq.getSizeC(), seq.getDataType_());

		double[] tabOut = Array1DUtil.arrayToDoubleArray(imageOut.getDataXY(0), imageOut.isSignedDataType());

		for (plugins.nchenouard.spot.Point3D pt : det) {
			int x = (int) pt.x;
			int y = (int) pt.y;

			tabOut[x + y * w] = tab[x + y * w];

		}

		imageOut.setDataXY(0, Array1DUtil.doubleArrayToArray(tabOut, imageOut.getDataXY(0)));

		seqOut.addImage(imageOut);
		seqOut.dataChanged();
		return (seqOut);

	}
	private 	HashMap<ROI2D, Vector<Spot>> detectionsInRoi(Sequence sequence, Vector<Spot> detection, ArrayList<ROI2D> roiArrayList ){
		// SEQUENCE A remplacer par w,h	
			
			// create a hashMap with the detections binded to ROI
		
			HashMap<ROI2D, Vector<Spot>> ROI2Detection = new HashMap<ROI2D, Vector<Spot>>();
		
			// create a fake ROI taking all the sequence if no existing ROI on
			// sequence.
			if (roiArrayList.size() == 0) {
				ROI2Detection.put(new ROI2DRectangle(new Point2D.Double(0, 0), new Point2D.Double(sequence.getWidth(),
						sequence.getHeight()), false), (Vector<Spot>) detection.clone());
			} else { // there is ROI is the sequence
		
				// setup hashMap
				for (ROI2D roi : roiArrayList) {
					ROI2Detection.put(roi, new Vector<Spot>());
				}
		
				// fill hashMap
				for (ROI2D roi : roiArrayList) {
					for (Spot spot : detection) {
						if (roi.contains(spot.mass_center.x, spot.mass_center.y)) {
							ROI2Detection.get(roi).add(spot);
						}
					}
				}
			}
		
			// rebuild the detectionResult with what has been found in ROIs
		
			detection.clear();
			// Set<Entry<ROI2D, ArrayList<DetectionSpot>>> roiList =
			// ROI2Detection.keySet();
			for (ROI2D roi : ROI2Detection.keySet()) {
				for (Spot s : ROI2Detection.get(roi)) {
					detection.add(s);
				}
			}
		
			if (detection.size() == 0) {
				new AnnounceFrame("There is no detection associated with the ROI(s)");
			
			}
			
			return(ROI2Detection);
		}


}
