package plugins.fab.manualcounting;

import java.util.ArrayList;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.painter.Overlay;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;

public class ManualCounting extends PluginActionable {

	@Override
	public void run() {

		Sequence sequence = getActiveSequence();
		if ( sequence == null )
		{
			new AnnounceFrame( "A sequence must be opened to use this plugin." , 5 );
			return;
		}
		
		new ToolTipFrame ("<html>Manual Counting is active" +
				"<ul><li>Click to add a manual detection ROI" +
				"<li>Right Click to delete a manual detection"+
				"<li>c: cycle colors"+
				"</html>" , 100 );
		
		ArrayList <Overlay> overlayList = new ArrayList<Overlay>( getActiveSequence().getOverlays() );
		for ( Overlay overlay : overlayList ){
			if ( overlay instanceof ManualCountingOverlay )
			{
				sequence.removeOverlay( overlay );
			}
		}
		
		sequence.addOverlay( new ManualCountingOverlay() );

		int[] ii = new int[3];
		
		
	}

}
