package plugins.worm.waveletfilter;

import java.util.ArrayList;
import java.util.HashMap;

import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;
import plugins.oeway.featureExtraction.featureExtractionPlugin;
import plugins.oeway.viewers.EzVarChart1D;
import icy.type.point.Point5D;

public class WaveletFilter extends featureExtractionPlugin  {

	private enum DBIndex
	{
		DB1,DB2,DB3,DB4,DB5,DB6,DB7,DB8,DB9,DB10,coif6,coif12,coif18,coif24,coif30,
	}
	private enum Thresholding
	{
		Hard,Soft,
	}
	private EzVarInteger						DecomposeLevel  	;
	private EzVarChart1D						SignalProfile		;
	private EzVarEnum<DBIndex>					DBSelect			;
	private EzVarEnum<Thresholding>				ThresholdingSetting	;
	private EzVarDouble							threshold			;
	
	int index = 0;
	int sigma = 0;
	

	@Override
	public void initialize(HashMap<String,Object> options,ArrayList<Object> optionUI) {
		DBSelect			= new EzVarEnum<DBIndex>("DB Index",DBIndex.values(),8);
		//DBIndex	= new EzVarInteger("DB Index :");
		DecomposeLevel		= new EzVarInteger("Decompoese Level:",3,1,8,1);
		ThresholdingSetting = new EzVarEnum<Thresholding>("Thresholding Mode",Thresholding.values(),1);
		SignalProfile 		= new EzVarChart1D("Wavlet Waveform");
		threshold			= new EzVarDouble("Threshold Vaule");	

		  for(int i =0;i<DBIndex.values().length;i++){
		       	 if(DBSelect.getValue()== DBIndex.values()[i])
		       	 {
		       		 index = i ;
		       		 break;
		       	 }
		       }
		  SignalProfile.setValue(Wavelet.getWaveletScale(index));
		EzVarListener<DBIndex> listener1 = new EzVarListener<DBIndex>()
			{

				@Override
				public void variableChanged(EzVar<DBIndex> source,
						DBIndex newValue) {

					  for(int i =0;i<DBIndex.values().length;i++){
					       	 if(DBSelect.getValue()== DBIndex.values()[i])
					       	 {
					       		 index = i ;
					       		 break;
					       	 }
					       }
					SignalProfile.setValue(Wavelet.getWaveletScale(index));
				}
		
			};
		DBSelect.addVarChangeListener(listener1);
//		VarListener<Thresholding> listener2 = new VarListener<Thresholding>()
//				{
//
//					@Override
//					public void valueChanged(Var<Thresholding> source, Thresholding oldValue,
//							Thresholding newValue) {
//						if(ThresholdingSetting.getValue()==Thresholding.Hard){
//							
//							}
//						else
//						{
//							
//						}
//						
//					}
//
//					@Override
//					public void referenceChanged(Var<Thresholding> source,
//							Var<? extends Thresholding> oldReference,
//							Var<? extends Thresholding> newReference) {
//						// TODO Auto-generated method stub
//						
//					}
//			
//				};
//		ThresholdingSetting.getVariable().addListener(listener2);
		optionUI.add(DBSelect);
		optionUI.add(DecomposeLevel);
		optionUI.add(ThresholdingSetting);
		optionUI.add(threshold);
		
		
		optionUI.add(SignalProfile);
		ThresholdingSetting.addVisibilityTriggerTo(threshold, Thresholding.Hard);
		
		

	}
      

	

	@Override
	public double[] process(double[] input,double[] position) {
		
		double[] output = null;
		double [] PreSingnalArray = input;
        double[] in=copydata(PreSingnalArray);
        

        Wavelet wl= new Wavelet(index);
        double[] dec=wl.decompose(in,DecomposeLevel.getValue()); //decompose signal and print
        //Threshold detail coefficients
        //Determine threshold using visushrink
        double t=wl.getVisushrinkThreshold(in,DecomposeLevel.getValue());
        double[] dec2= null;
        if(ThresholdingSetting.getValue()==Thresholding.Soft){
        	dec2=Wavelet.thresholdDetails(dec,DecomposeLevel.getValue(),t,false);
        }
        else
        {
        	dec2=Wavelet.thresholdDetails(dec,DecomposeLevel.getValue(),threshold.getValue(),true);
        }
        
      //Reconstruct signal
        output=wl.reconstruct(dec2,DecomposeLevel.getValue());
       
		return output;
		
	}
	public double[] copydata(double[]origin){
		double[] output= new double[origin.length];
		for(int i= 0;i<origin.length;i++){
			output[i]=origin[i];
			
		}
		return output;
	}

}
