/*
 * Decompiled with CFR 0.152.
 */
package weiss.ellipse2D;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class Ellipso2D {
    public double a = 0.0;
    public double b = 0.0;
    public double x0 = 0.0;
    public double y0 = 0.0;
    public double alpha = 0.0;
    public Color c;

    public Ellipso2D(double x0, double y0, double a, double b, double alpha) {
        this.x0 = x0;
        this.y0 = y0;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
    }

    public void setColor(Color c) {
        this.c = c;
    }

    public Overlay toOverlay() {
        return new EllipseOverlay2D("Ellipse");
    }

    protected class EllipseOverlay2D
    extends Overlay {
        protected EllipseOverlay2D(String name) {
            super(name);
        }

        public void paint(Graphics2D g2, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                float fontSize = (float)canvas.canvasToImageLogDeltaX(30);
                g2.setFont(new Font("Trebuchet MS", 1, 10).deriveFont(fontSize));
                double stroke = Math.max(canvas.canvasToImageLogDeltaX(3), canvas.canvasToImageLogDeltaY(3));
                g2.setStroke(new BasicStroke((float)stroke, 1, 1));
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                Color c = Ellipso2D.this.c;
                g2.setColor(c);
                Ellipse2D.Double baseShape = new Ellipse2D.Double(Ellipso2D.this.x0 - Ellipso2D.this.a, Ellipso2D.this.y0 - Ellipso2D.this.b, 2.0 * Ellipso2D.this.a, 2.0 * Ellipso2D.this.b);
                Shape rotatedShape = AffineTransform.getRotateInstance(Ellipso2D.this.alpha, Ellipso2D.this.x0, Ellipso2D.this.y0).createTransformedShape(baseShape);
                g2.draw(rotatedShape);
            }
        }
    }
}

