/*
 * Decompiled with CFR 0.152.
 */
package kovac.res;

import icy.painter.Overlay;
import icy.sequence.DimensionId;
import icy.type.point.Point3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kovac.maths.EllipsoidAlgorithm;
import kovac.res.util.LinkedViewersUtil;
import kovac.saving.SavingStatic;
import kovac.shapes.EllipsoidOverlay;
import kovac.shapes.GroupPointsOverlay;
import kovac.shapes.PointOverlay;
import plugins.weiss.fitellipsoid.fitellipsoid;

public class Points {
    private static List<PointInSpace> points = new ArrayList<PointInSpace>();
    private static List<GroupPointsOverlay> groups = new ArrayList<GroupPointsOverlay>();
    private static Map<Integer, List<PointInSpace>> multiplePointsEllipse = new HashMap<Integer, List<PointInSpace>>();

    public static void addPoint(Point3D p, DimensionId dim) {
        points.add(new PointInSpace(p, dim));
    }

    private static void clearPointsOverlays() {
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            if (!(o instanceof PointOverlay)) continue;
            LinkedViewersUtil.removeOverlayFromVTK(o);
        }
    }

    public static void clearEllipsoidsOverlays() {
        for (Overlay o : LinkedViewersUtil.getVTKOverlays()) {
            if (!(o instanceof EllipsoidOverlay)) continue;
            LinkedViewersUtil.removeOverlayFromVTK(o);
        }
    }

    public static void remove(PointInSpace pt) {
        for (List<PointInSpace> list : multiplePointsEllipse.values()) {
            list.remove(pt);
        }
        points.remove(pt);
    }

    public static void saveCurrentList() {
        if (points.isEmpty()) {
            return;
        }
        ArrayList<PointInSpace> save = new ArrayList<PointInSpace>(points);
        multiplePointsEllipse.put(multiplePointsEllipse.keySet().size(), save);
        points.clear();
    }

    public static List<PointInSpace> getAllPoints() {
        ArrayList<PointInSpace> ret = new ArrayList<PointInSpace>();
        for (List<PointInSpace> pts : multiplePointsEllipse.values()) {
            ret.addAll(pts);
        }
        ret.addAll(points);
        return ret;
    }

    public static void removeLastOne() {
        if (points.isEmpty()) {
            System.out.println("No remaining points. Cannot remove.");
            return;
        }
        points.get(points.size() - 1).getOverlay().remove();
        points.remove(points.size() - 1);
        LinkedViewersUtil.getOrthCanvas().repaint();
    }

    public static void clear() {
        multiplePointsEllipse.clear();
        Points.clearPointsOverlays();
    }

    public static void createEllipsoids() {
        EllipsoidAlgorithm algo = null;
        EllipsoidOverlay ellipsoid = null;
        ArrayList<Point3D> pointsToUse = new ArrayList<Point3D>();
        int i = 1;
        for (List<PointInSpace> currentList : multiplePointsEllipse.values()) {
            System.out.println("Generating ellipsoid number " + i++);
            for (PointInSpace pt : currentList) {
                pointsToUse.add(pt.getPoint());
            }
        }
        if (pointsToUse.size() > 12) {
            algo = new EllipsoidAlgorithm(pointsToUse);
            ellipsoid = algo.generateEllipsoid();
            ellipsoid.setName("Ellipsoid " + SavingStatic.getNumberOfEllipsoids());
            ellipsoid.validate();
            LinkedViewersUtil.addOverlayToVTK(ellipsoid);
            if (fitellipsoid.isDisplayingPoints()) {
                GroupPointsOverlay group = new GroupPointsOverlay("Group number " + groups.size(), pointsToUse);
                groups.add(group);
                LinkedViewersUtil.addOverlayToVTK(group);
            }
            ellipsoid.checkValues();
            pointsToUse.clear();
            Points.clear();
        } else {
            System.out.println("Not enough points. Minimum is 12. Please add some.");
        }
    }

    public static class PointInSpace {
        private Point3D pt;
        private DimensionId dim;
        private Overlay overlay;

        public PointInSpace(Point3D pt, DimensionId dim) {
            this.pt = pt;
            this.dim = dim;
            this.overlay = new PointOverlay("Point " + points.size(), this.pt);
        }

        public Point3D getPoint() {
            return this.pt;
        }

        public DimensionId getDim() {
            return this.dim;
        }

        public Overlay getOverlay() {
            return this.overlay;
        }
    }
}

