/*
 * Decompiled with CFR 0.152.
 */
package kovac.res;

import Jama.Matrix;
import kovac.res.enums.Axis;
import kovac.res.util.LinkedViewersUtil;
import kovac.shapes.EllipsoidOverlay;

public class EllipsoidTransformations {
    private Matrix matSR;
    private double[] center;
    private Matrix scalingMatrix;
    private Matrix newMatSR;
    private double[] newCenter;
    private EllipsoidOverlay ellipsoid;

    public EllipsoidTransformations(Matrix matSR, double[] center, EllipsoidOverlay o) {
        this.matSR = matSR;
        this.center = center;
        this.ellipsoid = o;
        this.newMatSR = this.matSR;
        this.newCenter = this.center;
        this.scalingMatrix = new Matrix(3, 3);
    }

    public void applyTranslation(double x, double y, double z) {
        this.newCenter[0] = this.newCenter[0] + x;
        this.newCenter[1] = this.newCenter[1] + y;
        this.newCenter[2] = this.newCenter[2] + z;
    }

    public void applyScaling(double s, Axis ... axis) {
        Axis[] axisArray = axis;
        int n = axis.length;
        int n2 = 0;
        while (n2 < n) {
            Axis a = axisArray[n2];
            switch (a) {
                case X: {
                    this.scalingMatrix.set(0, 0, s);
                    break;
                }
                case Y: {
                    this.scalingMatrix.set(1, 1, s);
                    break;
                }
                case Z: {
                    this.scalingMatrix.set(2, 2, s);
                    break;
                }
            }
            ++n2;
        }
        this.newMatSR = this.scalingMatrix.times(this.newMatSR);
    }

    public void applyRotation(double alpha, Axis ... axis) {
        Matrix[] rotations = new Matrix[3];
        int i = 0;
        while (i < rotations.length) {
            rotations[i] = Matrix.identity((int)3, (int)3);
            ++i;
        }
        Matrix rotX = EllipsoidTransformations.getRotationMatrix(Axis.X, alpha);
        Matrix rotY = EllipsoidTransformations.getRotationMatrix(Axis.Y, alpha);
        Matrix rotZ = EllipsoidTransformations.getRotationMatrix(Axis.Z, alpha);
        Matrix finalRotation = rotX.times(rotY).times(rotZ);
        this.newMatSR = finalRotation.times(this.newMatSR);
    }

    public static Matrix getRotationMatrix(Axis a, double alpha) {
        double[][] rotArray = new double[3][3];
        switch (a) {
            case X: {
                rotArray[0][0] = 1.0;
                rotArray[1][1] = Math.cos(alpha);
                rotArray[1][2] = -Math.sin(alpha);
                rotArray[2][1] = Math.sin(alpha);
                rotArray[2][2] = Math.cos(alpha);
                break;
            }
            case Y: {
                rotArray[1][1] = 1.0;
                rotArray[0][0] = Math.cos(alpha);
                rotArray[2][0] = -Math.sin(alpha);
                rotArray[0][2] = Math.sin(alpha);
                rotArray[2][2] = Math.cos(alpha);
                break;
            }
            case Z: {
                rotArray[2][2] = 1.0;
                rotArray[0][0] = Math.cos(alpha);
                rotArray[0][1] = -Math.sin(alpha);
                rotArray[1][0] = Math.sin(alpha);
                rotArray[1][1] = Math.cos(alpha);
                break;
            }
            default: {
                int i = 0;
                while (i < rotArray.length) {
                    rotArray[i][i] = 1.0;
                    ++i;
                }
                break block0;
            }
        }
        return new Matrix(rotArray);
    }

    public Matrix getNewMatrix() {
        return this.newMatSR;
    }

    public double[] getNewCenter() {
        return this.newCenter;
    }

    public void cancel() {
        this.newMatSR = this.matSR;
        this.newCenter = this.center;
    }

    public void validate() {
        this.ellipsoid.applyTransformation();
        LinkedViewersUtil.getOrthCanvas().repaint();
    }
}

