/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import java.util.ArrayList;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfig;
import plugins.tinevez.rieszwavelets.StandardRieszFrames;

public class RieszGeneralization {
    StandardRieszFrames frameType;
    double[][] weightMatrixForward;
    double[][] weightMatrixBackward;
    boolean realCoefficients;

    public RieszGeneralization(StandardRieszFrames frameType, RieszConfig config) {
        this.frameType = frameType;
        switch (frameType) {
            case CircularHarmonics: {
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixBackward = this.weightMatrixForward;
                int i = 0;
                while (i < config.numChannels) {
                    this.weightMatrixForward[i][2 * i] = 1.0 / Math.sqrt(config.numChannels);
                    ++i;
                }
                this.realCoefficients = false;
                break;
            }
            case Gradient: {
                if (config.order != 1 || config.harmonicType != HarmonicTypes.odd) {
                    throw new IllegalArgumentException("Gradient frame requires Riesz of order 1 and odd harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = 0.0;
                this.weightMatrixForward[0][1] = 0.5;
                this.weightMatrixForward[0][2] = -0.5;
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = 0.5;
                this.weightMatrixForward[1][2] = 0.5;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = true;
                break;
            }
            case Hessian: {
                if (config.order != 2 || config.harmonicType != HarmonicTypes.even) {
                    throw new IllegalArgumentException("Hessian frame requires Riesz of order 2 and even harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = -0.25;
                this.weightMatrixForward[0][1] = 0.0;
                this.weightMatrixForward[0][2] = -0.5;
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[0][4] = -0.25;
                this.weightMatrixForward[0][5] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[1][2] = 0.0;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixForward[1][4] = 0.0;
                this.weightMatrixForward[1][5] = 1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][0] = 0.25;
                this.weightMatrixForward[2][1] = 0.0;
                this.weightMatrixForward[2][2] = -0.5;
                this.weightMatrixForward[2][3] = 0.0;
                this.weightMatrixForward[2][4] = 0.25;
                this.weightMatrixForward[2][5] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = true;
                break;
            }
            case Monogenic: {
                if (config.order != 1 || config.harmonicType != HarmonicTypes.complete) {
                    throw new IllegalArgumentException("Monogenic frame requires Riesz of order 1 and complete harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = 0.0;
                this.weightMatrixForward[0][1] = 0.0;
                this.weightMatrixForward[0][2] = 1.0 / Math.sqrt(2.0);
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[0][4] = 0.0;
                this.weightMatrixForward[0][5] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[1][2] = 0.0;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixForward[1][4] = 0.0;
                this.weightMatrixForward[1][5] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][0] = 1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][1] = 0.0;
                this.weightMatrixForward[2][2] = 0.0;
                this.weightMatrixForward[2][3] = 0.0;
                this.weightMatrixForward[2][4] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][5] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = false;
                break;
            }
            case Prolate: {
                throw new IllegalArgumentException("Prolate Riesz wavelets not implemented yet in the library");
            }
            case ProlateUniSided: {
                throw new IllegalArgumentException("Prolate Riesz wavelets not implemented yet in the library");
            }
            case Riesz: {
                switch (config.harmonicType) {
                    case even: {
                        this.weightMatrixForward = this.getRieszForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case odd: {
                        this.weightMatrixForward = this.getRieszForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case complete: {
                        int orderEven = config.order - config.order % 2;
                        ArrayList<Integer> evenHarmonics = new ArrayList<Integer>();
                        ArrayList<Integer> oddHarmonics = new ArrayList<Integer>();
                        int i = 0;
                        while (i < config.harmonics.length) {
                            if (Math.abs(config.harmonics[i]) % 2 == 0) {
                                evenHarmonics.add(config.harmonics[i]);
                            } else {
                                oddHarmonics.add(config.harmonics[i]);
                            }
                            ++i;
                        }
                        int[] evenHarmonicsTab = new int[evenHarmonics.size()];
                        int i2 = 0;
                        while (i2 < evenHarmonics.size()) {
                            evenHarmonicsTab[i2] = (Integer)evenHarmonics.get(i2);
                            ++i2;
                        }
                        int[] oddHarmonicsTab = new int[oddHarmonics.size()];
                        int i3 = 0;
                        while (i3 < oddHarmonics.size()) {
                            oddHarmonicsTab[i3] = (Integer)oddHarmonics.get(i3);
                            ++i3;
                        }
                        double[][] evenMatrix = this.getRieszForwardMatrix(orderEven, evenHarmonicsTab);
                        int orderOdd = config.order + config.order % 2 - 1;
                        double[][] oddMatrix = this.getRieszForwardMatrix(orderOdd, oddHarmonicsTab);
                        this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                        int idxEven = 0;
                        int idxOdd = 0;
                        int i4 = 0;
                        while (i4 < config.harmonics.length) {
                            int j;
                            if (Math.abs(config.harmonics[i4]) % 2 == 0) {
                                int idxEven2 = 0;
                                j = 0;
                                while (j < config.harmonics.length) {
                                    if (Math.abs(config.harmonics[j]) % 2 == 0) {
                                        this.weightMatrixForward[i4][2 * j] = evenMatrix[idxEven][2 * idxEven2];
                                        this.weightMatrixForward[i4][2 * j + 1] = evenMatrix[idxEven][2 * idxEven2 + 1];
                                        ++idxEven2;
                                    }
                                    ++j;
                                }
                                ++idxEven;
                            } else {
                                int idxOdd2 = 0;
                                j = 0;
                                while (j < config.harmonics.length) {
                                    if (Math.abs(config.harmonics[j]) % 2 != 0) {
                                        this.weightMatrixForward[i4][2 * j] = oddMatrix[idxOdd][2 * idxOdd2];
                                        this.weightMatrixForward[i4][2 * j + 1] = oddMatrix[idxOdd][2 * idxOdd2 + 1];
                                        ++idxOdd2;
                                    }
                                    ++j;
                                }
                                ++idxOdd;
                            }
                            ++i4;
                        }
                        i4 = 0;
                        while (i4 < this.weightMatrixForward.length) {
                            int j = 0;
                            while (j < this.weightMatrixForward[i4].length) {
                                this.weightMatrixForward[i4][j] = this.weightMatrixForward[i4][j] / Math.sqrt(2.0);
                                ++j;
                            }
                            ++i4;
                        }
                        this.realCoefficients = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("This type of harmonics is not supported for Riesz frames");
                    }
                }
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                break;
            }
            case Simoncelli: {
                switch (config.harmonicType) {
                    case even: {
                        this.weightMatrixForward = this.getSimoncelliForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case odd: {
                        this.weightMatrixForward = this.getSimoncelliForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case complete: {
                        int orderEven = config.order - config.order % 2;
                        ArrayList<Integer> evenHarmonics = new ArrayList<Integer>();
                        ArrayList<Integer> oddHarmonics = new ArrayList<Integer>();
                        int i = 0;
                        while (i < config.harmonics.length) {
                            if (Math.abs(config.harmonics[i]) % 2 == 0) {
                                evenHarmonics.add(config.harmonics[i]);
                            } else {
                                oddHarmonics.add(config.harmonics[i]);
                            }
                            ++i;
                        }
                        int[] evenHarmonicsTab = new int[evenHarmonics.size()];
                        int i5 = 0;
                        while (i5 < evenHarmonics.size()) {
                            evenHarmonicsTab[i5] = (Integer)evenHarmonics.get(i5);
                            ++i5;
                        }
                        int[] oddHarmonicsTab = new int[oddHarmonics.size()];
                        int i6 = 0;
                        while (i6 < oddHarmonics.size()) {
                            oddHarmonicsTab[i6] = (Integer)oddHarmonics.get(i6);
                            ++i6;
                        }
                        double[][] evenMatrix = this.getSimoncelliForwardMatrix(orderEven, evenHarmonicsTab);
                        int orderOdd = config.order + config.order % 2 - 1;
                        double[][] oddMatrix = this.getSimoncelliForwardMatrix(orderOdd, oddHarmonicsTab);
                        this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                        int idxEven = 0;
                        int idxOdd = 0;
                        int i7 = 0;
                        while (i7 < config.harmonics.length) {
                            int j;
                            if (Math.abs(config.harmonics[i7]) % 2 == 0) {
                                int idxEven2 = 0;
                                j = 0;
                                while (j < config.harmonics.length) {
                                    if (Math.abs(config.harmonics[j]) % 2 == 0) {
                                        this.weightMatrixForward[i7][2 * j] = evenMatrix[idxEven][2 * idxEven2];
                                        this.weightMatrixForward[i7][2 * j + 1] = evenMatrix[idxEven][2 * idxEven2 + 1];
                                        ++idxEven2;
                                    }
                                    ++j;
                                }
                                ++idxEven;
                            } else {
                                int idxOdd2 = 0;
                                j = 0;
                                while (j < config.harmonics.length) {
                                    if (Math.abs(config.harmonics[j]) % 2 != 0) {
                                        this.weightMatrixForward[i7][2 * j] = oddMatrix[idxOdd][2 * idxOdd2];
                                        this.weightMatrixForward[i7][2 * j + 1] = oddMatrix[idxOdd][2 * idxOdd2 + 1];
                                        ++idxOdd2;
                                    }
                                    ++j;
                                }
                                ++idxOdd;
                            }
                            ++i7;
                        }
                        i7 = 0;
                        while (i7 < this.weightMatrixForward.length) {
                            int j = 0;
                            while (j < this.weightMatrixForward[i7].length) {
                                this.weightMatrixForward[i7][j] = this.weightMatrixForward[i7][j] / Math.sqrt(2.0);
                                ++j;
                            }
                            ++i7;
                        }
                        this.realCoefficients = true;
                    }
                }
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                break;
            }
            case Slepian: {
                throw new IllegalArgumentException("Slepian Riesz wavelets not implemented yet in the library");
            }
        }
    }

    private long factorial(int n) {
        long factorial = 1L;
        int i = 2;
        while (i <= n) {
            factorial *= (long)i;
            ++i;
        }
        return factorial;
    }

    public void printForwardMatrix() {
        System.out.println("Forward generalization matrix:");
        if (this.weightMatrixForward == null) {
            System.out.println("null");
        } else {
            int i = 0;
            while (i < this.weightMatrixForward.length) {
                int j = 0;
                while (j < this.weightMatrixForward[i].length / 2) {
                    System.out.print(String.valueOf(this.weightMatrixForward[i][2 * j]) + " + " + this.weightMatrixForward[i][2 * j + 1] + "j |");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
    }

    public void printBackwardMatrix() {
        System.out.println("Backward generalization matrix:");
        if (this.weightMatrixBackward == null) {
            System.out.println("null");
        } else {
            int i = 0;
            while (i < this.weightMatrixBackward.length) {
                int j = 0;
                while (j < this.weightMatrixBackward[i].length / 2) {
                    System.out.print(String.valueOf(this.weightMatrixBackward[i][2 * j]) + " + " + this.weightMatrixBackward[i][2 * j + 1] + "j |");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
    }

    public double[][] transposeComplexMatrix(double[][] matrix) {
        double[][] transposeMatrix = new double[matrix[0].length / 2][matrix.length * 2];
        int i = 0;
        while (i < transposeMatrix.length) {
            int j = 0;
            while (j < transposeMatrix[i].length / 2) {
                transposeMatrix[j][2 * i] = matrix[i][2 * j];
                transposeMatrix[j][2 * i + 1] = -matrix[i][2 * j + 1];
                ++j;
            }
            ++i;
        }
        return transposeMatrix;
    }

    public double[][] getRieszForwardMatrix(int order, int[] harmonics) {
        double[][] matrix = new double[harmonics.length][2 * harmonics.length];
        long factorialOrder = this.factorial(order);
        int n = order / 2;
        int n1 = 0;
        while (n1 <= order) {
            int n2 = order - n1;
            long factN1 = this.factorial(n1);
            long factN2 = this.factorial(n2);
            double fact1 = Math.sqrt(factorialOrder / (factN1 * factN2)) / Math.pow(-2.0, order);
            double factR1 = 0.0;
            double factI1 = 0.0;
            switch (n1 % 4) {
                case 0: {
                    factR1 = fact1;
                    break;
                }
                case 1: {
                    factI1 = fact1;
                    break;
                }
                case 2: {
                    factR1 = -fact1;
                    break;
                }
                case 3: {
                    factI1 = -fact1;
                }
            }
            int n1b = 0;
            while (n1b <= n1) {
                long factN1b = this.factorial(n1b);
                long factN1c = this.factorial(n1 - n1b);
                int n2b = 0;
                while (n2b <= n2) {
                    long factN2b = this.factorial(n2b);
                    long factN2c = this.factorial(n2 - n2b);
                    double factb = factN1 * factN2 / (factN1b * factN1c * factN2b * factN2c);
                    if ((n2 - n2b) % 2 > 0) {
                        factb = -factb;
                    }
                    int h = order % 2 == 0 ? 2 * (n1b + n2b - n) : 2 * (n1b + n2b - n) - 1;
                    int idx = -1;
                    int i = 0;
                    while (i < harmonics.length) {
                        if (harmonics[i] == h) {
                            idx = i;
                            break;
                        }
                        ++i;
                    }
                    double[] dArray = matrix[idx];
                    int n3 = 2 * n1;
                    dArray[n3] = dArray[n3] + factR1 * factb;
                    double[] dArray2 = matrix[idx];
                    int n4 = 2 * n1 + 1;
                    dArray2[n4] = dArray2[n4] + factI1 * factb;
                    ++n2b;
                }
                ++n1b;
            }
            ++n1;
        }
        return matrix;
    }

    public double[][] getSimoncelliForwardMatrix(int order, int[] harmonics) {
        int j;
        int numChannels = harmonics.length;
        int Np = (int)Math.floor(order / 2);
        long factOrder = this.factorial(order);
        double[][] matrix = new double[harmonics.length][2 * harmonics.length];
        int j2 = 0;
        while (j2 < numChannels) {
            double thetaj = Math.PI * (double)j2 / (double)numChannels + 1.5707963267948966;
            int i = 0;
            while (i < numChannels) {
                int npp = harmonics[i];
                double fact = 0.0;
                fact = npp % 2 == 0 ? (double)(factOrder / (this.factorial(Np + npp / 2) * this.factorial(Np - npp / 2))) : (double)(factOrder / (this.factorial(Np + (npp + 1) / 2) * this.factorial(Np - (npp - 1) / 2)));
                switch (order % 4) {
                    case 0: {
                        matrix[i][2 * j2] = fact * Math.cos((double)npp * thetaj);
                        matrix[i][2 * j2 + 1] = fact * Math.sin((double)npp * thetaj);
                        break;
                    }
                    case 1: {
                        matrix[i][2 * j2] = fact * Math.sin((double)npp * thetaj);
                        matrix[i][2 * j2 + 1] = -fact * Math.cos((double)npp * thetaj);
                        break;
                    }
                    case 2: {
                        matrix[i][2 * j2] = -fact * Math.cos((double)npp * thetaj);
                        matrix[i][2 * j2 + 1] = -fact * Math.sin((double)npp * thetaj);
                        break;
                    }
                    case 3: {
                        matrix[i][2 * j2] = -fact * Math.sin((double)npp * thetaj);
                        matrix[i][2 * j2 + 1] = fact * Math.cos((double)npp * thetaj);
                    }
                }
                ++i;
            }
            ++j2;
        }
        double sumSq = 0.0;
        int i = 0;
        while (i < matrix.length) {
            j = 0;
            while (j < matrix[i].length) {
                sumSq += matrix[i][j] * matrix[i][j];
                ++j;
            }
            ++i;
        }
        sumSq = Math.sqrt(sumSq);
        i = 0;
        while (i < matrix.length) {
            j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = matrix[i][j] / sumSq;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public double[][] combineBandsForwardComplex(double[][] bands) {
        return this.combineBandsComplex(bands, this.weightMatrixForward);
    }

    public double[][] combineBandsBackwardComplex(double[][] bands) {
        return this.combineBandsComplex(bands, this.weightMatrixBackward);
    }

    public double[][] combineBandsComplex(double[][] bands, double[][] weightMatrix) {
        int numCoefficients = bands[0].length / 2;
        double[][] projectedBands = new double[weightMatrix[0].length / 2][numCoefficients * 2];
        int i = 0;
        while (i < projectedBands.length) {
            int t = 0;
            while (t < numCoefficients) {
                double val = 0.0;
                int j = 0;
                while (j < bands.length) {
                    val += bands[j][2 * t] * weightMatrix[j][2 * i] - bands[j][2 * t + 1] * weightMatrix[j][2 * i + 1];
                    ++j;
                }
                projectedBands[i][2 * t] = val;
                val = 0.0;
                j = 0;
                while (j < bands.length) {
                    val += bands[j][2 * t] * weightMatrix[j][2 * i + 1] + bands[j][2 * t + 1] * weightMatrix[j][2 * i];
                    ++j;
                }
                projectedBands[i][2 * t + 1] = val;
                ++t;
            }
            ++i;
        }
        return projectedBands;
    }

    public StandardRieszFrames getRieszFrame() {
        return this.frameType;
    }
}

