package plugins.ylemontag.sequencecomparator;

import plugins.ylemontag.sequencecomparator.comparators.LocalAbsDiff;
import plugins.ylemontag.sequencecomparator.comparators.LocalDifference;
import plugins.ylemontag.sequencecomparator.comparators.LocalSSIM;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * List of available global comparators
 */
public enum LocalComparatorFactory implements ComparatorFactory<LocalComparator>
{
	DIFFERENCE("Difference"),
	ABS_DIFF  ("Abs. diff."),
	SSIM      ("SSIM"      );
	
	private String _name;
	
	/**
	 * Constructor
	 */
	private LocalComparatorFactory(String name)
	{
		_name = name;
	}
	
	@Override
	public String getDistanceName()
	{
		return _name;
	}
	
	@Override
	public String toString()
	{
		return _name;
	}

	@Override
	public LocalComparator createInstance(ParameterProvider provider)
	{
		switch(this) {
			case DIFFERENCE: return new LocalDifference(_name);
			case ABS_DIFF  : return new LocalAbsDiff   (_name);
			case SSIM      : return new LocalSSIM      (_name, provider.getSSIMCalculator());
		}
		throw new RuntimeException("Unreachable code point");
	}
}
