package plugins.tprovoost.contextualpainter;

import icy.gui.main.GlobalSequenceListener;
import icy.main.Icy;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginDaemon;
import icy.sequence.Sequence;

public class ContextualPainterMode extends Plugin implements PluginDaemon, GlobalSequenceListener
{
    static ContextualPainter overlay = null;

    @Override
    public void run()
    {
        // nothing to do here
    }

    @Override
    public void init()
    {
        if (overlay == null)
        {
            overlay = new ContextualPainter();

            for (Sequence sequence : Icy.getMainInterface().getSequences())
                if (!sequence.contains(overlay))
                    sequence.addOverlay(overlay);

            Icy.getMainInterface().addGlobalSequenceListener(this);
        }
    }

    @Override
    public void stop()
    {
        if (overlay != null)
        {
            Icy.getMainInterface().removeGlobalSequenceListener(this);

            for (Sequence sequence : Icy.getMainInterface().getSequences())
                sequence.removeOverlay(overlay);

            overlay = null;
        }
    }

    @Override
    public void sequenceOpened(Sequence sequence)
    {
        if (sequence == null)
            return;

        if (!sequence.contains(overlay))
            sequence.addOverlay(overlay);
    }

    @Override
    public void sequenceClosed(Sequence sequence)
    {
        if (sequence == null)
            return;

        sequence.removeOverlay(overlay);
    }
}
