package plugins.adufour.sequenceutil;

import icy.sequence.Sequence;
import icy.system.IcyHandledException;

import java.util.ArrayList;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.VarSequence;

public class SequenceCropper extends EzPlug implements Block, BlockInfo
{
    EzVarSequence input  = new EzVarSequence("Input");
    
    EzVarInteger  minX   = new EzVarInteger("X min", 0, Short.MAX_VALUE, 1);
    EzVarInteger  maxX   = new EzVarInteger("X max", 0, Short.MAX_VALUE, 1);
    
    EzVarInteger  minY   = new EzVarInteger("Y min", 0, Short.MAX_VALUE, 1);
    EzVarInteger  maxY   = new EzVarInteger("Y max", 0, Short.MAX_VALUE, 1);
    
    EzVarInteger  minZ   = new EzVarInteger("Z min", 0, Short.MAX_VALUE, 1);
    EzVarInteger  maxZ   = new EzVarInteger("Z max", 0, Short.MAX_VALUE, 1);
    
    EzVarInteger  minC   = new EzVarInteger("C min", 0, Short.MAX_VALUE, 1);
    EzVarInteger  maxC   = new EzVarInteger("C max", 0, Short.MAX_VALUE, 1);
    
    EzVarInteger  minT   = new EzVarInteger("T min", 0, Short.MAX_VALUE, 1);
    EzVarInteger  maxT   = new EzVarInteger("T max", 0, Short.MAX_VALUE, 1);
    
    VarSequence   output = new VarSequence("Ouput", null);
    
    @Override
    protected void initialize()
    {
        input.addVarChangeListener(new EzVarListener<Sequence>()
        {
            @Override
            public void variableChanged(EzVar<Sequence> source, Sequence newValue)
            {
                boolean enabled = newValue != null;
                minX.setVisible(enabled);
                maxX.setVisible(enabled);
                minY.setVisible(enabled);
                maxY.setVisible(enabled);
                minZ.setVisible(enabled && newValue.getSizeZ() > 1);
                maxZ.setVisible(enabled && newValue.getSizeZ() > 1);
                minC.setVisible(enabled && newValue.getSizeC() > 1);
                maxC.setVisible(enabled && newValue.getSizeC() > 1);
                minT.setVisible(enabled && newValue.getSizeT() > 1);
                maxT.setVisible(enabled && newValue.getSizeT() > 1);
                
                if (enabled)
                {
                    minX.setMaxValue(newValue.getSizeX() - 1);
                    minY.setMaxValue(newValue.getSizeY() - 1);
                    minZ.setMaxValue(newValue.getSizeZ() - 1);
                    minC.setMaxValue(newValue.getSizeC() - 1);
                    minT.setMaxValue(newValue.getSizeT() - 1);
                    maxX.setMaxValue(newValue.getSizeX() - 1);
                    maxX.setValue(newValue.getSizeX() - 1);
                    maxY.setMaxValue(newValue.getSizeY() - 1);
                    maxY.setValue(newValue.getSizeY() - 1);
                    maxZ.setMaxValue(newValue.getSizeZ() - 1);
                    maxZ.setValue(newValue.getSizeZ() - 1);
                    maxC.setMaxValue(newValue.getSizeC() - 1);
                    maxC.setValue(newValue.getSizeC() - 1);
                    maxT.setMaxValue(newValue.getSizeT() - 1);
                    maxT.setValue(newValue.getSizeT() - 1);
                }
            }
        });
        
        addEzComponent(input);
        addEzComponent(minX);
        addEzComponent(maxX);
        addEzComponent(minY);
        addEzComponent(maxY);
        addEzComponent(minZ);
        addEzComponent(maxZ);
        addEzComponent(minC);
        addEzComponent(maxC);
        addEzComponent(minT);
        addEzComponent(maxT);
    }
    
    @Override
    protected void execute()
    {
        try
        {
            output.setValue(extract(input.getValue(true), minX.getValue(), maxX.getValue(), minY.getValue(), maxY.getValue(), minZ.getValue(), maxZ.getValue(), minC.getValue(), maxC.getValue(),
                    minT.getValue(), maxT.getValue()));
            
            if (!isHeadLess()) addSequence(output.getValue());
        }
        catch (IllegalArgumentException e)
        {
            throw new IcyHandledException("Invalid parameters: " + e.getMessage());
        }
    }
    
    @Override
    public void clean()
    {
        
    }
    
    /**
     * Extract the specified portion of a sequence
     * 
     * @param sequence
     *            the sequence to cut
     * @param z
     *            the Z section to extract (or -1 for all)
     * @param c
     *            the channel to extract (or -1 for all)
     * @param t
     *            the time point to extract (or -1 for all)
     * @return
     */
    public Sequence extract(Sequence sequence, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int minC, int maxC, int minT, int maxT)
    {
        Sequence cropXYZT = sequence.getSubSequence(minX, minY, minZ, minT, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, maxT - minT + 1);
        
        Sequence output;
        
        int sizeC = maxC - minC + 1;
        
        if (sizeC == cropXYZT.getSizeC())
        {
            output = cropXYZT;
        }
        else
        {
            ArrayList<Integer> channels = new ArrayList<Integer>(sizeC);
            for (int c = minC; c <= maxC; c++)
                channels.add(c);
            output = cropXYZT.extractChannels(channels);
        }
        
        output.setPixelSizeX(sequence.getPixelSizeX());
        output.setPixelSizeY(sequence.getPixelSizeY());
        output.setPixelSizeZ(sequence.getPixelSizeZ());
        
        return output;
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add(input.getVariable());
        inputMap.add(minX.getVariable());
        inputMap.add(maxX.getVariable());
        inputMap.add(minY.getVariable());
        inputMap.add(maxY.getVariable());
        inputMap.add(minZ.getVariable());
        inputMap.add(maxZ.getVariable());
        inputMap.add(minC.getVariable());
        inputMap.add(maxC.getVariable());
        inputMap.add(minT.getVariable());
        inputMap.add(maxT.getVariable());
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add(output);
    }
    
    @Override
    public String getDescription()
    {
        return "Crop a given portion of a sequence in all 5 dimensions (XYZCT)";
    }
}
