/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.compactionProfiler;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.lagache.compactionProfiler.Point;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class CompactionProfiler
extends EzPlug
implements Block {
    EzVarDouble alpha = new EzVarDouble("Percentage P of signal (intensity or surface)", 0.0, 1.0, 0.01);
    EzVarSwimmingObject<DetectionResult> detections = new EzVarSwimmingObject("Detections");
    private EzVarDouble output = new EzVarDouble("Proportion of ROIs surface covered by P% of signal", new Double[]{0.0}, false);
    private EzVarSequence sequence = new EzVarSequence("input Sequence");
    EzVarEnum<MethodType> criterion = new EzVarEnum("Signal type:", (Enum[])MethodType.values());
    protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel", false);
    protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");
    private EzVarBoolean show = new EzVarBoolean("Show signal surface", false);

    protected void initialize() {
        super.addEzComponent((EzComponent)this.alpha);
        super.addEzComponent((EzComponent)this.sequence);
        super.addEzComponent(this.detections);
        super.addEzComponent((EzComponent)this.output);
        super.addEzComponent(this.criterion);
        super.addEzComponent((EzComponent)this.show);
        this.addEzComponent((EzComponent)new EzGroup("Export", new EzComponent[]{this.exportExcel, this.exportExcelFile}));
        this.exportExcel.addVisibilityTriggerTo((EzComponent)this.exportExcelFile, (Object[])new Boolean[]{true});
        this.getUI().setParametersIOVisible(false);
        this.criterion.addVarChangeListener((EzVarListener)new EzVarListener<MethodType>(){

            public void variableChanged(EzVar<MethodType> source, MethodType newValue) {
                CompactionProfiler.this.updateDefaultParams();
            }
        });
    }

    private void updateDefaultParams() {
        MethodType _method = (MethodType)((Object)this.criterion.getValue());
        switch (_method) {
            case Intensity: {
                break;
            }
            case Surface: {
                break;
            }
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.alpha.getVariable());
        inputMap.add(this.detections.getVariable());
        inputMap.add(this.sequence.getVariable());
        inputMap.add(this.criterion.getVariable());
        inputMap.add(this.exportExcel.getVariable());
        inputMap.add(this.show.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.output.getVariable());
    }

    protected void execute() {
        double threshold = 0.0;
        if (this.alpha.getValue() == null) {
            new AnnounceFrame("Please first select percentage P of signal");
            return;
        }
        threshold = (Double)this.alpha.getValue();
        MethodType _method = (MethodType)((Object)this.criterion.getValue());
        if (this.detections.getValue() == null) {
            new AnnounceFrame("Please first select a detection set");
            return;
        }
        if (this.sequence.getValue() == null) {
            new AnnounceFrame("Please first select a sequence");
            return;
        }
        DetectionResult temp = (DetectionResult)((SwimmingObject)this.detections.getValue()).getObject();
        Vector detection = temp.getDetectionsAtT(0);
        if (detection.size() == 0) {
            new AnnounceFrame("There is no detections associated with the ROI");
            return;
        }
        this.performAnalysis(this.detections, _method, this.exportExcel, this.show, threshold, this.sequence, this.output);
    }

    private void performAnalysis(EzVarSwimmingObject<DetectionResult> detections, MethodType method, EzVarBoolean exportExcel, EzVarBoolean show, double threshold, EzVarSequence sequence, EzVarDouble output) {
        int row = 0;
        XlsManager xls = null;
        if (((Boolean)exportExcel.getValue()).booleanValue()) {
            int page = 1;
            try {
                File f = (File)this.exportExcelFile.getValue(true);
                if (!FileUtil.getFileExtension((String)f.getPath(), (boolean)false).equalsIgnoreCase("xls")) {
                    f = new File(String.valueOf(f.getPath()) + ".xls");
                }
                xls = new XlsManager(f);
                xls.createNewPage("Page " + page);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            xls.setLabel(0, 0, "Date of XLS page:");
            xls.setLabel(0, ++row, new Date().toString());
            xls.setLabel(0, ++row, "Type of signal");
            ++row;
            switch (method) {
                case Intensity: {
                    xls.setLabel(0, row, "Intensity");
                    break;
                }
                case Surface: {
                    xls.setLabel(0, row, "Surface");
                }
            }
            xls.setLabel(0, ++row, "Percentage P of signal");
            xls.setNumber(0, ++row, threshold);
            ++row;
            xls.setLabel(0, ++row, "ROI number");
            xls.setLabel(1, row, "ROI name");
            xls.setLabel(2, row, "ROI surface");
            xls.setLabel(3, row, "ROI nb detection");
            xls.setLabel(4, row, "Mean size of ROI spots");
            xls.setLabel(5, row, "Percentage of the ROI surface occupied by x% of the signal");
            ++row;
        }
        ArrayList roiArrayList = ((Sequence)sequence.getValue()).getROI2Ds();
        DetectionResult detect_ = (DetectionResult)((SwimmingObject)detections.getValue()).getObject();
        Vector detection = detect_.getDetectionsAtT(0);
        Vector cloneDetectionList = (Vector)detection.clone();
        for (ROI2D roi : roiArrayList) {
            if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() != 0) continue;
            for (Spot spot : cloneDetectionList) {
                if (!roi.contains(spot.mass_center.x, spot.mass_center.y)) continue;
                detection.remove(spot);
            }
        }
        HashMap ROI2Detection = new HashMap();
        if (roiArrayList.size() == 0) {
            ROI2Detection.put(new ROI2DRectangle((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(((Sequence)sequence.getValue()).getWidth(), ((Sequence)sequence.getValue()).getHeight()), false), (Vector)detection.clone());
        } else {
            for (ROI2D roi : roiArrayList) {
                ROI2Detection.put(roi, new Vector());
            }
            for (ROI2D roi : roiArrayList) {
                for (Spot spot : detection) {
                    if (!roi.contains(spot.mass_center.x, spot.mass_center.y)) continue;
                    ((Vector)ROI2Detection.get(roi)).add(spot);
                }
            }
        }
        detection.clear();
        for (ROI2D roi : ROI2Detection.keySet()) {
            for (Spot s : (Vector)ROI2Detection.get(roi)) {
                detection.add(s);
            }
        }
        if (detection.size() == 0) {
            new AnnounceFrame("There is no detection associated with the ROI(s)");
            return;
        }
        int nb = 0;
        double surface_cellule_totale = 0.0;
        double surface_signal_totale = 0.0;
        for (ROI2D roi : ROI2Detection.keySet()) {
            double surf;
            ROI2DPolygon r;
            Point2D.Double l;
            List<Point> result;
            Vector detect = (Vector)ROI2Detection.get(roi);
            Vector<Spot> select = new Vector<Spot>();
            Vector remain = (Vector)detect.clone();
            double sum = 0.0;
            ArrayList<Point> mass_c = new ArrayList<Point>();
            Spot S0 = (Spot)remain.get(0);
            double y = 0.0;
            switch (method) {
                case Surface: {
                    y = S0.point3DList.size();
                    break;
                }
                case Intensity: {
                    y = (double)S0.point3DList.size() * S0.meanIntensity;
                }
            }
            int index = 0;
            double Y = 0.0;
            for (Spot S : remain) {
                switch (method) {
                    case Surface: {
                        if (!((double)S.point3DList.size() > y)) break;
                        y = S.point3DList.size();
                        index = remain.indexOf(S);
                        break;
                    }
                    case Intensity: {
                        if (!((double)S.point3DList.size() * S.meanIntensity > y)) break;
                        y = (double)S.point3DList.size() * S.meanIntensity;
                        index = remain.indexOf(S);
                    }
                }
            }
            Spot spot = (Spot)remain.get(index);
            select.add(spot);
            remain.remove(index);
            Point point = new Point((int)spot.mass_center.x, (int)spot.mass_center.y);
            mass_c.add(point);
            sum = y;
            S0 = (Spot)remain.get(0);
            switch (method) {
                case Surface: {
                    y = S0.point3DList.size();
                    break;
                }
                case Intensity: {
                    y = (double)S0.point3DList.size() * S0.meanIntensity;
                }
            }
            index = 0;
            for (Spot S : remain) {
                switch (method) {
                    case Surface: {
                        if (!((double)S.point3DList.size() > y)) break;
                        y = S.point3DList.size();
                        index = remain.indexOf(S);
                        break;
                    }
                    case Intensity: {
                        if (!((double)S.point3DList.size() * S.meanIntensity > y)) break;
                        y = (double)S.point3DList.size() * S.meanIntensity;
                        index = remain.indexOf(S);
                    }
                }
            }
            spot = (Spot)remain.get(index);
            select.add(spot);
            remain.remove(index);
            point = new Point((int)spot.mass_center.x, (int)spot.mass_center.y);
            mass_c.add(point);
            sum += y;
            double surface = 0.0;
            switch (method) {
                case Surface: {
                    Y = this.getROINumber(roi, detect);
                    break;
                }
                case Intensity: {
                    Y = this.getROIIntensity(roi, detect);
                }
            }
            double surf_totale = this.getROISurface(roi);
            while (sum < threshold * Y) {
                S0 = (Spot)remain.get(0);
                point = new Point((int)S0.mass_center.x, (int)S0.mass_center.y);
                mass_c.add(point);
                Collections.sort(mass_c);
                result = Point.GrahamConvexHull(mass_c);
                l = new Point2D.Double((double)result.get(0).getX() + 0.5, (double)result.get(0).getY() + 0.5);
                r = new ROI2DPolygon((Point2D)l);
                result.remove(0);
                for (Point p : result) {
                    l = new Point2D.Double((double)p.getX() + 0.5, (double)p.getY() + 0.5);
                    r.addPoint((Point2D)l, true);
                }
                surf = this.getROISurface((ROI2D)r);
                double gain_surface = surf - surface;
                switch (method) {
                    case Surface: {
                        y = this.getROINumber((ROI2D)r, detect);
                        break;
                    }
                    case Intensity: {
                        y = this.getROIIntensity((ROI2D)r, detect);
                    }
                }
                double gain_y = y - sum;
                double delta_gain = 0.0;
                if (gain_surface > 0.0) {
                    delta_gain = gain_y / gain_surface;
                }
                double temp_y = gain_y;
                double temp_s = gain_surface;
                mass_c.remove(point);
                index = 0;
                for (Spot S : remain) {
                    point = new Point((int)S.mass_center.x, (int)S.mass_center.y);
                    mass_c.add(point);
                    Collections.sort(mass_c);
                    result = Point.GrahamConvexHull(mass_c);
                    l = new Point2D.Double((double)result.get(0).getX() + 0.5, (double)result.get(0).getY() + 0.5);
                    r = new ROI2DPolygon((Point2D)l);
                    result.remove(0);
                    for (Point p : result) {
                        l = new Point2D.Double((double)p.getX() + 0.5, (double)p.getY() + 0.5);
                        r.addPoint((Point2D)l, true);
                    }
                    surf = this.getROISurface((ROI2D)r);
                    switch (method) {
                        case Surface: {
                            y = this.getROINumber((ROI2D)r, detect);
                            break;
                        }
                        case Intensity: {
                            y = this.getROIIntensity((ROI2D)r, detect);
                        }
                    }
                    gain_surface = surf - surface;
                    gain_y = y - sum;
                    if (gain_y / gain_surface > delta_gain) {
                        delta_gain = gain_y / gain_surface;
                        temp_y = gain_y;
                        temp_s = gain_surface;
                        index = remain.lastIndexOf(S);
                    }
                    mass_c.remove(point);
                }
                spot = (Spot)remain.get(index);
                select.add(spot);
                remain.remove(index);
                point = new Point((int)spot.mass_center.x, (int)spot.mass_center.y);
                mass_c.add(point);
                sum += temp_y;
                surface += temp_s;
            }
            Collections.sort(mass_c);
            result = Point.GrahamConvexHull(mass_c);
            l = new Point2D.Double((double)result.get(0).getX() + 0.5, (double)result.get(0).getY() + 0.5);
            r = new ROI2DPolygon((Point2D)l);
            result.remove(0);
            for (Point p : result) {
                l = new Point2D.Double((double)p.getX() + 0.5, (double)p.getY() + 0.5);
                r.addPoint((Point2D)l, true);
            }
            surf = this.getROISurface((ROI2D)r);
            Sequence s = this.getFocusedSequence();
            double taille = 0.0;
            for (Spot S : detect) {
                taille += (double)S.point3DList.size();
            }
            taille /= (double)((Vector)ROI2Detection.get(roi)).size();
            if (((Boolean)show.getValue()).booleanValue()) {
                s.addROI((ROI)r);
            }
            if (((Boolean)exportExcel.getValue()).booleanValue()) {
                xls.setNumber(0, row, (double)nb);
                xls.setLabel(1, row, roi.getName());
                xls.setNumber(2, row, this.getROISurface(roi));
                xls.setNumber(3, row, (double)((Vector)ROI2Detection.get(roi)).size());
                xls.setNumber(4, row, taille);
                xls.setNumber(5, row, surf / surf_totale);
                ++row;
            }
            ++nb;
            surface_cellule_totale += surf_totale;
            surface_signal_totale += surf;
        }
        if (((Boolean)exportExcel.getValue()).booleanValue()) {
            ++row;
            xls.setLabel(0, ++row, "Sum of ROIs surfaces");
            xls.setLabel(1, row, "Total surface of the signal");
            xls.setLabel(2, row, "Percentage of the global ROIs surface covered by P% of the signal");
            xls.setNumber(0, ++row, surface_cellule_totale);
            xls.setNumber(1, row, surface_signal_totale);
            xls.setNumber(2, row, surface_signal_totale / surface_cellule_totale);
            xls.SaveAndClose();
        }
        output.setValue((Object)(surface_signal_totale / surface_cellule_totale));
    }

    double getROISurface(ROI2D roi) {
        double sum = 0.0;
        Rectangle bounds = roi.getBounds();
        int y = (int)bounds.getMinY();
        while ((double)y < bounds.getMaxY()) {
            int x = (int)bounds.getMinX();
            while ((double)x < bounds.getMaxX()) {
                if (roi.contains((double)x, (double)y)) {
                    sum += 1.0;
                }
                ++x;
            }
            ++y;
        }
        return sum;
    }

    double getROIIntensity(ROI2D roi, Vector<Spot> detect) {
        BooleanMask2D B = roi.getAsBooleanMask(true);
        double sum = 0.0;
        for (Spot S : detect) {
            boolean trouve = false;
            int i = -2;
            while (i < 3) {
                int j = -2;
                while (j < 3) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += (double)S.point3DList.size() * S.meanIntensity;
                        trouve = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return sum;
    }

    double getROINumber(ROI2D roi, Vector<Spot> detect) {
        BooleanMask2D B = roi.getAsBooleanMask(true);
        double sum = 0.0;
        for (Spot S : detect) {
            boolean trouve = false;
            int i = -2;
            while (i < 3) {
                int j = -2;
                while (j < 3) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += (double)S.point3DList.size();
                        trouve = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return sum;
    }

    public void clean() {
    }

    private static enum MethodType {
        Intensity("Intensity of signal is considered"),
        Surface("Surface of signal is considered");

        private final String name;

        private MethodType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

