package plugins.tboudier.filters3D;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FastFilters3D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarSequence;

public class Filters3D extends EzPlug implements Block {

    private EzVarDouble EZVarRadXY = new EzVarDouble("Radius XY", 2, 0, 100, 0.5);
    private EzVarDouble EZVarRadZ = new EzVarDouble("Radius Z", 2, 0, 100, 0.5);
    private EzVarBoolean EZVarMultithreading = new EzVarBoolean("Multithreading", true);
    private EzVarSequence EZSequence = new EzVarSequence("Image");
    private EzVarSequence EZSequence2 = new EzVarSequence("Image2");
    EzVarEnum<EnumFilters> EZEnum = new EzVarEnum<EnumFilters>("enumeration", EnumFilters.values());

    @Override
    protected void initialize() {
        // TODO Auto-generated by Icy4Eclipse
        super.addEzComponent(EZSequence);
        super.addEzComponent(EZEnum);
        super.addEzComponent(EZVarRadXY);
        super.addEzComponent(EZVarRadZ);
        super.addEzComponent(EZVarMultithreading);
    }

    @Override
    protected void execute() {
        Sequence seq = EZSequence.getValue();

        DataType type = (seq.getDataType_());
        int nbcol = seq.getSizeC();
        int nbframe = seq.getSizeT();
        int nbSlice = seq.getSizeZ();
        int nbPixel = seq.getSizeX() * seq.getSizeY();
        int nbCpus = EZVarMultithreading.getValue() ? 0 : 1;
        ImageHandler img;
        boolean gui = !isHeadLess();

        if (gui) {
            super.getUI().setProgressBarVisible(true);
        }

        for (int c = 0; c < nbcol; c++) {
            Sequence seqOut = new Sequence();
            for (int t = 0; t < nbframe; t++) {
                if (gui) {
                    super.getUI().setProgressBarMessage("Processing " + (t + 1));
                }
                if (gui) {
                    super.getUI().setProgressBarValue((double) (t + 1) / (double) nbframe);
                }
                if (type.compareTo(DataType.USHORT) == 0) {
                    // convert to mcib format short
                    img = new ImageShort(seq.getDataXYZAsShort(t, c), "tmp", seq.getWidth());
                } else if (type.compareTo(DataType.UBYTE) == 0) {
                    // convert to mcib format byte
                    img = new ImageByte(seq.getDataXYZAsByte(t, c), "tmp", seq.getWidth());
                } else if (type.compareTo(DataType.FLOAT) == 0) {
                    // convert to mcib format float
                    img = new ImageFloat(seq.getDataXYZAsFloat(t, c), "tmp", seq.getWidth());
                } else {
                    float[][] arrayImg = new float[nbSlice][nbPixel];
                    // convert to mcib format float
                    System.out.println("basic type " + type + " not supported; converting to float");
                    for (int z = 0; z < nbSlice; z++) {
                        arrayImg[z] = (float[]) (ArrayUtil.arrayToFloatArray(seq.getDataXY(t, z, c), type.isSigned()));
                    }
                    img = new ImageFloat(arrayImg, "tmp", seq.getWidth());
                }
                // filters 3D
                int filt = 0;
                if (EZEnum.getValue() == EnumFilters.MEAN) {
                    filt = FastFilters3D.MEAN;
                } else if (EZEnum.getValue() == EnumFilters.MEDIAN) {
                    filt = FastFilters3D.MEDIAN;
                } else if (EZEnum.getValue() == EnumFilters.MAXIMUM) {
                    filt = FastFilters3D.MAX;
                } else if (EZEnum.getValue() == EnumFilters.MINIMUM) {
                    filt = FastFilters3D.MIN;
                } else if (EZEnum.getValue() == EnumFilters.ADAPTATIVE) {
                    filt = FastFilters3D.ADAPTIVE;
                } else if (EZEnum.getValue() == EnumFilters.MAXLOCAL) {
                    filt = FastFilters3D.MAXLOCAL;
                } else if (EZEnum.getValue() == EnumFilters.TOPHAT) {
                    filt = FastFilters3D.TOPHAT;
                } else if (EZEnum.getValue() == EnumFilters.OPENGRAY) {
                    filt = FastFilters3D.OPENGRAY;
                } else if (EZEnum.getValue() == EnumFilters.CLOSEGRAY) {
                    filt = FastFilters3D.CLOSEGRAY;
                } else if (EZEnum.getValue() == EnumFilters.VARIANCE) {
                    filt = FastFilters3D.VARIANCE;
                }
                ImageHandler res = FastFilters3D.filterImage(img, filt, EZVarRadXY.getValue().floatValue(), EZVarRadXY.getValue().floatValue(), EZVarRadZ.getValue().floatValue(), nbCpus, false);
                VolumetricImage vol = seqOut.addVolumetricImage();
                createVolumeFromImageHandler(res, type, vol);
            }
            seqOut.setName("Filter3D-" + EZEnum.getValue() + "-C" + c);
            seqOut.setPixelSizeX(seq.getPixelSizeX());
            seqOut.setPixelSizeY(seq.getPixelSizeY());
            seqOut.setPixelSizeZ(seq.getPixelSizeZ());
            seqOut.dataChanged();
            if (gui) {
                addSequence(seqOut);
            }
            EZSequence2.setValue(seqOut);
        }
    }

    private void createVolumeFromImageHandler(ImageHandler res, DataType type, VolumetricImage vol) {
        for (int z = 0; z < res.sizeZ; z++) {
            IcyBufferedImage icyimg = null;
            if (type.compareTo(DataType.USHORT) == 0) {
                short[] tabres = (short[]) res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, tabres);
            } else if (type.compareTo(DataType.UBYTE) == 0) {
                byte[] tabres = (byte[]) res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, tabres);
            } else {
                float[] tabres = (float[]) res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, tabres);
            }
            vol.setImage(z, icyimg);
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("RadiusXY", EZVarRadXY.getVariable());
        inputMap.add("RadiusZ", EZVarRadZ.getVariable());
        inputMap.add("Mutithreading", EZVarMultithreading.getVariable());
        inputMap.add("Image", EZSequence.getVariable());
        inputMap.add("Filtre", EZEnum.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add(EZSequence2.getVariable());
    }
}

enum EnumFilters {

    MEAN, MEDIAN, ADAPTATIVE, MAXIMUM, MINIMUM, MAXLOCAL, OPENGRAY, CLOSEGRAY, TOPHAT, VARIANCE
}
