/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.Comparator;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;

public class Coordinate3D {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeXY;
    public int sizeXYZ;
    public int coord;
    public int x;
    public int y;
    public int z;
    public int[][] vois;
    public float[] distances;

    public Coordinate3D(int n, int n2, int n3, int n4) {
        this.coord = n;
        this.sizeX = n2;
        this.sizeY = n3;
        this.sizeXY = n2 * n3;
        this.sizeZ = n4;
        this.sizeXYZ = this.sizeXY * n4;
        this.computeXYZ();
    }

    public void setCoord(int n) {
        this.coord = n;
        this.computeXYZ();
    }

    public void setCoord(int n, int n2, int n3, int n4) {
        this.coord = n;
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public void setCoord(int n, int n2, int n3) {
        this.coord = n + n3 * this.sizeXY + n2 * this.sizeX;
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public boolean hasNext() {
        ++this.coord;
        ++this.x;
        if (this.x == this.sizeX) {
            this.x = 0;
            ++this.y;
            if (this.y == this.sizeY) {
                this.y = 0;
                ++this.z;
                if (this.z == this.sizeZ) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isIn() {
        return this.x >= 0 && this.x < this.sizeX && this.y >= 0 && this.y < this.sizeY && this.z >= 0 && this.z < this.sizeZ;
    }

    public boolean isIn(int n, int n2, int n3) {
        return n >= 0 && n < this.sizeX && n2 >= 0 && n2 < this.sizeY && n3 >= 0 && n3 < this.sizeZ;
    }

    public String print() {
        return " x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public ArrayList<Integer> getVois1() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(6);
        if (this.x > 0) {
            arrayList.add(this.coord - 1);
        }
        if (this.x < this.sizeX - 1) {
            arrayList.add(this.coord + 1);
        }
        if (this.y > 0) {
            arrayList.add(this.coord - this.sizeX);
        }
        if (this.y < this.sizeY - 1) {
            arrayList.add(this.coord + this.sizeX);
        }
        if (this.z > 0) {
            arrayList.add(this.coord - this.sizeXY);
        }
        if (this.z < this.sizeZ - 1) {
            arrayList.add(this.coord + this.sizeXY);
        }
        return arrayList;
    }

    public ArrayList<Voxel3D> getVois1Vox() {
        ArrayList<Voxel3D> arrayList = new ArrayList<Voxel3D>(6);
        if (this.x > 0) {
            arrayList.add(new Voxel3D(this.x - 1, this.y, this.z, 0.0f));
        }
        if (this.x < this.sizeX - 1) {
            arrayList.add(new Voxel3D(this.x + 1, this.y, this.z, 0.0f));
        }
        if (this.y > 0) {
            arrayList.add(new Voxel3D(this.x, this.y - 1, this.z, 0.0f));
        }
        if (this.y < this.sizeY - 1) {
            arrayList.add(new Voxel3D(this.x, this.y + 1, this.z, 0.0f));
        }
        if (this.z > 0) {
            arrayList.add(new Voxel3D(this.x, this.y, this.z - 1, 0.0f));
        }
        if (this.z < this.sizeZ - 1) {
            arrayList.add(new Voxel3D(this.x, this.y, this.z + 1, 0.0f));
        }
        return arrayList;
    }

    public ArrayList<IntCoord3D> getVois1C3D() {
        ArrayList<IntCoord3D> arrayList = new ArrayList<IntCoord3D>(6);
        if (this.x > 0) {
            arrayList.add(new IntCoord3D(this.x - 1, this.y, this.z));
        }
        if (this.x < this.sizeX - 1) {
            arrayList.add(new IntCoord3D(this.x + 1, this.y, this.z));
        }
        if (this.y > 0) {
            arrayList.add(new IntCoord3D(this.x, this.y - 1, this.z));
        }
        if (this.y < this.sizeY - 1) {
            arrayList.add(new IntCoord3D(this.x, this.y + 1, this.z));
        }
        if (this.z > 0) {
            arrayList.add(new IntCoord3D(this.x, this.y, this.z - 1));
        }
        if (this.z < this.sizeZ - 1) {
            arrayList.add(new IntCoord3D(this.x, this.y, this.z + 1));
        }
        return arrayList;
    }

    public ArrayList<Integer> getVois1(ImageHandler imageHandler) {
        if (imageHandler != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(6);
            if (this.x > 0 && imageHandler.getPixel(this.x - 1 + this.y * this.sizeX, this.z) != 0.0f) {
                arrayList.add(this.coord - 1);
            }
            if (this.x < this.sizeX - 1 && imageHandler.getPixel(this.x + 1 + this.y * this.sizeX, this.z) != 0.0f) {
                arrayList.add(this.coord + 1);
            }
            if (this.y > 0 && imageHandler.getPixel(this.x + (this.y - 1) * this.sizeX, this.z) != 0.0f) {
                arrayList.add(this.coord - this.sizeX);
            }
            if (this.y < this.sizeY - 1 && imageHandler.getPixel(this.x + (this.y + 1) * this.sizeX, this.z) != 0.0f) {
                arrayList.add(this.coord + this.sizeX);
            }
            if (this.z > 0 && imageHandler.getPixel(this.x + this.y * this.sizeX, this.z - 1) != 0.0f) {
                arrayList.add(this.coord - this.sizeXY);
            }
            if (this.z < this.sizeZ - 1 && imageHandler.getPixel(this.x + this.y * this.sizeX, this.z + 1) != 0.0f) {
                arrayList.add(this.coord + this.sizeXY);
            }
            return arrayList;
        }
        return this.getVois1();
    }

    public ArrayList<Integer> getVois15(ImageHandler imageHandler) {
        if (imageHandler != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = -1; i <= 1; ++i) {
                if (i + this.z >= this.sizeZ || this.z < -i) continue;
                for (int j = -1; j <= 1; ++j) {
                    if (j + this.y >= this.sizeY || this.y < -j) continue;
                    for (int k = -1; k <= 1; ++k) {
                        if (k + this.x >= this.sizeX || this.x < -k || k == 0 && j == 0 && i == 0 || imageHandler.getPixel(k + this.x + (j + this.y) * this.sizeX, this.z + i) == 0.0f) continue;
                        arrayList.add(this.coord + k + j * this.sizeX + i * this.sizeXY);
                    }
                }
            }
            return arrayList;
        }
        return this.getVois15();
    }

    public ArrayList<Integer> getVois15() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = -1; i <= 1; ++i) {
            if (i + this.z >= this.sizeZ || this.z < -i) continue;
            for (int j = -1; j <= 1; ++j) {
                if (j + this.y >= this.sizeY || this.y < -j) continue;
                for (int k = -1; k <= 1; ++k) {
                    if (k + this.x >= this.sizeX || this.x < -k || k == 0 && j == 0 && i == 0) continue;
                    arrayList.add(this.coord + k + j * this.sizeX + i * this.sizeXY);
                }
            }
        }
        return arrayList;
    }

    public void setVois(float f, float f2) {
        float f3 = f / f2;
        int n = (int)(f + 0.5f);
        int n2 = (int)(f2 + 0.5f);
        int[][] nArray = new int[3][(2 * n + 1) * (2 * n + 1) * (2 * n2 + 1)];
        float[] fArray = new float[nArray[0].length];
        int n3 = 0;
        float f4 = f * f;
        for (int i = -n2; i <= n2; ++i) {
            for (int j = -n; j <= n; ++j) {
                for (int k = -n; k <= n; ++k) {
                    float f5 = (float)i * f3 * (float)i * f3 + (float)(j * j) + (float)(k * k);
                    if (!(f5 <= f4) || k == 0 && j == 0 && i == 0) continue;
                    nArray[0][n3] = k;
                    nArray[1][n3] = j;
                    nArray[2][n3] = i;
                    fArray[n3] = (float)Math.sqrt(f5);
                    ++n3;
                }
            }
        }
        this.distances = new float[n3];
        System.arraycopy(fArray, 0, this.distances, 0, n3);
        this.vois = new int[3][n3];
        System.arraycopy(nArray[0], 0, this.vois[0], 0, n3);
        System.arraycopy(nArray[1], 0, this.vois[1], 0, n3);
        System.arraycopy(nArray[2], 0, this.vois[2], 0, n3);
    }

    public void setVois1(float f) {
        this.vois = new int[3][6];
        this.distances = new float[6];
        this.vois[0][0] = 1;
        this.vois[1][0] = 0;
        this.vois[2][0] = 0;
        this.distances[0] = 1.0f;
        this.vois[0][1] = 0;
        this.vois[1][1] = 1;
        this.vois[2][1] = 0;
        this.distances[1] = 1.0f;
        this.vois[0][2] = -1;
        this.vois[1][2] = 0;
        this.vois[2][2] = 0;
        this.distances[2] = 1.0f;
        this.vois[0][3] = 0;
        this.vois[1][3] = -1;
        this.vois[2][3] = 0;
        this.distances[3] = 1.0f;
        this.vois[0][4] = 0;
        this.vois[1][4] = 0;
        this.vois[2][4] = 1;
        this.distances[4] = f;
        this.vois[0][5] = 0;
        this.vois[1][5] = 0;
        this.vois[2][5] = -1;
        this.distances[5] = f;
    }

    public ArrayList<Integer> getVois(ImageHandler imageHandler) {
        if (imageHandler != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.vois[0].length; ++i) {
                int n = this.vois[0][i] + this.x;
                int n2 = this.vois[1][i] + this.y;
                int n3 = this.vois[2][i] + this.z;
                if (!this.isIn(n, n2, n3) || imageHandler.getPixel(n + n2 * this.sizeX, n3) == 0.0f) continue;
                arrayList.add(n + n2 * this.sizeX + n3 * this.sizeXY);
            }
            return arrayList;
        }
        return this.getVois();
    }

    public ArrayList<Integer> getVois() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.vois[0].length; ++i) {
            int n = this.vois[0][i] + this.x;
            int n2 = this.vois[1][i] + this.y;
            int n3 = this.vois[2][i] + this.z;
            if (!this.isIn(n, n2, n3)) continue;
            arrayList.add(n + n2 * this.sizeX + n3 * this.sizeXY);
        }
        return arrayList;
    }

    private void computeXYZ() {
        this.z = this.coord / this.sizeXY;
        int n = this.coord % this.sizeXY;
        this.y = n / this.sizeX;
        this.x = n % this.sizeX;
    }

    private class ComparatorDistances
    implements Comparator<Integer> {
        private ComparatorDistances() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            if (Coordinate3D.this.distances[n] > Coordinate3D.this.distances[n2]) {
                return 1;
            }
            if (Coordinate3D.this.distances[n] < Coordinate3D.this.distances[n2]) {
                return -1;
            }
            return 0;
        }
    }
}

