package plugins.rouviere.zexplorer;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginThreaded;
import icy.sequence.Sequence;

import java.awt.Point;
import java.awt.Rectangle;

public class ZExplorer extends PluginActionable implements PluginThreaded
{

    int resizeDimension = 64;

    @Override
    public void run()
    {

        Sequence inputSequence = getActiveSequence();
        if (inputSequence == null)
        {
            new AnnounceFrame("You should open a 4D sequence first !", 5);
            return;
        }

        IcyBufferedImage mosaicImage = new IcyBufferedImage(resizeDimension * inputSequence.getSizeT(), resizeDimension
                * inputSequence.getSizeZ(), inputSequence.getSizeC(), inputSequence.getDataType_());
        Sequence mosaicSequence = new Sequence(mosaicImage);

        // make it available directly
        addSequence(mosaicSequence);
        mosaicSequence.addOverlay(new ZExplorerPainter(resizeDimension, inputSequence, mosaicSequence));

        final AnnounceFrame frame = new AnnounceFrame("Creating Mosaic...");
        try
        {
            for (int t = 0; t < inputSequence.getSizeT(); t++)
            {
                mosaicSequence.beginUpdate();
                try
                {
                    for (int z = 0; z < inputSequence.getSizeZ(); z++)
                    {
                        IcyBufferedImage inputImage = inputSequence.getImage(t, z);
                        IcyBufferedImage scaledImage = IcyBufferedImageUtil.scale(inputImage, resizeDimension,
                                resizeDimension);

                        mosaicImage.copyData(scaledImage, new Rectangle(0, 0, resizeDimension, resizeDimension),
                                new Point(t * resizeDimension, z * resizeDimension));
                    }
                }
                finally
                {
                    mosaicSequence.endUpdate();
                }
            }
        }
        finally
        {
            frame.close();
        }

    }

}
