package plugins.ylemontag.sequencecomparator.blocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.sequencecomparator.Comparator;
import plugins.ylemontag.sequencecomparator.ComparatorPair;
import plugins.ylemontag.sequencecomparator.GlobalComparator;
import plugins.ylemontag.sequencecomparator.LocalComparator;
import plugins.ylemontag.sequencecomparator.gui.SequenceComparator;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Compare two sequences
 */
public abstract class AbstractComparisonBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private Var<ComparatorPair> _comparators = new Var<ComparatorPair>("Comparators",
		ComparatorPair.class, null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_comparators);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return SequenceComparator.class.getName();
	}
	
	/**
	 * Execute the comparison
	 */
	protected abstract void executeComparison(GlobalComparator globalComparator, LocalComparator localComparator);

	@Override
	public void run()
	{
		// Comparators
		ComparatorPair comparators = _comparators.getValue();
		if(comparators==null || comparators.global==null || comparators.local==null) {
			throw new VarException("No comparator selected");
		}
		
		// Execute the comparisons
		try {
			executeComparison(comparators.global, comparators.local);
		}
		
		// If one of the comparisons has failed
		catch(Comparator.IncompatibleSizes err) {
			throw new VarException("Comparison failure: " + err.getMessage());
		}
	}
}
