package plugins.fab.challengescoring;

import icy.util.XMLUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Util {


	public static Scenario getScenario( Document document )
	{		
		Element element = getTrackContestISBI2012element( document );
		String scenarioString = XMLUtil.getAttributeValue( element , "scenario", "" ).toLowerCase();		
		
		if ( scenarioString.equals( "vesicle" ) )
		{
			return Scenario.VESICLE;
		}
		
		if ( scenarioString.equals( "microtubule" ) )
		{
			return Scenario.MICROTUBULE;
		}
		
		if ( scenarioString.equals( "receptor" ) )
		{
			return Scenario.RECEPTOR;
		}

		if ( scenarioString.equals( "virus" ) )
		{
			return Scenario.VIRUS;
		}
		
		System.err.println("Scenario not recognized: " + scenarioString );
		
		return null;
	}
	
	public static Density getDensity( Document document )
	{		
		Element element = getTrackContestISBI2012element( document );
		String densityString = XMLUtil.getAttributeValue( element , "density", "" ).toLowerCase();		
		
		if ( densityString.equals( "low" ) )
		{
			return Density.LOW;
		}
		
		if ( densityString.equals( "mid" ) )
		{
			return Density.MID;
		}
		
		if ( densityString.equals( "high" ) )
		{
			return Density.HIGH;
		}
		
		System.err.println("Density not recognized: " + densityString );
		
		return null;
	}
	
	public static int getSNR( Document document )
	{		
		Element element = getTrackContestISBI2012element( document );
		int snr = -1;
		
		snr = XMLUtil.getAttributeIntValue( element , "SNR", -1 );
		
		if ( snr < 0 )
		{
			snr = XMLUtil.getAttributeIntValue( element , "snr", -1 );
		}
				
		return snr;
	}
	
	public static Element getTrackContestISBI2012element( Document document )
	{
		Element element = XMLUtil.getSubElement( XMLUtil.getRootElement( document ) , "TrackContestISBI2012" );
		if ( element == null )
		{
			System.err.println("No tag TrackContestISBI2012 found");
			return null;
		}
		return element;
	}
	
	
	
}
