package plugins.fab.challengescoring;

import icy.file.FileUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RecursiveFileListBuilder {
	
	private ArrayList<File> fileList = new ArrayList<File>();
	
	public ArrayList<File> getFileList() {
		return fileList ;
	}
	
	public RecursiveFileListBuilder( File mainDir , String extension )
	{		
		extension = extension.toLowerCase();
		fileList.clear();		
		scanDir( mainDir , fileList , extension );		
	}

	public void scanDir( File directory , ArrayList<File> mainFileList , String extension )
	{
		List<File> fileFolderList = null;


		fileFolderList = Arrays.asList( directory.listFiles() );		
		if ( fileFolderList == null || fileFolderList.size() == 0 )
		{
			return;
		}

		Collections.sort(fileFolderList);

		for ( File file : fileFolderList )
		{
			if ( file.isDirectory() )
			{								
				scanDir( file , mainFileList , extension );
				continue;
			}

			if( file.isHidden() ) continue;

			if ( !FileUtil.getFileExtension( file.getName(), false ).toLowerCase().contains( extension ) ) continue;			

			mainFileList.add( file );					
		}


	}
	
}
