package plugins.fab.colocalizer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;

import icy.canvas.IcyCanvas;
import icy.painter.Painter;
import icy.sequence.Sequence;

public class ColocalizerPainter implements Painter {

	HashMap < Integer , ArrayList<Line2D> > lineMap = new HashMap< Integer , ArrayList<Line2D> >();
	
	//ArrayList<Line2D> line2DArrayList = new ArrayList<Line2D>();
	
	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if ( g == null ) return; // only display in 2D.
		
		g = (Graphics2D) g.create();
		g.translate( 0.5f , 0.5f );
		
		BasicStroke basicStroke = new BasicStroke((float) canvas.canvasToImageLogDeltaX( 2 ) );
		g.setStroke( basicStroke );

		int t = canvas.getPositionT();
		
		ArrayList<Line2D> line2DArrayList = lineMap.get( t );
		
		if ( line2DArrayList == null ) return;
			
		for ( Line2D line : line2DArrayList )
		{
//			g.setColor( Color.red );
//			g.draw( new Line2D.Double( line.getX1() , line.getY1()-2 , line.getX1() , line.getY1() + 2 ) );
//			g.draw( new Line2D.Double( line.getX1()-2 , line.getY1() , line.getX1()+2 , line.getY1()   ) );
						
			g.setColor( Color.yellow );
			g.draw( line );
		}

	}

	public void addLine( double x1, double y1 , double x2 , double y2 , int t )
	{
		ArrayList<Line2D> line2DArrayList = lineMap.get( t );
		if ( line2DArrayList == null )
		{
			line2DArrayList = new ArrayList<Line2D>();
			lineMap.put( t ,  line2DArrayList );
		}
		line2DArrayList.add( new Line2D.Double( x1, y1, x2, y2 ) );
	}
	
	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {

		
	}

}
