package plugins.ylemontag.noisegenerator.noisemodels;

import cern.jet.random.tdouble.Poisson;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Modelize a Poisson noise.
 */
public class PoissonNoise extends PixelSeparableStationaryNoise
{
	private Poisson _gen;
	
	public PoissonNoise()
	{
		_gen = new Poisson(1.0, DoubleRandomEngine.makeDefault());
	}

	@Override
	protected double generateNoise(double in)
	{
		return in<0 ? Double.NaN : _gen.nextInt(in);
	}

	@Override
	protected String describeNoise(String inName)
	{
		return "Poisson(" + inName + ")";
	}
}
