package plugins.ylemontag.noisegenerator.noisemodelblocks;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.noisegenerator.IllegalNoiseModelArgumentException;
import plugins.ylemontag.noisegenerator.NoiseModel;
import plugins.ylemontag.noisegenerator.NoiseModelBlock;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block that generate a Gaussian noise model
 */
public class GaussianNoiseBlock extends NoiseModelBlock
{
	private VarDouble _sigma = new VarDouble("Sigma", 30.0);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_sigma);
	}
	
	@Override
	protected NoiseModel generateNoiseModel()
	{
		try {
			double sigma = _sigma.getValue(true);
			return NoiseModel.createGaussianNoiseModel(sigma);
		}
		catch(IllegalNoiseModelArgumentException err) {
			throw new VarException(err.getMessage());
		}
	}
}
