/*
 * Decompiled with CFR 0.152.
 */
package kovac.shapes;

import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.type.point.Point3D;
import kovac.res.util.LinkedViewersUtil;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;

public class PointOverlay
extends Overlay
implements VtkPainter {
    private Point3D point;
    private vtkActor pointActor;

    public PointOverlay(String name, Point3D pt) {
        super(name);
        this.point = pt;
        this.init();
    }

    private void init() {
        vtkSphereSource sphere = new vtkSphereSource();
        sphere.SetCenter(this.point.getX(), this.point.getY(), this.point.getZ());
        sphere.SetPhiResolution(18);
        sphere.SetThetaResolution(18);
        sphere.SetRadius(1.0);
        vtkPolyDataMapper map = new vtkPolyDataMapper();
        map.SetInputConnection(sphere.GetOutputPort());
        this.pointActor = new vtkActor();
        this.pointActor.SetMapper((vtkMapper)map);
        this.pointActor.GetProperty().SetColor(0.0, 255.0, 0.0);
        this.pointActor.SetScale(LinkedViewersUtil.getScale());
    }

    public vtkProp[] getProps() {
        return new vtkProp[]{this.pointActor};
    }
}

