/*
 * Decompiled with CFR 0.152.
 */
package kovac.tests;

import Jama.Matrix;
import icy.type.point.Point3D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kovac.maths.EllipsoidAlgorithm;
import kovac.res.util.MathUtils;
import org.apache.commons.lang.ArrayUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAlgoEllipsoid {
    double[][] points;
    double[][] pointsReal;
    double[] expectedCenterOfMass;
    Matrix pointsMat;
    Matrix realMat;
    double[] testSum;
    double[] testAvg;

    @Before
    public void runBeforeEveryTest() {
        this.points = new double[][]{{1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0}, {0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 1.0, 1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0}, {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 1.0, -1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0}};
        this.pointsReal = new double[][]{{0.983, -2.0564, -1.6455, -0.1094, -0.9148, -1.4511, 2.1918, 1.4543, -3.6706, -1.1111}, {0.9389, 4.0447, 5.0776, -0.4229, 3.6163, -1.0237, -4.2298, -2.6732, 3.9565, -2.8577}, {-2.0251, -0.2228, -2.3638, 1.8667, -4.1673, 0.7226, -0.6484, -0.0602, -1.1241, 3.5619}};
        this.pointsMat = new Matrix(this.points);
        this.realMat = new Matrix(this.pointsReal);
        this.testSum = new double[]{1.5, 2.5, 3.5, 4.0, 5.0, 6.3};
        this.testAvg = this.testSum;
        this.expectedCenterOfMass = new double[]{0.0, 0.0, 0.0};
    }

    @After
    public void clear() {
        this.points = null;
    }

    @Test
    public void testSum() {
        Assert.assertEquals((double)22.8, (double)MathUtils.sum(this.testSum), (double)0.0);
    }

    @Test
    public void testAvg() {
        Assert.assertEquals((double)3.8000000000000003, (double)MathUtils.avg(this.testAvg), (double)0.0);
    }

    @Test
    public void testCenterOfMass() {
        Assert.assertArrayEquals((double[])this.expectedCenterOfMass, (double[])MathUtils.getCenterOfMass(this.pointsMat), (double)0.0);
    }

    @Test
    public void testProjsplx() {
        double[] input = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        List<Double> listInput = Arrays.asList(ArrayUtils.toObject((double[])input));
        double[] expected = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        List<Double> res = EllipsoidAlgorithm.projsplx(listInput);
        if (res.size() != expected.length) {
            Assert.fail((String)"Wrong length");
        }
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((double)expected[i], (double)res.get(i), (double)0.0);
            ++i;
        }
    }

    @Test
    public void testGetK() {
        double[][] expectedK = new double[][]{{10.0, 8.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0}, {8.0, 10.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0}, {8.0, 8.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0}, {0.0, 0.0, 0.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0}, {10.0, 10.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0}};
        int i = 0;
        while (i < 10) {
            Assert.assertArrayEquals((double[])expectedK[i], (double[])EllipsoidAlgorithm.getK(this.pointsMat).getArray()[i], (double)0.0);
            ++i;
        }
    }

    @Test
    public void testCalculateM() {
        double[][] expectedM = new double[][]{{1.1, 0.08, 0.08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1}, {0.08, 1.1, 0.08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1}, {0.08, 0.08, 1.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1}, {0.0, 0.0, 0.0, 1.08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.08, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.08, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.1, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.1, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.1, 0.0}, {0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14}};
        int i = 0;
        while (i < 10) {
            Assert.assertArrayEquals((double[])expectedM[i], (double[])EllipsoidAlgorithm.getM(EllipsoidAlgorithm.getK(this.pointsMat)).getArray()[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testProxf2() {
        Matrix u = EllipsoidAlgorithm.getQ0(this.pointsMat);
        int i = 0;
        while (i < u.getRowDimension()) {
            Assert.assertArrayEquals((double[])u.getArray()[i], (double[])EllipsoidAlgorithm.proxf2(u).getArray()[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testProxf1() {
        double[][] expectedProxf1 = new double[][]{{0.3249}, {0.3249}, {0.3249}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {-0.7603}};
        int i = 0;
        while (i < expectedProxf1.length) {
            Assert.assertArrayEquals((double[])expectedProxf1[i], (double[])EllipsoidAlgorithm.proxf1(EllipsoidAlgorithm.getM(EllipsoidAlgorithm.getK(this.pointsMat)), EllipsoidAlgorithm.getQ0(this.pointsMat)).getArray()[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testDiagSquare() {
        double[][] expectedDiag = new double[][]{{1.0, 5.0, 9.0}};
        double[][] baseArray = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}};
        Matrix baseMat = new Matrix((double[][])baseArray);
        Assert.assertArrayEquals((double[])expectedDiag[0], (double[])EllipsoidAlgorithm.diag(baseMat).transpose().getArray()[0], (double)1.0E-4);
    }

    @Test
    public void testDiagColumnVector() {
        double[][] baseArray = new double[][]{{1.0}, {5.0}, {9.0}};
        Matrix baseMat = new Matrix((double[][])baseArray);
        double[][] expectedArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 5.0, 0.0}, {0.0, 0.0, 9.0}};
        int i = 0;
        while (i < 3) {
            Assert.assertArrayEquals((double[])expectedArray[i], (double[])EllipsoidAlgorithm.diag(baseMat).getArray()[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testGetQ0() {
        double[][] expectedResult = new double[][]{{0.3333}, {0.3333}, {0.3333}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {-0.7692}};
        int i = 0;
        while (i < 10) {
            Assert.assertArrayEquals((double[])expectedResult[i], (double[])EllipsoidAlgorithm.getQ0(this.pointsMat).getArray()[i], (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void testVariance() {
        double[] expectedVar = new double[]{0.7692, 0.7692, 0.7692};
        double[] results = new double[]{MathUtils.getVariance(this.points[0]), MathUtils.getVariance(this.points[1]), MathUtils.getVariance(this.points[2])};
        Assert.assertArrayEquals((double[])expectedVar, (double[])results, (double)1.0E-4);
    }

    @Test
    public void testSumSquare() {
        double expectedResult = 322.9;
        double[] input = new double[]{3.3, 17.5, 2.4};
        Assert.assertEquals((double)expectedResult, (double)MathUtils.sumSquare(input), (double)0.0);
    }

    @Test
    public void testFinal() {
        ArrayList<Point3D> basePoints = new ArrayList<Point3D>();
        int j = 0;
        while (j < this.pointsReal[0].length) {
            basePoints.add((Point3D)new Point3D.Double(this.pointsReal[0][j], this.pointsReal[1][j], this.pointsReal[2][j]));
            ++j;
        }
        EllipsoidAlgorithm algo = new EllipsoidAlgorithm(basePoints);
        double[][] expectedResult = new double[][]{{0.6198}, {0.2149}, {0.1654}, {0.5952}, {0.4044}, {0.2441}, {1.1095}, {0.5197}, {0.5173}, {-1.1745}};
        double[][] realResult = algo.getFinalQuadric().getCoefficients().getArray();
        int i = 0;
        while (i < expectedResult.length) {
            Assert.assertArrayEquals((double[])expectedResult[i], (double[])realResult[i], (double)1.0E-4);
            ++i;
        }
    }
}

