package plugins.ylemontag.sequencecomparator.gui;

import icy.sequence.Sequence;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import plugins.ylemontag.sequencecomparator.ComparisonState;
import plugins.ylemontag.sequencecomparator.LocalComparisonPool;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Component for error map LUT synchronization
 */
public class ErrorMapChooserComponent extends JButton
{
	private static final long serialVersionUID = 1L;
	
	/**
	 * Listener to implement to watch at events forwarded by this component
	 */
	public interface ErrorMapLUTListener
	{	
		/**
		 * Triggered method
		 * @param seq Targeted sequence
		 */
		public void eventTriggered(Sequence seq);
	}
	
	private LocalComparisonPool _localComparisonPool;
	private JPopupMenu _popupMenu;
	private LinkedList<ErrorMapLUTListener> _listeners;
	
	/**
	 * Constructor
	 */
	public ErrorMapChooserComponent(LocalComparisonPool localComparisonPool)
	{
		super("Sync. error map LUTs");
		_localComparisonPool = localComparisonPool;
		_listeners = new LinkedList<ErrorMapLUTListener>();
		_popupMenu = new JPopupMenu();
		addActionListener(new ActionListener()
		{	
			@Override
			public void actionPerformed(ActionEvent e) {
				showPopup();
			}
		});
	}
	
	/**
	 * Add a new listener
	 */
	public void addErrorMapLUTListener(ErrorMapLUTListener l)
	{
		_listeners.add(l);
	}
	
	/**
	 * Display the popup menu
	 */
	private void showPopup()
	{
		_popupMenu.removeAll();
		for(final Sequence seq : _localComparisonPool.getComparedSequences()) {
			if(_localComparisonPool.getState(seq)!=ComparisonState.READY) {
				continue;
			}
			JMenuItem menuItem = new JMenuItem(seq.getName());
			menuItem.addActionListener(new ActionListener()
			{	
				@Override
				public void actionPerformed(ActionEvent e) {
					fireClickOnMenuItem(seq);
				}
			});
			_popupMenu.add(menuItem);
		}
		_popupMenu.show(this, 0, getHeight());
	}
	
	/**
	 * Respond to a click on a menu item
	 */
	private void fireClickOnMenuItem(Sequence seq)
	{
		for(ErrorMapLUTListener l : _listeners) {
			l.eventTriggered(seq);
		}
	}
}
