package plugins.fab.colocalizer;

import icy.main.Icy;
import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;

import java.util.ArrayList;
import java.util.HashMap;

import javax.vecmath.Point3i;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class Colocalizer extends Plugin implements Block {

	protected VarGenericArray<ConnectedComponent[]> inputConnectedComponentsA = 
			new VarGenericArray<ConnectedComponent[]>("components set A", ConnectedComponent[].class, null);

	protected VarGenericArray<ConnectedComponent[]> inputConnectedComponentsB = 
			new VarGenericArray<ConnectedComponent[]>("components set B", ConnectedComponent[].class, null);

//	protected VarGenericArray<ConnectedComponent[]> outputColocalizedConnectedComponents = 
//			new VarGenericArray<ConnectedComponent[]>("Colocalized components", ConnectedComponent[].class, null);
//
//	protected VarGenericArray<ConnectedComponent[]> outputNotColocalizedConnectedComponents = 
//			new VarGenericArray<ConnectedComponent[]>("Not Colocalized components", ConnectedComponent[].class, null);

	protected VarGenericArray<ConnectedComponent[]> outputColocalizedConnectedComponentsA = 
			new VarGenericArray<ConnectedComponent[]>("Colocalized components A over B (from set A)", ConnectedComponent[].class, null);

	protected VarGenericArray<ConnectedComponent[]> outputNotColocalizedConnectedComponentsA = 
			new VarGenericArray<ConnectedComponent[]>("Not Colocalized components (from set A)", ConnectedComponent[].class, null);
	
	protected VarGenericArray<ConnectedComponent[]> outputColocalizedConnectedComponentsB = 
			new VarGenericArray<ConnectedComponent[]>("Colocalized components A over B (from set B)", ConnectedComponent[].class, null);

	protected VarGenericArray<ConnectedComponent[]> outputNotColocalizedConnectedComponentsB = 
			new VarGenericArray<ConnectedComponent[]>("Not Colocalized components (from set B)", ConnectedComponent[].class, null);

			
//	VarFile excelFile = new VarFile("Excel Output File", null );
// add ROI feature			
	
	VarSequence inputSequenceVar = new VarSequence("input Sequence", null );
		
	VarDouble colocalizedPercentageAtoB = new VarDouble( "Colocalization % of A over B" , 0 );
			
	VarDouble distanceVar = new VarDouble("Max distance", 4 );
					
	ColocalizerPainter colocalizerPainter ;
	
	ArrayList<DetectionPair> detectionPairArrayList ;
	ArrayList<ConnectedComponent> detectionNotColocalizedPairArrayList_A_over_B_fromSetA ;
	
	
	@Override
	public void run() {
	
		//ArrayList<ConnectedComponent> ccList = new ArrayList<ConnectedComponent>();
		detectionPairArrayList = new ArrayList<DetectionPair>();
		detectionNotColocalizedPairArrayList_A_over_B_fromSetA = new ArrayList<ConnectedComponent>();
		
		double distance = distanceVar.getValue();
		ConnectedComponent[] connA = inputConnectedComponentsA.getValue();
		ConnectedComponent[] connB = inputConnectedComponentsB.getValue();

		// create a map to sort all components by t.
		
		HashMap<Integer , ArrayList<ConnectedComponent> > connectedHashMapA = new HashMap< Integer, ArrayList<ConnectedComponent>>();
		HashMap<Integer , ArrayList<ConnectedComponent> > connectedHashMapB = new HashMap< Integer, ArrayList<ConnectedComponent>>();

		int maxT = 0;
		for ( ConnectedComponent connAA : connA )
		{
			int t = connAA.getT();
			if ( t > maxT ) maxT = t;
			
			ArrayList<ConnectedComponent> ccList = connectedHashMapA.get( t );
			if ( ccList == null )
			{
				ccList = new ArrayList<ConnectedComponent>();
				connectedHashMapA.put( t , ccList );
			}
			ccList.add( connAA );
		}

		for ( ConnectedComponent connBB : connB )
		{
			int t = connBB.getT();
			if ( t > maxT ) maxT = t;
			
			ArrayList<ConnectedComponent> ccList = connectedHashMapB.get( t );
			if ( ccList == null )
			{
				ccList = new ArrayList<ConnectedComponent>();
				connectedHashMapB.put( t , ccList );
			}
			ccList.add( connBB );
		}

		
		// --- sort ended

		for ( int t = 0 ; t <= maxT  ; t++ )
		{
						
			ArrayList<ConnectedComponent> setA = connectedHashMapA.get( t );
			ArrayList<ConnectedComponent> setB = connectedHashMapB.get( t );
			
			if ( setA == null || setB== null ) continue;
			
			System.out.println("Colocalizing timepoint # "+ t +" ..." );
			System.out.println("set A: nb detections : " + setA.size() );
			System.out.println("set B: nb detections : " + setB.size() );
			
			int nbColoc = 0;
			
			for ( ConnectedComponent connAA : setA )
			{
				for ( ConnectedComponent connBB : setB )
				{					
					
					if ( connAA.getMassCenter().distance( connBB.getMassCenter() ) <= distance )
					{
						nbColoc++;
						detectionPairArrayList.add( new DetectionPair ( connAA , connBB ) );
						break;
					}
				}
				// store not colocalized detection.
				detectionNotColocalizedPairArrayList_A_over_B_fromSetA.add( connAA );
			}
						
			float percent = 100f * nbColoc / (float)setA.size();
			System.out.println("number of detection of set A colocalized with set B: " + nbColoc + " / " + setA.size() + " (" + percent +"%)");
		}
		
		// build set B not colocalized
	
		ArrayList<ConnectedComponent> setBnotColocalized = new ArrayList<ConnectedComponent>();
		ArrayList<ConnectedComponent> setBColocalized = new ArrayList<ConnectedComponent>();
		
		for ( int t = 0 ; t <= maxT  ; t++ )
		{
			ArrayList<ConnectedComponent> setB = connectedHashMapB.get( t );
			if (setB!=null)
			for ( ConnectedComponent connBB : setB )
			{
				for ( DetectionPair pair : detectionPairArrayList )
				{
					if ( pair.CCb == connBB )
					{
						setBColocalized.add( connBB );
						break;
					}
				}
				
				setBnotColocalized.add( connBB );
				
			}
		}
		

		
		// build outputArray
				
		//ConnectedComponent[] ccOut = new ConnectedComponent[ccList.size()];
		ConnectedComponent[] ccOut = new ConnectedComponent[detectionPairArrayList.size()];
//		outputNotColocalizedConnectedComponents
		{
			int i = 0;
			//for ( ConnectedComponent cc : ccList )
			for ( DetectionPair detectionPair : detectionPairArrayList )			
			{
				ccOut[i] = detectionPair.CCa;
				i++;
			}
		}
		
		outputColocalizedConnectedComponentsA.setValue( ccOut );		
		

		// build not colocalized output
		{
			ConnectedComponent[] ccOutNotColocalized = new ConnectedComponent[detectionNotColocalizedPairArrayList_A_over_B_fromSetA.size()];
			//detectionNotColocalizedPairArrayList.add( connAA );
			int i = 0;
			for ( ConnectedComponent cc : detectionNotColocalizedPairArrayList_A_over_B_fromSetA )			
			{
				ccOutNotColocalized[i] = cc;
				i++;
			}			
			outputNotColocalizedConnectedComponentsA.setValue( ccOutNotColocalized );
		}
		
		// build not colocalized set B output
		{
			ConnectedComponent[] ccOutNotColocalizedFromSetB =
					new ConnectedComponent[setBnotColocalized.size()];
			int i = 0;
			for ( ConnectedComponent cc : setBnotColocalized )			
			{
				ccOutNotColocalizedFromSetB[i] = cc;				
				i++;
			}			
			outputNotColocalizedConnectedComponentsB.setValue( ccOutNotColocalizedFromSetB );
		}
		
		// build colocalized set B output
		{
			ConnectedComponent[] ccOutColocalizedFromSetB = new ConnectedComponent[setBColocalized.size()];
			int i = 0;
			for ( ConnectedComponent cc : setBColocalized )			
			{
				ccOutColocalizedFromSetB[i] = cc;
				i++;
			}			
			outputColocalizedConnectedComponentsB.setValue( ccOutColocalizedFromSetB );
		}
		
		// export detection set to swimming pool
		// This does not export the min /max / mean for each detection.
		{
			DetectionResult detectionResult = new DetectionResult();

			for ( ConnectedComponent cc : ccOut )
			{
				//new DetectionResult(results)

				Spot spot = new Spot( 
						cc.getMassCenter().x , 
						cc.getMassCenter().y ,
						cc.getMassCenter().z ,
						0,
						0,
						0,
						convertToChenouardPoint3D( cc.getPoints() )
						);

				detectionResult.addDetection( cc.getT() ,  spot );

				detectionResult.setSequence( inputSequenceVar.getValue() );


			}
			SwimmingObject swimmingObject = new SwimmingObject( detectionResult , "detections of colocalization" );			
			Icy.getMainInterface().getSwimmingPool().add( swimmingObject );
		}
		
		if ( connB.length !=0 )
		{
			double percentage =  (double)detectionPairArrayList.size() / (double)connA.length *100d ;
			colocalizedPercentageAtoB.setValue( percentage );
			//System.out.println( percentage );
		}
		
		Sequence inputSequence = inputSequenceVar.getValue();
		
		if ( inputSequence != null )
		{
			inputSequence.removePainter( colocalizerPainter );
			
			colocalizerPainter = new ColocalizerPainter();
			
			for ( DetectionPair detectionPair : detectionPairArrayList )			
			{
				colocalizerPainter.addLine( 
						detectionPair.CCa.getMassCenter().x,
						detectionPair.CCa.getMassCenter().y,
						detectionPair.CCb.getMassCenter().x,
						detectionPair.CCb.getMassCenter().y ,
						detectionPair.CCa.getT() );				
			}
			
			inputSequence.addPainter( colocalizerPainter );			
		}
		
		
	}
	
	private ArrayList<plugins.nchenouard.spot.Point3D> convertToChenouardPoint3D(
			Point3i[] point3is ) {

		ArrayList<plugins.nchenouard.spot.Point3D> returnList = new ArrayList<plugins.nchenouard.spot.Point3D>();
		for ( Point3i inputPoint : point3is )
		{
			returnList.add( new plugins.nchenouard.spot.Point3D( inputPoint.x , inputPoint.y , inputPoint.z ) );
		}
		return returnList;
	}
	
	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add( inputConnectedComponentsA );
		inputMap.add( inputConnectedComponentsB );
				
		inputMap.add( distanceVar );		
		inputMap.add( inputSequenceVar );
		
	}

	@Override
	public void declareOutput(VarList outputMap) {

		outputMap.add( "Colocalized components" , outputColocalizedConnectedComponentsA );
		outputMap.add( "Not Colocalized components", outputNotColocalizedConnectedComponentsA );
		outputMap.add( outputColocalizedConnectedComponentsB );
		outputMap.add( outputNotColocalizedConnectedComponentsB );
		outputMap.add( colocalizedPercentageAtoB );

	}
	
	
}
