/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;

public class ImageStats {
    ImageHandler image;
    ImageInt mask;
    private int[] histo256;
    private double max = Double.NaN;
    private double min = Double.NaN;
    private double mean = Double.NaN;
    private double meanSquare = Double.NaN;
    private double sd = Double.NaN;
    private double histo256BinSize = Double.NaN;

    public ImageStats(ImageHandler imageHandler, ImageInt imageInt) {
        this.image = imageHandler;
        this.mask = imageInt;
    }

    public void resetMinAndMax() {
        this.image.getMinAndMax(this.mask);
    }

    public double getMin() {
        if (Double.isNaN(this.min)) {
            this.image.getMinAndMax(this.mask);
        }
        return this.min;
    }

    public double getMax() {
        if (Double.isNaN(this.max)) {
            this.image.getMinAndMax(this.mask);
        }
        return this.max;
    }

    public int[] getHisto256() {
        if (this.histo256 == null) {
            return this.image.getHisto(this.mask);
        }
        return this.histo256;
    }

    protected void setHisto256(int[] nArray, double d) {
        this.histo256 = nArray;
        this.histo256BinSize = d;
    }

    protected boolean minAndMaxSet() {
        return !Double.isNaN(this.min) && !Double.isNaN(this.max);
    }

    public double getHisto256BinSize() {
        if (Double.isNaN(this.histo256BinSize)) {
            if (Double.isNaN(this.max)) {
                this.image.getMinAndMax(this.mask);
            }
            this.histo256BinSize = this.image instanceof ImageByte ? 1.0 : (this.max - this.min) / 256.0;
        }
        return this.histo256BinSize;
    }

    public double getMean() {
        if (Double.isNaN(this.mean)) {
            this.image.getMoments(this.mask);
        }
        return this.mean;
    }

    protected void setMoments(double d, double d2, double d3) {
        this.mean = d;
        this.sd = d3;
        this.meanSquare = d2;
    }

    protected boolean momentsSet() {
        return !Double.isNaN(this.mean) && !Double.isNaN(this.sd) && !Double.isNaN(this.meanSquare);
    }

    protected void setMinAndMax(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public double getStandardDeviation() {
        if (Double.isNaN(this.sd)) {
            this.image.getMoments(this.mask);
        }
        return this.sd;
    }

    public double getRootMeanSquare() {
        if (Double.isNaN(this.meanSquare)) {
            this.image.getMoments(this.mask);
        }
        return Math.sqrt(this.meanSquare);
    }

    public ImageHandler getImage() {
        return this.image;
    }

    public ImageInt getMask() {
        return this.mask;
    }
}

