/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.util.Arrays;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class Segment3DImage {
    float lowThreshold;
    float highThreshold;
    ImageHandler imgCopy;
    int[] objID;
    int[] IDcount;
    int[] surfList;
    boolean[] IDisAtEdge;
    boolean[] isSurf;
    int width = 1;
    int height = 1;
    int nbSlices = 1;
    int nbVoxels = 1;
    int depth = 8;
    int minSize;
    int maxSize;
    int nbObj = 0;
    int nbSurfPix = 0;
    boolean sizeFilter = true;
    boolean exclude = false;

    public Segment3DImage(ImageHandler imageHandler, float f, float f2) {
        this.init(imageHandler, f, f2);
    }

    private void init(ImageHandler imageHandler, float f, float f2) {
        this.imgCopy = imageHandler.duplicate();
        this.width = imageHandler.sizeX;
        this.height = imageHandler.sizeY;
        this.nbSlices = imageHandler.sizeZ;
        this.nbVoxels = this.width * this.height * this.nbSlices;
        this.minSize = 1;
        this.maxSize = this.nbVoxels;
        this.sizeFilter = true;
        this.exclude = false;
        if (f <= f2) {
            this.lowThreshold = f;
            this.highThreshold = f2;
        } else {
            this.lowThreshold = f2;
            this.highThreshold = f;
        }
        if (this.depth != 8 && this.depth != 16) {
            throw new IllegalArgumentException("Counter3D class expects 8- or 16-bits images only");
        }
        this.nbObj = this.nbVoxels;
        this.imgArrayModifier();
    }

    public Segment3DImage(ImagePlus imagePlus, float f, float f2) {
        ImageHandler imageHandler = ImageHandler.wrap(imagePlus);
        this.init(imageHandler, f, f2);
    }

    public int getMaxSizeObject() {
        return this.maxSize;
    }

    public void setMaxSizeObject(int n) {
        this.maxSize = n;
    }

    public int getMinSizeObject() {
        return this.minSize;
    }

    public void setMinSizeObject(int n) {
        this.minSize = n;
    }

    public int getNbObj() {
        return this.nbObj;
    }

    public void segment() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = System.currentTimeMillis();
        this.objID = new int[this.nbVoxels];
        for (n3 = 1; n3 <= this.nbSlices; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                for (n = 0; n < this.width; ++n) {
                    if (n6 == n4) {
                        ++n4;
                    }
                    if (this.imgCopy.getPixel(n5) != 0.0f) {
                        n6 = n4;
                        this.objID[n5] = n6 = this.minAntTag(n6, n, n2, n3);
                    }
                    ++n5;
                }
            }
        }
        this.IDcount = new int[n4];
        for (n3 = 0; n3 < this.nbVoxels; ++n3) {
            int n7 = this.objID[n3];
            this.IDcount[n7] = this.IDcount[n7] + 1;
        }
        this.IDisAtEdge = new boolean[n4];
        Arrays.fill(this.IDisAtEdge, false);
        this.isSurf = new boolean[this.nbVoxels];
        n5 = 0;
        for (n3 = 1; n3 <= this.nbSlices; ++n3) {
            for (n2 = 0; n2 < this.height; ++n2) {
                for (n = 0; n < this.width; ++n) {
                    if (this.imgCopy.getPixel(n5) != 0.0f) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        n6 = this.objID[n5];
                        int n12 = 0;
                        int n13 = 0;
                        for (n11 = n3 - 1; n11 <= n3 + 1; ++n11) {
                            for (n10 = n2 - 1; n10 <= n2 + 1; ++n10) {
                                for (n9 = n - 1; n9 <= n + 1; ++n9) {
                                    if (n9 < 0 || n9 >= this.width || n10 < 0 || n10 >= this.height || n11 < 1 || n11 > this.nbSlices) continue;
                                    n8 = this.offset(n9, n10, n11);
                                    if (this.imgCopy.getPixel(n8) != 0.0f) {
                                        if (this.nbSlices > 1 && (n9 == n && n10 == n2 && n11 == n3 - 1 || n9 == n && n10 == n2 && n11 == n3 + 1) || n9 == n && n10 == n2 - 1 && n11 == n3 || n9 == n && n10 == n2 + 1 && n11 == n3 || n9 == n - 1 && n10 == n2 && n11 == n3 || n9 == n + 1 && n10 == n2 && n11 == n3) {
                                            ++n12;
                                        }
                                        n6 = Math.min(n6, this.objID[n8]);
                                    }
                                    ++n13;
                                }
                            }
                        }
                        if (n12 != 6 && this.nbSlices > 1 || n12 != 4 && this.nbSlices == 1) {
                            this.isSurf[n5] = true;
                            ++this.nbSurfPix;
                        } else {
                            this.isSurf[n5] = false;
                        }
                        for (n11 = n3 - 1; n11 <= n3 + 1; ++n11) {
                            for (n10 = n2 - 1; n10 <= n2 + 1; ++n10) {
                                for (n9 = n - 1; n9 <= n + 1; ++n9) {
                                    int n14;
                                    if (n9 < 0 || n9 >= this.width || n10 < 0 || n10 >= this.height || n11 < 1 || n11 > this.nbSlices || this.imgCopy.getPixel(n8 = this.offset(n9, n10, n11)) == 0.0f || (n14 = this.objID[n8]) <= n6) continue;
                                    this.replaceID(n14, n6);
                                }
                            }
                        }
                        if (n == 0 || n2 == 0 || n == this.width - 1 || n2 == this.height - 1 || this.nbSlices != 1 && (n3 == 1 || n3 == this.nbSlices)) {
                            this.IDisAtEdge[n6] = true;
                        }
                    }
                    ++n5;
                }
            }
        }
        n3 = 0;
        for (n2 = 1; n2 < this.IDcount.length; ++n2) {
            if (!(this.IDcount[n2] == 0 || this.IDcount[n2] < this.minSize || this.IDcount[n2] > this.maxSize || this.exclude && this.exclude && this.IDisAtEdge[n2])) {
                n = this.IDcount[n2];
                this.replaceID(n2, ++n3);
                this.IDcount[n3] = n;
                continue;
            }
            this.replaceID(n2, 0);
        }
        this.nbObj = n3;
    }

    public ImageInt getLabelledObjectsImage3D() {
        return this.buildImg(this.objID);
    }

    public ImageStack getLabelledObjectsStack() {
        return this.getLabelledObjectsImage3D().getImageStack();
    }

    public ImageInt getSurfaceObjectsImage3D() {
        this.surfList = new int[this.nbVoxels];
        for (int i = 0; i < this.nbVoxels; ++i) {
            this.surfList[i] = this.isSurf[i] ? this.objID[i] : 0;
        }
        return this.buildImg(this.surfList);
    }

    public ImageStack getSurfaceObjectsStack() {
        return this.getSurfaceObjectsImage3D().getImageStack();
    }

    private int minAntTag(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n;
        for (n6 = n3 - 1; n6 <= n3 + 1; ++n6) {
            for (int i = n2 - 1; i <= n2 + 1; ++i) {
                if (i < 0 || i >= this.width || n6 < 0 || n6 >= this.height || n4 - 1 < 1 || n4 - 1 > this.nbSlices || this.imgCopy.getPixel(n5 = this.offset(i, n6, n4 - 1)) == 0.0f) continue;
                n7 = Math.min(n7, this.objID[n5]);
            }
        }
        for (n6 = n2 - 1; n6 <= n2 + 1; ++n6) {
            if (n6 < 0 || n6 >= this.width || n3 - 1 < 0 || n3 - 1 >= this.height || n4 < 1 || n4 > this.nbSlices || this.imgCopy.getPixel(n5 = this.offset(n6, n3 - 1, n4)) == 0.0f) continue;
            n7 = Math.min(n7, this.objID[n5]);
        }
        if (n2 - 1 >= 0 && n2 - 1 < this.width && n3 >= 0 && n3 < this.height && n4 >= 1 && n4 <= this.nbSlices && this.imgCopy.getPixel(n5 = this.offset(n2 - 1, n3, n4)) != 0.0f && n2 >= 1 && n3 >= 0 && n4 >= 1) {
            n7 = Math.min(n7, this.objID[n5]);
        }
        return n7;
    }

    private int offset(int n, int n2, int n3) {
        if (n + n2 * this.width + (n3 - 1) * this.width * this.height >= this.width * this.height * this.nbSlices) {
            return this.width * this.height * this.nbSlices - 1;
        }
        if (n + n2 * this.width + (n3 - 1) * this.width * this.height < 0) {
            return 0;
        }
        return n + n2 * this.width + (n3 - 1) * this.width * this.height;
    }

    private void replaceID(int n, int n2) {
        if (n != n2) {
            int n3 = 0;
            for (int i = 0; i < this.objID.length; ++i) {
                if (this.objID[i] == n) {
                    this.objID[i] = n2;
                    ++n3;
                }
                if (n3 != this.IDcount[n]) continue;
                i = this.objID.length;
            }
            this.IDcount[n] = 0;
            int n4 = n2;
            this.IDcount[n4] = this.IDcount[n4] + n3;
        }
    }

    private void imgArrayModifier() {
        int n = 0;
        for (int i = 0; i < this.nbSlices; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    float f = this.imgCopy.getPixel(k, j, i);
                    if (f < this.lowThreshold || f > this.highThreshold) {
                        this.imgCopy.setPixel(n, 0.0f);
                        --this.nbObj;
                    } else {
                        this.imgCopy.setPixel(n, f);
                    }
                    ++n;
                }
            }
        }
        if (this.nbObj <= 0) {
            IJ.log((String)"No object found");
        }
    }

    private ImageInt buildImg(int[] nArray) {
        int n = 0;
        ImageShort imageShort = new ImageShort("Objects", this.width, this.height, this.nbSlices);
        for (int i = 0; i < this.nbSlices; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    int n2 = nArray[n];
                    if (n2 != 0) {
                        ((ImageInt)imageShort).setPixel(k, j, i, n2);
                    }
                    ++n;
                }
            }
        }
        return imageShort;
    }
}

