package plugins.ylemontag.noisegenerator;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Abstract block that generate one of the available noise model
 */
public abstract class NoiseModelBlock extends Plugin implements Block, PluginBundled
{
	private Var<NoiseModel> _noiseModel = new Var<NoiseModel>("Noise model", NoiseModel.class);

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_noiseModel);
	}

	@Override
	public String getMainPluginClassName()
	{
		return NoiseGeneratorPlugin.class.getName();
	}

	@Override
	public void run()
	{
		_noiseModel.setValue(generateNoiseModel());
	}
	
	/**
	 * Core function to implement in derived classes to generate a new noise model
	 */
	protected abstract NoiseModel generateNoiseModel();
}
