package plugins.ylemontag.noisegenerator.noisemodels;

import icy.util.StringUtil;

import java.util.Random;

import plugins.ylemontag.noisegenerator.IllegalNoiseModelArgumentException;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Modelize a white Gaussian additive noise of variance 'sigma^2'
 */
public class GaussianNoise extends PixelSeparableStationaryNoise
{
	private double _sigma;
	private Random _gen  ;
	
	/**
	 * Constructor
	 * @throws IllegalNoiseModelArgumentException If sigma<0
	 */
	public GaussianNoise(double sigma)
	{
		if(sigma<0) {
			throw new IllegalNoiseModelArgumentException(
				"Gaussian noise standard deviation (sigma) must be positive."
			);
		}
		_sigma = sigma;
		_gen   = new Random();
	}
	
	@Override
	protected double generateNoise(double in)
	{
		return in + _sigma*_gen.nextGaussian();
	}

	@Override
	protected String describeNoise(String inName)
	{
		return inName + " + N(0," + StringUtil.toString(_sigma) + "^2)";
	}
}
