/*
 * Decompiled with CFR 0.152.
 */
package weiss.utils;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import weiss.ellipse2D.Ellipso2D;
import weiss.line2D.Segment2D;
import weiss.utils.Data;

public class Manager
extends Overlay {
    private List<int[]> listePoint = new LinkedList<int[]>();
    private List<Overlay> listOverlay = new LinkedList<Overlay>();
    private Sequence se;
    private State state;
    private PrintWriter pw;
    private List<Data> listeData = new LinkedList<Data>();
    private String nameBegin;

    public Manager(String name, Sequence se, String nameBegin) {
        super(name);
        this.se = se;
        this.nameBegin = nameBegin;
        this.state = State.FIRST_POINT;
    }

    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        super.mouseClick(e, imagePoint, canvas);
        if (e.getButton() == 1) {
            switch (this.state) {
                case FIRST_POINT: {
                    if (!this.listOverlay.isEmpty() && !this.listePoint.isEmpty()) {
                        this.listOverlay.clear();
                        this.listePoint.clear();
                    }
                    this.listePoint.add(new int[]{(int)imagePoint.getX(), (int)imagePoint.getY()});
                    int[] coord1 = this.listePoint.get(0);
                    Overlay o = new Segment2D(coord1[0], coord1[1], coord1[0], coord1[1]).toOverlay();
                    this.listOverlay.add(o);
                    this.se.addOverlay(o);
                    this.state = State.SECOND_POINT;
                    break;
                }
                case SECOND_POINT: {
                    this.listePoint.add(new int[]{(int)imagePoint.getX(), (int)imagePoint.getY()});
                    int[] coord1 = this.listePoint.get(0);
                    int[] coord2 = this.listePoint.get(1);
                    Overlay o = new Segment2D(coord1[0], coord1[1], coord2[0], coord2[1]).toOverlay();
                    this.listOverlay.add(o);
                    this.se.addOverlay(o);
                    this.state = State.THIRD_POINT;
                    break;
                }
                case THIRD_POINT: {
                    this.listePoint.add(new int[]{(int)imagePoint.getX(), (int)imagePoint.getY()});
                    int x1 = this.listePoint.get(0)[0];
                    int y1 = this.listePoint.get(0)[1];
                    int x2 = this.listePoint.get(1)[0];
                    int y2 = this.listePoint.get(1)[1];
                    int x3 = this.listePoint.get(2)[0];
                    int y3 = this.listePoint.get(2)[1];
                    Overlay o = this.calculateParamEllipse(x1, y1, x2, y2, x3, y3);
                    this.listOverlay.add(o);
                    this.se.addOverlay(o);
                    this.se.removeOverlay(this.listOverlay.get(0));
                    this.se.removeOverlay(this.listOverlay.get(1));
                    this.state = State.FIRST_POINT;
                    break;
                }
            }
        } else if (e.getButton() == 3) {
            switch (this.state) {
                case FIRST_POINT: {
                    if (this.listOverlay.isEmpty() || this.listePoint.isEmpty()) break;
                    this.se.removeOverlay(this.listOverlay.get(2));
                    this.se.addOverlay(this.listOverlay.get(0));
                    this.se.addOverlay(this.listOverlay.get(1));
                    this.listOverlay.remove(2);
                    this.listePoint.remove(2);
                    this.listeData.remove(this.listeData.size() - 1);
                    this.state = State.THIRD_POINT;
                    break;
                }
                case SECOND_POINT: {
                    this.se.removeOverlay(this.listOverlay.get(0));
                    this.listOverlay.remove(0);
                    this.listePoint.remove(0);
                    this.state = State.FIRST_POINT;
                    break;
                }
                case THIRD_POINT: {
                    this.se.removeOverlay(this.listOverlay.get(1));
                    this.listOverlay.remove(1);
                    this.listePoint.remove(1);
                    this.state = State.SECOND_POINT;
                    break;
                }
            }
        }
    }

    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        super.keyPressed(e, imagePoint, canvas);
        if (e.getKeyCode() == 32 && this.state != State.END) {
            JFrame j = new JFrame();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Specify a file to save");
            int userSelection = fileChooser.showSaveDialog(j);
            if (userSelection == 0) {
                File f = fileChooser.getSelectedFile();
                try {
                    this.pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                int i = 0;
                while (i < this.listeData.size()) {
                    Data tmp = this.listeData.get(i);
                    this.pw.println("a : " + tmp.getA() + " b : " + tmp.getB() + " alpha : " + tmp.getAlpha() + " x0 : " + tmp.getX0() + " y0 : " + tmp.getY0());
                    ++i;
                }
                this.pw.close();
                j = new JFrame();
                JOptionPane.showMessageDialog(j, "Data saved !");
                this.se.setName(this.nameBegin);
                this.state = State.END;
            }
        }
    }

    public Overlay calculateParamEllipse(int x1, int y1, int x2, int y2, int x3, int y3) {
        double x0 = (x1 + x2) / 2;
        double y0 = (y1 + y2) / 2;
        double a = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) / 2.0;
        double tmp1 = (double)y2 - y0;
        double tmp2 = (double)x2 - x0;
        double tmp3 = tmp1 / tmp2;
        double alpha = Math.atan(tmp3);
        double Q1 = 1.0 / a * (Math.cos(alpha) * ((double)x3 - x0) + Math.sin(alpha) * ((double)y3 - y0));
        double Q2 = Math.cos(alpha) * ((double)y3 - y0) - Math.sin(alpha) * ((double)x3 - x0);
        double b = Math.sqrt(Q2 * Q2 / (1.0 - Q1 * Q1));
        Ellipso2D el = new Ellipso2D(x0, y0, a, b, alpha);
        el.setColor(Color.RED);
        Data tmp = new Data(a, b, alpha, x0, y0);
        this.listeData.add(tmp);
        Overlay o = el.toOverlay();
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        FIRST_POINT,
        SECOND_POINT,
        THIRD_POINT,
        END;

    }
}

